/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.gpsnmea.lines;

import com.vividsolutions.jump.workbench.ui.plugin.gpsnmea.lines.CoordinatesToLineAlgorithm;
import de.riwagis.unit.DrawingUnit;
import java.util.LinkedList;
import java.util.List;
import org.locationtech.jts.algorithm.Angle;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

public class DefaultCoordinatesToLineAlgorithm
implements CoordinatesToLineAlgorithm {
    public static final double ONE_DEGREE = Math.toRadians(1.0);
    private final GeometryFactory geometryFactory;
    private final DrawingUnit du;

    public DefaultCoordinatesToLineAlgorithm(DrawingUnit du) {
        this(new GeometryFactory(), du);
    }

    public DefaultCoordinatesToLineAlgorithm(GeometryFactory gfac, DrawingUnit du) {
        this.geometryFactory = gfac;
        this.du = du;
    }

    @Override
    public Geometry calculateLine(List<Coordinate> trackLinePoints) {
        Coordinate lastPoint = null;
        LinkedList<Coordinate> trackLineTransPoints = new LinkedList<Coordinate>();
        for (int i = 0; i < trackLinePoints.size(); ++i) {
            Coordinate currCoord = trackLinePoints.get(i);
            if (i == 0 || i == trackLinePoints.size() - 1) {
                trackLineTransPoints.add(currCoord);
                if (trackLinePoints.size() == 1) {
                    trackLineTransPoints.add(currCoord);
                }
            } else if (lastPoint != null) {
                double unitInMeter;
                Coordinate nextPoint = trackLinePoints.get(i + 1);
                double nextDirection = Angle.angle((Coordinate)currCoord, (Coordinate)nextPoint);
                double lastDirection = Angle.angle((Coordinate)lastPoint, (Coordinate)currCoord);
                double d = unitInMeter = this.du == null ? 1.0 : this.du.getUnitInMeter();
                if (lastPoint.distance(currCoord) * unitInMeter >= 1.0 && Math.abs(lastDirection - nextDirection) > ONE_DEGREE) {
                    trackLineTransPoints.add(currCoord);
                }
            }
            lastPoint = currCoord;
        }
        if (trackLineTransPoints.size() > 1) {
            return this.geometryFactory.createLineString(trackLineTransPoints.toArray(new Coordinate[trackLineTransPoints.size()]));
        }
        return null;
    }
}

