/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.gpsnmea;

import de.riwagis.crs.CRSDefinition;
import de.riwagis.util.io.rxtx.ComPortConfiguration;
import java.util.Collection;
import java.util.LinkedHashSet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang3.ObjectUtils;

public class GPSReaderConfigModel
implements ComPortConfiguration {
    private final Collection<ChangeListener> changeListeners = new LinkedHashSet<ChangeListener>();
    private String commPortName = "";
    private Integer baudrate = 0;
    private CRSDefinition ppmCRS = null;
    private Integer ppmFallbackGPS = 10;
    private Boolean ppmIgnore = false;

    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    public void setData(ComPortConfiguration config) {
        if (config != null) {
            this.setData(config.getComPortName(), config.getBaudrate());
        }
    }

    public void setData(String commPortName, int baudrate) {
        boolean fireEvent = false;
        if (!ObjectUtils.equals((Object)this.baudrate, (Object)baudrate)) {
            this.baudrate = baudrate;
            fireEvent = true;
        }
        if (!ObjectUtils.equals((Object)this.commPortName, (Object)commPortName)) {
            this.commPortName = commPortName;
            fireEvent = true;
        }
        if (fireEvent) {
            this.fireModelChanged();
        }
    }

    private void fireModelChanged() {
        ChangeEvent ev = new ChangeEvent(this);
        for (ChangeListener listener : this.changeListeners) {
            listener.stateChanged(ev);
        }
    }

    public Integer getBaudrate() {
        return this.baudrate;
    }

    public void setBaudrate(Integer baudrate) {
        if (!ObjectUtils.equals((Object)this.baudrate, (Object)baudrate)) {
            this.baudrate = baudrate;
            this.fireModelChanged();
        }
    }

    public String getComPortName() {
        return this.commPortName;
    }

    public void setCommPortName(String commPortName) {
        if (!ObjectUtils.equals((Object)this.commPortName, (Object)commPortName)) {
            this.commPortName = commPortName;
            this.fireModelChanged();
        }
    }

    public String toString() {
        return String.format("GPS-config: %s (baud: %d)", this.getComPortName(), this.getBaudrate());
    }

    public Integer getAmountDataBits() {
        return 8;
    }

    public Integer getAmountStopBits() {
        return 1;
    }

    public Integer getAmountParityBits() {
        return 0;
    }

    public CRSDefinition getPPMCrsDefinition() {
        return this.ppmCRS;
    }

    public void setPPMCrsDefinition(CRSDefinition ppmCRS) {
        if (!ObjectUtils.equals((Object)ppmCRS, (Object)this.ppmCRS)) {
            this.ppmCRS = ppmCRS;
            this.fireModelChanged();
        }
    }

    public Integer getPPMFallbackGPS() {
        return this.ppmFallbackGPS;
    }

    public void setPPMFallbackGPS(Integer ppmFallbackGPS) {
        if (!ObjectUtils.equals((Object)this.ppmFallbackGPS, (Object)ppmFallbackGPS)) {
            this.ppmFallbackGPS = ppmFallbackGPS;
            this.fireModelChanged();
        }
    }

    public Boolean isPPMIgnore() {
        return this.ppmIgnore;
    }

    public void setPPMIgnore(Boolean ppmIgnore) {
        if (this.ppmIgnore == false == ppmIgnore) {
            this.ppmIgnore = ppmIgnore;
            this.fireModelChanged();
        }
    }
}

