/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.gpsnmea;

import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.ui.plugin.gpsnmea.GPSReaderConfigModel;
import de.riwagis.crs.CRSDefFactory;
import de.riwagis.crs.CRSDefinition;
import javax.swing.JComboBox;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GPSReaderConfigHelper {
    private static final Logger LOG = LoggerFactory.getLogger(GPSReaderConfigHelper.class);

    public static void loadConfiguration(GPSReaderConfigModel model, Blackboard bb) {
        LOG.debug(String.format("Loading GPS configuration from BlackBoard (%s)", bb));
        if (bb != null && model != null) {
            model.setData(bb.get("GPSNMEA.commPortName", ""), bb.get("GPSNMEA.commPortBaudRate", 19200));
            model.setPPMCrsDefinition(GPSReaderConfigHelper.getCRSDefinition(bb, "GPSNMEA.PPM.CRSKey"));
            model.setPPMIgnore(bb.get("GPSNMEA.PPM.Ignore", false));
            model.setPPMFallbackGPS(bb.get("GPSNMEA.PPM.FallbackGPS", 10));
        }
    }

    public static CRSDefinition getCRSDefinition(Blackboard bb, String cfgGpsnmeaPpmCrsKey) {
        String strKey = bb.get(cfgGpsnmeaPpmCrsKey, "");
        if (strKey.isEmpty()) {
            return CRSDefFactory.getDefaultCRSDefinition();
        }
        return CRSDefFactory.getCRSDefinition((String)strKey);
    }

    static void saveConfiguration(GPSReaderConfigModel model, Blackboard bb) {
        LOG.debug(String.format("Saving GPS configuration to BlackBoard (%s)", bb));
        if (bb != null && model != null) {
            bb.put("GPSNMEA.commPortName", model.getComPortName());
            bb.put("GPSNMEA.commPortBaudRate", model.getBaudrate());
            bb.put("GPSNMEA.PPM.Ignore", model.isPPMIgnore());
            bb.put("GPSNMEA.PPM.CRSKey", GPSReaderConfigHelper.formatCRSCode(model.getPPMCrsDefinition()));
            bb.put("GPSNMEA.PPM.FallbackGPS", model.getPPMFallbackGPS());
        }
    }

    public static String formatInteger(Integer value) {
        return value == null ? null : value.toString();
    }

    private static String formatCRSCode(CRSDefinition crsDefintion) {
        return crsDefintion == null ? "" : crsDefintion.getCode();
    }

    public static void fillCRS(JComboBox<CRSDefinition> comboCRS) {
        Object savedCRS = comboCRS.getSelectedItem();
        comboCRS.removeAllItems();
        comboCRS.addItem(null);
        for (CRSDefinition crsDef : CRSDefFactory.getCRSDefinitionList()) {
            if (!StringUtils.isNotBlank((CharSequence)crsDef.getCode())) continue;
            comboCRS.addItem(crsDef);
        }
        comboCRS.setSelectedItem(savedCRS);
    }

    private GPSReaderConfigHelper() {
    }
}

