/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.gpsnmea;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.ui.plugin.gpsnmea.GPSNMEAUtilsModel;
import com.vividsolutions.jump.workbench.ui.plugin.gpsnmea.GPSReaderConfigModel;
import de.riwagis.crs.CRSDefinition;
import de.riwagis.util.gui.GUISupport;
import gnu.io.CommPortIdentifier;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GPSReaderConfigDialog
extends JDialog {
    public static final int[] KNOWN_BAUDRATES = new int[]{50, 300, 1200, 2400, 4800, 9600, 19200, 38400, 57600, 115200};
    private static final Logger LOG = LoggerFactory.getLogger(GPSReaderConfigDialog.class);
    private final DefaultComboBoxModel<String> commPortsModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel<Integer> baudRateModel = new DefaultComboBoxModel();
    private boolean okPressed = false;
    private JButton btnCancel;
    private JButton btnOk;
    private JButton btnReadBaud;
    private JButton btnReadCom;
    private JComboBox<Integer> cbBaudRate;
    private JComboBox<String> cbCommPorts;
    private JCheckBox cbPPMIgnore;
    private JComboBox<CRSDefinition> cbxPPMCRS;
    private JTextField edtPPMFallbackGPS;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JLabel lblPPMCRS;
    private JLabel lblPPMFallbackGPS;
    private JLabel lblPPMIgnore;
    private JLabel lblSerialPort;
    private JPanel tabConfigPPM;
    private JPanel tabConfigSerial;
    private JTabbedPane tabsConfig;

    public static void showGPSReaderConfig(Window parent, GPSReaderConfigModel model, ComboBoxModel<CRSDefinition> crs) {
        GPSReaderConfigDialog cfgDlg = new GPSReaderConfigDialog(parent, true);
        cfgDlg.setCRS(crs);
        cfgDlg.setModel(model);
        GUISupport.centreOnScreen((Component)cfgDlg);
        cfgDlg.setVisible(true);
        if (cfgDlg.isOkPressed()) {
            cfgDlg.fillModel(model);
        }
    }

    public void fillModel(GPSReaderConfigModel model) {
        model.setCommPortName(this.cbCommPorts.getSelectedItem().toString());
        model.setBaudrate(Integer.parseInt(this.cbBaudRate.getSelectedItem().toString()));
        model.setPPMCrsDefinition((CRSDefinition)this.cbxPPMCRS.getSelectedItem());
        model.setPPMFallbackGPS(NumberUtils.toInt((String)this.edtPPMFallbackGPS.getText(), (int)10));
        model.setPPMIgnore(this.cbPPMIgnore.isSelected());
    }

    public void setModel(GPSReaderConfigModel model) {
        this.cbCommPorts.setSelectedItem(model.getComPortName());
        this.cbBaudRate.setSelectedItem(model.getBaudrate());
        this.cbxPPMCRS.setSelectedItem(model.getPPMCrsDefinition());
        this.edtPPMFallbackGPS.setText(Integer.toString(model.getPPMFallbackGPS()));
        this.cbPPMIgnore.setSelected(model.isPPMIgnore());
    }

    public GPSReaderConfigDialog(Window parent, boolean modal) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.initComponents();
        this.setTitle(I18N.getMessage("ui.plugin.gpsnmea.GPSReaderConfigDialog.title", new Object[0]));
        this.btnReadBaud.setVisible(false);
        this.btnReadCom.setVisible(false);
        this.tabsConfig.remove(0);
        this.btnReadCom.doClick();
        this.btnReadBaud.doClick();
        this.okPressed = false;
    }

    private void initComponents() {
        this.tabsConfig = new JTabbedPane();
        this.tabConfigSerial = new JPanel();
        this.lblSerialPort = new JLabel();
        this.cbCommPorts = new JComboBox();
        this.jLabel2 = new JLabel();
        this.cbBaudRate = new JComboBox();
        this.jPanel3 = new JPanel();
        this.tabConfigPPM = new JPanel();
        this.jLabel1 = new JLabel();
        this.lblPPMCRS = new JLabel();
        this.cbxPPMCRS = new JComboBox();
        this.lblPPMFallbackGPS = new JLabel();
        this.edtPPMFallbackGPS = new JTextField();
        this.lblPPMIgnore = new JLabel();
        this.cbPPMIgnore = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.btnReadCom = new JButton();
        this.btnReadBaud = new JButton();
        this.btnOk = new JButton();
        this.btnCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(300, 180));
        this.setModal(true);
        this.setName("GPSReaderConfiguration");
        this.getContentPane().setLayout(new GridBagLayout());
        this.tabConfigSerial.setName("tabConfigSerial");
        this.tabConfigSerial.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("language/jump");
        this.lblSerialPort.setText(bundle.getString("ui.plugin.gpsnmea.GPSReaderConfigDialog.serialport"));
        this.lblSerialPort.setName("lblSerialPort");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 20, 0, 6);
        this.tabConfigSerial.add((Component)this.lblSerialPort, gridBagConstraints);
        this.cbCommPorts.setEditable(true);
        this.cbCommPorts.setModel(this.commPortsModel);
        this.cbCommPorts.setName("cbCommPorts");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 20);
        this.tabConfigSerial.add(this.cbCommPorts, gridBagConstraints);
        this.jLabel2.setText(bundle.getString("ui.plugin.gpsnmea.GPSReaderConfigDialog.baudrate"));
        this.jLabel2.setName("jLabel2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 20, 0, 6);
        this.tabConfigSerial.add((Component)this.jLabel2, gridBagConstraints);
        this.cbBaudRate.setEditable(true);
        this.cbBaudRate.setName("cbBaudRate");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 20);
        this.tabConfigSerial.add(this.cbBaudRate, gridBagConstraints);
        this.jPanel3.setName("jPanel3");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.tabConfigSerial.add((Component)this.jPanel3, gridBagConstraints);
        this.tabsConfig.addTab(bundle.getString("ui.plugin.gpsnmea.GPSReaderConfigDialog.tabSerialPort.title"), this.tabConfigSerial);
        this.tabConfigPPM.setName("tabConfigPPM");
        this.tabConfigPPM.setLayout(new GridBagLayout());
        this.jLabel1.setText(bundle.getString("ui.plugin.gpsnmea.GPSReaderConfigDialog.description"));
        this.jLabel1.setName("jLabel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.tabConfigPPM.add((Component)this.jLabel1, gridBagConstraints);
        this.lblPPMCRS.setText(bundle.getString("ui.plugin.gpsnmea.GPSReaderConfigDialog.coordinatesystem"));
        this.lblPPMCRS.setToolTipText(bundle.getString("ui.plugin.gpsnmea.GPSReaderConfigDialog.coordinatesystem.tooltip"));
        this.lblPPMCRS.setName("lblPPMCRS");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.tabConfigPPM.add((Component)this.lblPPMCRS, gridBagConstraints);
        this.cbxPPMCRS.setName("cbxPPMCRS");
        this.cbxPPMCRS.setRenderer(GPSNMEAUtilsModel.buildCRSTextRenderer());
        this.cbxPPMCRS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GPSReaderConfigDialog.this.cbxPPMCRSActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.tabConfigPPM.add(this.cbxPPMCRS, gridBagConstraints);
        this.lblPPMFallbackGPS.setText(bundle.getString("ui.plugin.gpsnmea.GPSReaderConfigDialog.ppmFallbackGPS"));
        this.lblPPMFallbackGPS.setToolTipText(bundle.getString("ui.plugin.gpsnmea.GPSReaderConfigDialog.ppmFallbackGPS.tooltip"));
        this.lblPPMFallbackGPS.setName("lblPPMFallbackGPS");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.tabConfigPPM.add((Component)this.lblPPMFallbackGPS, gridBagConstraints);
        this.edtPPMFallbackGPS.setMinimumSize(new Dimension(60, 20));
        this.edtPPMFallbackGPS.setName("edtPPMFallbackGPS");
        this.edtPPMFallbackGPS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GPSReaderConfigDialog.this.edtPPMFallbackGPSActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.tabConfigPPM.add((Component)this.edtPPMFallbackGPS, gridBagConstraints);
        this.lblPPMIgnore.setText(bundle.getString("ui.plugin.gpsnmea.GPSReaderConfigDialog.ppmIgnore"));
        this.lblPPMIgnore.setToolTipText(bundle.getString("ui.plugin.gpsnmea.GPSReaderConfigDialog.ppmIgnore.tooltip"));
        this.lblPPMIgnore.setName("lblPPMIgnore");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.tabConfigPPM.add((Component)this.lblPPMIgnore, gridBagConstraints);
        this.cbPPMIgnore.setName("cbPPMIgnore");
        this.cbPPMIgnore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GPSReaderConfigDialog.this.cbPPMIgnoreActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.tabConfigPPM.add((Component)this.cbPPMIgnore, gridBagConstraints);
        this.tabsConfig.addTab(bundle.getString("ui.plugin.gpsnmea.GPSReaderConfigDialog.tabPPM.title"), this.tabConfigPPM);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.tabsConfig, gridBagConstraints);
        this.jPanel2.setName("pnlButtons");
        this.jPanel2.setLayout(new FlowLayout(2));
        this.btnReadCom.setText("ReadCom");
        this.btnReadCom.setName("btnReadCom");
        this.btnReadCom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GPSReaderConfigDialog.this.btnReadComActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.btnReadCom);
        this.btnReadBaud.setText("ReadBaud");
        this.btnReadBaud.setName("btnReadBaud");
        this.btnReadBaud.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GPSReaderConfigDialog.this.btnReadBaudActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.btnReadBaud);
        this.btnOk.setText(bundle.getString("common.ok"));
        this.btnOk.setName("btnOk");
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GPSReaderConfigDialog.this.btnOkActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.btnOk);
        this.btnCancel.setText(bundle.getString("common.cancel"));
        this.btnCancel.setName("btnCancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GPSReaderConfigDialog.this.btnCancelActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.btnCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.pack();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.okPressed = false;
    }

    private void btnReadComActionPerformed(ActionEvent evt) {
        ArrayList<String> comPorts = new ArrayList<String>();
        comPorts.clear();
        Enumeration e = CommPortIdentifier.getPortIdentifiers();
        while (e.hasMoreElements()) {
            CommPortIdentifier id = (CommPortIdentifier)e.nextElement();
            LOG.debug("COM-Port: " + String.valueOf(id));
            comPorts.add(id.getName());
        }
        Object save = this.cbCommPorts.getSelectedItem();
        this.commPortsModel.removeAllElements();
        for (String currCommPort : comPorts) {
            this.commPortsModel.addElement(currCommPort);
        }
        this.cbCommPorts.setSelectedItem(save);
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.okPressed = true;
    }

    private void cbxPPMCRSActionPerformed(ActionEvent evt) {
    }

    private void edtPPMFallbackGPSActionPerformed(ActionEvent evt) {
    }

    private void cbPPMIgnoreActionPerformed(ActionEvent evt) {
    }

    private void btnReadBaudActionPerformed(ActionEvent evt) {
        int[] nArray = KNOWN_BAUDRATES;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer currBR = nArray[i];
            this.baudRateModel.addElement(currBR);
        }
        this.cbBaudRate.setModel(this.baudRateModel);
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    @Override
    public void setVisible(boolean b) {
        if (!this.isVisible() && b) {
            this.okPressed = false;
        }
        super.setVisible(b);
    }

    private void setCRS(ComboBoxModel<CRSDefinition> crs) {
        this.cbxPPMCRS.setModel(crs);
    }
}

