/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.gpsnmea;

import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Task;
import de.riwagis.crs.CRSDefinition;
import de.riwagis.crs.Transformer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.locationtech.jts.geom.Coordinate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GPSNMEATransformation {
    private static final Logger LOG = LoggerFactory.getLogger(GPSNMEATransformation.class);
    private static final Map<String, Transformer> mtCache = new LinkedHashMap<String, Transformer>();

    public static final Transformer findMathTransfrom(CRSDefinition sourceCRS, CRSDefinition destCRS) {
        if (sourceCRS == null || destCRS == null) {
            return null;
        }
        String mtKey = String.format("%s_%s", sourceCRS.getCode(), destCRS.getCode());
        try {
            if (sourceCRS.getCRS() == null || destCRS.getCRS() == null) {
                return null;
            }
            if (!mtCache.containsKey(mtKey)) {
                Transformer tmpTrans = new Transformer(sourceCRS.getCRS(), destCRS.getCRS());
                mtCache.put(mtKey, tmpTrans);
            }
        }
        catch (Exception ex) {
            LOG.warn(String.format("unable to get math-transform (%s): %s", mtKey, ex.getMessage()), (Throwable)ex);
        }
        return mtCache.get(mtKey);
    }

    public static Coordinate transformCoordinate(Transformer mt, Coordinate coord) throws Exception {
        Coordinate coordClone = new Coordinate(coord);
        mt.transform2d(coordClone);
        return coordClone;
    }

    public static Coordinate calcCoordinate(double valueX, String hemiX, double valueY, String hemiY) throws NumberFormatException {
        boolean swapXY = "E".equalsIgnoreCase(hemiX) || "W".equalsIgnoreCase(hemiX);
        return swapXY ? new Coordinate(GPSNMEATransformation.calcOrdinate(valueX, hemiX), GPSNMEATransformation.calcOrdinate(valueY, hemiY)) : new Coordinate(GPSNMEATransformation.calcOrdinate(valueY, hemiY), GPSNMEATransformation.calcOrdinate(valueX, hemiX));
    }

    public static CRSDefinition determineDestinationCRS(CRSDefinition configuredCRS) {
        Task wbTask = WorkbenchContext.getTask();
        CRSDefinition useCRSDefinition = configuredCRS == null && wbTask != null ? wbTask.getCRSDefinition() : configuredCRS;
        return useCRSDefinition;
    }

    public static double calcOrdinate(double valueX, String orienation) {
        return "S".equalsIgnoreCase(orienation) || "W".equalsIgnoreCase(orienation) ? -valueX : valueX;
    }

    public static double calcDegrees(String value) throws NumberFormatException {
        float valueRaw = Float.parseFloat(value);
        double degreesFull = Math.floor(Math.floor(valueRaw) / 100.0);
        double degreesPart = ((double)((int)Math.floor(valueRaw) % 100) + ((double)valueRaw - Math.floor(valueRaw))) / 60.0;
        double degrees = degreesFull + degreesPart;
        return degrees;
    }

    private GPSNMEATransformation() {
    }
}

