/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.gpsnmea;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.plugin.gpsnmea.BaudRateInputVerifier;
import com.vividsolutions.jump.workbench.ui.plugin.gpsnmea.GPSNMEAHandler;
import com.vividsolutions.jump.workbench.ui.plugin.gpsnmea.GPSNMEALayerUtils;
import com.vividsolutions.jump.workbench.ui.plugin.gpsnmea.GPSNMEAPointPrecision;
import com.vividsolutions.jump.workbench.ui.plugin.gpsnmea.GPSNMEAUtilsFormat;
import com.vividsolutions.jump.workbench.ui.plugin.gpsnmea.GPSNMEAUtilsModel;
import com.vividsolutions.jump.workbench.ui.plugin.gpsnmea.GPSReaderConfigDialog;
import com.vividsolutions.jump.workbench.ui.plugin.gpsnmea.GPSReaderConfigHelper;
import com.vividsolutions.jump.workbench.ui.plugin.gpsnmea.GPSReaderConfigModel;
import de.riwagis.crs.CRSDefinition;
import de.riwagis.util.gui.GUISupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;
import org.jdesktop.swingx.VerticalLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GPSNMEAPanel
extends JPanel {
    private static final Logger LOG = LoggerFactory.getLogger(GPSNMEAPanel.class);
    private final GPSNMEAHandler handler;
    private JButton btnAddPointInLayer;
    private JButton btnAddTrackInLayer;
    private JButton btnAdvancedConfig;
    private JButton btnCenterMap;
    private JToggleButton btnConnectComPort;
    private JToggleButton btnDoTrack;
    private JToggleButton btnDoTrackPoints;
    private JButton btnResetTrack;
    private JButton btnZoomTrack;
    private JCheckBox cbFix;
    private JComboBox<CRSDefinition> cbxCRS;
    private JComboBox<Integer> cbxCommBaudRate;
    private JComboBox<String> cbxCommPorts;
    private JComboBox<Layer> cbxPointsLayer;
    private JCheckBox chbCommPortConnected;
    private JCheckBox chbFollowOnMap;
    private JCheckBox chbShowGPSCoordinate;
    private JCheckBox chbShowTrack;
    private JTextField edtCoordinate;
    private JTextField edtDateTime;
    private JTextField edtSatCount;
    private JTextField edtStatus;
    private JTextField edtTransCoordinate;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JXTaskPane jXTaskPane1;
    private JXTaskPane jXTaskPane2;
    private JXTaskPane jXTaskPane3;
    private JXTaskPane jXTaskPane4;
    private JXTaskPane jXTaskPane5;
    private JXTaskPane jXTaskPane6;
    private JXTaskPaneContainer jXTaskPaneContainer1;
    private JLabel lblCommBaudRate;
    private JLabel lblCommPorts;
    private JLabel lblLongitude;
    private JLabel lblSatCount;
    private JLabel lblStatus;
    private JLabel lblTime;
    private JPanel pnlStatus;

    public GPSNMEAPanel(GPSNMEAHandler handlerObj) {
        this.initComponents();
        this.handler = handlerObj;
        this.fillCommPortInfo();
        GPSReaderConfigHelper.fillCRS(this.cbxCRS);
        GPSNMEAPanel.resetBorderTaskPane(new JXTaskPane[]{this.jXTaskPane1, this.jXTaskPane2, this.jXTaskPane3, this.jXTaskPane4, this.jXTaskPane5, this.jXTaskPane6});
        ChangeListener configChangedListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GPSNMEAPanel.this.showVisibility();
            }
        };
        this.handler.getGPSNMEADialogModel().addChangeListener(configChangedListener);
        this.handler.getGPSReaderConfig().addChangeListener(configChangedListener);
        this.showVisibility();
    }

    private static final void resetBorderTaskPane(JXTaskPane[] panes) {
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), BorderFactory.createEmptyBorder(0, 0, 0, 0));
        for (JXTaskPane currPane : panes) {
            JXPanel taskPanel = (JXPanel)currPane.getContentPane();
            taskPanel.setOpaque(false);
            taskPanel.setBorder((Border)compoundBorder);
        }
    }

    private void fillCommPortInfo() {
        this.cbxCommPorts.setModel(this.handler.getCommPortModel());
        this.cbxCommBaudRate.setModel(this.handler.getCommBaudRateModel());
    }

    private void initComponents() {
        this.jPanel5 = new JPanel();
        this.btnConnectComPort = new JToggleButton();
        this.chbCommPortConnected = new JCheckBox();
        this.pnlStatus = new JPanel();
        this.lblStatus = new JLabel();
        this.edtStatus = new JTextField();
        this.jPanel9 = new JPanel();
        this.edtTransCoordinate = new JTextField();
        this.btnCenterMap = new JButton();
        this.jXTaskPaneContainer1 = new JXTaskPaneContainer();
        this.jXTaskPane1 = new JXTaskPane();
        this.jPanel1 = new JPanel();
        this.lblCommPorts = new JLabel();
        this.cbxCommPorts = new JComboBox();
        this.lblCommBaudRate = new JLabel();
        this.cbxCommBaudRate = new JComboBox();
        this.jPanel3 = new JPanel();
        this.btnAdvancedConfig = new JButton();
        this.jXTaskPane2 = new JXTaskPane();
        this.jPanel4 = new JPanel();
        this.jLabel5 = new JLabel();
        this.cbFix = new JCheckBox();
        this.lblSatCount = new JLabel();
        this.edtSatCount = new JTextField();
        this.lblLongitude = new JLabel();
        this.edtCoordinate = new JTextField();
        this.lblTime = new JLabel();
        this.edtDateTime = new JTextField();
        this.jXTaskPane3 = new JXTaskPane();
        this.jPanel6 = new JPanel();
        this.cbxCRS = new JComboBox();
        this.jXTaskPane4 = new JXTaskPane();
        this.jPanel8 = new JPanel();
        this.chbShowGPSCoordinate = new JCheckBox();
        this.chbShowTrack = new JCheckBox();
        this.chbFollowOnMap = new JCheckBox();
        this.jXTaskPane5 = new JXTaskPane();
        this.jPanel2 = new JPanel();
        this.jPanel2.setVisible(false);
        this.btnDoTrackPoints = new JToggleButton();
        this.cbxPointsLayer = new JComboBox();
        this.jXTaskPane6 = new JXTaskPane();
        this.jPanel7 = new JPanel();
        this.btnDoTrack = new JToggleButton();
        this.btnResetTrack = new JButton();
        this.btnAddTrackInLayer = new JButton();
        this.btnAddPointInLayer = new JButton();
        this.btnZoomTrack = new JButton();
        this.setName("GPSNMEA_PANEL");
        this.setLayout(new GridBagLayout());
        this.jPanel5.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("language/jump");
        this.btnConnectComPort.setText(bundle.getString("ui.plugin.gpsnmea.GPSNMEADialog.Connect"));
        this.btnConnectComPort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GPSNMEAPanel.this.btnConnectComPortActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 20, 3, 10);
        this.jPanel5.add((Component)this.btnConnectComPort, gridBagConstraints);
        this.chbCommPortConnected.setText(bundle.getString("ui.plugin.gpsnmea.GPSNMEADialog.connectionEstablishedShort"));
        this.chbCommPortConnected.setEnabled(false);
        this.chbCommPortConnected.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel5.add((Component)this.chbCommPortConnected, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel5, gridBagConstraints);
        this.pnlStatus.setLayout(new BorderLayout());
        this.lblStatus.setLabelFor(this.edtStatus);
        this.lblStatus.setText(bundle.getString("ui.plugin.gpsnmea.GPSNMEAPanel.Status"));
        this.pnlStatus.add((Component)this.lblStatus, "West");
        this.edtStatus.setEditable(false);
        this.edtStatus.setHorizontalAlignment(0);
        this.edtStatus.setText(".");
        this.edtStatus.setBorder(new LineBorder(new Color(0, 0, 0), 1, true));
        this.pnlStatus.add((Component)this.edtStatus, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 5, 1, 5);
        this.add((Component)this.pnlStatus, gridBagConstraints);
        this.jPanel9.setBorder(BorderFactory.createTitledBorder(bundle.getString("ui.plugin.gpsnmea.GPSNMEADialog.Coordinate")));
        this.jPanel9.setLayout(new GridBagLayout());
        this.edtTransCoordinate.setEditable(false);
        this.edtTransCoordinate.setMinimumSize(new Dimension(80, 20));
        this.edtTransCoordinate.setPreferredSize(new Dimension(80, 20));
        this.edtTransCoordinate.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel9.add((Component)this.edtTransCoordinate, gridBagConstraints);
        this.btnCenterMap.setText(bundle.getString("ui.plugin.gpsnmea.GPSNMEADialog.Center_Map"));
        this.btnCenterMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GPSNMEAPanel.this.btnCenterMapActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel9.add((Component)this.btnCenterMap, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel9, gridBagConstraints);
        this.jXTaskPaneContainer1.setBackground(new Color(212, 208, 200));
        this.jXTaskPaneContainer1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        VerticalLayout verticalLayout1 = new VerticalLayout();
        verticalLayout1.setGap(1);
        this.jXTaskPaneContainer1.setLayout((LayoutManager)verticalLayout1);
        this.jXTaskPane1.setBackground(new Color(212, 208, 200));
        this.jXTaskPane1.setForeground(new Color(0, 0, 0));
        this.jXTaskPane1.setCollapsed(true);
        this.jXTaskPane1.setTitle(bundle.getString("ui.plugin.gpsnmea.GPSNMEADialog.interface"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.lblCommPorts.setText(bundle.getString("ui.plugin.gpsnmea.GPSNMEADialog.serialPort"));
        this.lblCommPorts.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        this.jPanel1.add((Component)this.lblCommPorts, gridBagConstraints);
        this.cbxCommPorts.setMinimumSize(new Dimension(90, 22));
        this.cbxCommPorts.setPreferredSize(new Dimension(90, 22));
        this.cbxCommPorts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GPSNMEAPanel.this.cbxCommPortsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 5, 1, 5);
        this.jPanel1.add(this.cbxCommPorts, gridBagConstraints);
        this.lblCommBaudRate.setText(bundle.getString("ui.plugin.gpsnmea.GPSNMEADialog.baudRate"));
        this.lblCommBaudRate.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        this.jPanel1.add((Component)this.lblCommBaudRate, gridBagConstraints);
        this.cbxCommBaudRate.setMinimumSize(new Dimension(90, 22));
        this.cbxCommBaudRate.setPreferredSize(new Dimension(90, 22));
        this.cbxCommBaudRate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GPSNMEAPanel.this.cbxCommBaudRateActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 5, 1, 5);
        this.jPanel1.add(this.cbxCommBaudRate, gridBagConstraints);
        this.jPanel3.setLayout(new FlowLayout(2));
        this.btnAdvancedConfig.setText(bundle.getString("ui.plugin.gpsnmea.GPSNMEADialog.advanced_config"));
        this.btnAdvancedConfig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GPSNMEAPanel.this.btnAdvancedConfigActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.btnAdvancedConfig);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanel3, gridBagConstraints);
        this.jXTaskPane1.add((Component)this.jPanel1, (Object)"Center");
        this.jXTaskPaneContainer1.add((Component)this.jXTaskPane1);
        this.jXTaskPane2.setBackground(new Color(212, 208, 200));
        this.jXTaskPane2.setForeground(new Color(0, 0, 0));
        this.jXTaskPane2.setTitle(bundle.getString("ui.plugin.gpsnmea.GPSNMEADialog.GPSData"));
        this.jPanel4.setLayout(new GridBagLayout());
        this.jLabel5.setText(bundle.getString("ui.plugin.gpsnmea.GPSNMEADialog.Fix"));
        this.jLabel5.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        this.jPanel4.add((Component)this.jLabel5, gridBagConstraints);
        this.cbFix.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel4.add((Component)this.cbFix, gridBagConstraints);
        this.lblSatCount.setText(bundle.getString("ui.plugin.gpsnmea.GPSNMEADialog.Sat"));
        this.lblSatCount.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        this.jPanel4.add((Component)this.lblSatCount, gridBagConstraints);
        this.edtSatCount.setEditable(false);
        this.edtSatCount.setMinimumSize(new Dimension(80, 20));
        this.edtSatCount.setPreferredSize(new Dimension(80, 20));
        this.edtSatCount.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel4.add((Component)this.edtSatCount, gridBagConstraints);
        this.lblLongitude.setText(bundle.getString("ui.plugin.gpsnmea.GPSNMEADialog.Coordinate"));
        this.lblLongitude.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        this.jPanel4.add((Component)this.lblLongitude, gridBagConstraints);
        this.edtCoordinate.setEditable(false);
        this.edtCoordinate.setMinimumSize(new Dimension(80, 20));
        this.edtCoordinate.setPreferredSize(new Dimension(80, 20));
        this.edtCoordinate.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel4.add((Component)this.edtCoordinate, gridBagConstraints);
        this.lblTime.setText(bundle.getString("ui.plugin.gpsnmea.GPSNMEADialog.Time"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        this.jPanel4.add((Component)this.lblTime, gridBagConstraints);
        this.edtDateTime.setEditable(false);
        this.edtDateTime.setMinimumSize(new Dimension(80, 20));
        this.edtDateTime.setPreferredSize(new Dimension(80, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel4.add((Component)this.edtDateTime, gridBagConstraints);
        this.jXTaskPane2.add((Component)this.jPanel4, (Object)"Center");
        this.jXTaskPaneContainer1.add((Component)this.jXTaskPane2);
        this.jXTaskPane3.setForeground(new Color(0, 0, 0));
        this.jXTaskPane3.setCollapsed(true);
        this.jXTaskPane3.setTitle(bundle.getString("ui.plugin.gpsnmea.GPSNMEADialog.CalculateToCRS"));
        this.jXTaskPane3.setLayout((LayoutManager)new GridBagLayout());
        this.jPanel6.setLayout(new GridBagLayout());
        this.cbxCRS.setPreferredSize(new Dimension(100, 22));
        this.cbxCRS.setRenderer(GPSNMEAUtilsModel.buildCRSTextRenderer());
        this.cbxCRS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GPSNMEAPanel.this.cbxCRSActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.jPanel6.add(this.cbxCRS, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jXTaskPane3.add((Component)this.jPanel6, (Object)gridBagConstraints);
        this.jXTaskPaneContainer1.add((Component)this.jXTaskPane3);
        this.jXTaskPane4.setForeground(new Color(0, 0, 0));
        this.jXTaskPane4.setCollapsed(true);
        this.jXTaskPane4.setTitle(bundle.getString("ui.plugin.gpsnmea.GPSNMEADialog.View"));
        this.jXTaskPane4.setLayout((LayoutManager)new GridBagLayout());
        this.jPanel8.setLayout(new GridBagLayout());
        this.chbShowGPSCoordinate.setText(bundle.getString("ui.plugin.gpsnmea.GPSNMEADialog.ShowGPS"));
        this.chbShowGPSCoordinate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GPSNMEAPanel.this.chbShowGPSCoordinateActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 1, 5);
        this.jPanel8.add((Component)this.chbShowGPSCoordinate, gridBagConstraints);
        this.chbShowTrack.setText(bundle.getString("ui.plugin.gpsnmea.GPSNMEADialog.ShowTrack"));
        this.chbShowTrack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GPSNMEAPanel.this.chbShowTrackActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 1, 5);
        this.jPanel8.add((Component)this.chbShowTrack, gridBagConstraints);
        this.chbFollowOnMap.setText(bundle.getString("ui.plugin.gpsnmea.GPSNMEADialog.Follow_on_map"));
        this.chbFollowOnMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GPSNMEAPanel.this.chbFollowOnMapActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 1, 5);
        this.jPanel8.add((Component)this.chbFollowOnMap, gridBagConstraints);
        this.jXTaskPane4.add((Component)this.jPanel8);
        this.jXTaskPaneContainer1.add((Component)this.jXTaskPane4);
        this.jXTaskPane5.setForeground(new Color(0, 0, 0));
        this.jXTaskPane5.setCollapsed(true);
        this.jXTaskPane5.setTitle(bundle.getString("ui.plugin.gpsnmea.GPSNMEADialog.TrackPoints"));
        this.jXTaskPane5.setLayout((LayoutManager)new GridBagLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        this.btnDoTrackPoints.setText(bundle.getString("ui.plugin.gpsnmea.GPSNMEADialog.doTrackPoints"));
        this.btnDoTrackPoints.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GPSNMEAPanel.this.btnDoTrackPointsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 1, 5);
        this.jPanel2.add((Component)this.btnDoTrackPoints, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 1, 5);
        this.jPanel2.add(this.cbxPointsLayer, gridBagConstraints);
        this.jXTaskPane5.add((Component)this.jPanel2);
        this.jXTaskPaneContainer1.add((Component)this.jXTaskPane5);
        this.jXTaskPane5.setVisible(false);
        this.jXTaskPane6.setForeground(new Color(0, 0, 0));
        this.jXTaskPane6.setCollapsed(true);
        this.jXTaskPane6.setTitle(bundle.getString("ui.plugin.gpsnmea.GPSNMEADialog.Edit"));
        this.jXTaskPane6.setLayout((LayoutManager)new GridBagLayout());
        this.jPanel7.setLayout(new GridBagLayout());
        this.btnDoTrack.setText(bundle.getString("ui.plugin.gpsnmea.GPSNMEADialog.doTrackLines"));
        this.btnDoTrack.setPreferredSize(new Dimension(93, 23));
        this.btnDoTrack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GPSNMEAPanel.this.btnDoTrackActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 1, 5);
        this.jPanel7.add((Component)this.btnDoTrack, gridBagConstraints);
        this.btnResetTrack.setText(bundle.getString("ui.plugin.gpsnmea.GPSNMEADialog.ResetTrack"));
        this.btnResetTrack.setPreferredSize(new Dimension(93, 23));
        this.btnResetTrack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GPSNMEAPanel.this.btnResetTrackActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 1, 5);
        this.jPanel7.add((Component)this.btnResetTrack, gridBagConstraints);
        this.btnAddTrackInLayer.setText(bundle.getString("ui.plugin.gpsnmea.GPSNMEADialog.CreateTrackInLayer"));
        this.btnAddTrackInLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GPSNMEAPanel.this.btnAddTrackInLayerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 1, 5);
        this.jPanel7.add((Component)this.btnAddTrackInLayer, gridBagConstraints);
        this.btnAddPointInLayer.setText(bundle.getString("ui.plugin.gpsnmea.GPSNMEADialog.CreatePointInLayer"));
        this.btnAddPointInLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GPSNMEAPanel.this.btnAddPointInLayerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 1, 5);
        this.jPanel7.add((Component)this.btnAddPointInLayer, gridBagConstraints);
        this.btnZoomTrack.setText(bundle.getString("ui.plugin.gpsnmea.GPSNMEADialog.Center_Track"));
        this.btnZoomTrack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GPSNMEAPanel.this.btnZoomTrackActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 1, 5);
        this.jPanel7.add((Component)this.btnZoomTrack, gridBagConstraints);
        this.jXTaskPane6.add((Component)this.jPanel7);
        this.jXTaskPaneContainer1.add((Component)this.jXTaskPane6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jXTaskPaneContainer1, gridBagConstraints);
    }

    private void btnConnectComPortActionPerformed(ActionEvent evt) {
        if (this.btnConnectComPort.isSelected()) {
            if (!this.handler.isGPSAvailable()) {
                try {
                    this.handler.startReading();
                }
                catch (IOException ioex) {
                    GUISupport.msgbox((Component)this, (String)I18N.getMessage("ui.plugin.gpsnmea.GPSNMEADialog.Error_opening_Port", ioex.getMessage()), (String)I18N.get("common.error"));
                    this.btnConnectComPort.setSelected(false);
                }
            } else {
                GUISupport.msgbox((Component)this, (String)I18N.get("ui.plugin.gpsnmea.GPSNMEADialog.GPS_already_connected._Disconnect_first."), (String)I18N.get("common.error"));
            }
        } else if (this.handler.isGPSAvailable()) {
            this.handler.stopReading();
        } else {
            GUISupport.msgbox((Component)this, (String)I18N.get("ui.plugin.gpsnmea.GPSNMEADialog.GPS_already_disconnected"), (String)I18N.get("common.error"));
        }
    }

    private void cbxCRSActionPerformed(ActionEvent evt) {
        this.handler.setCrsDefinition((CRSDefinition)this.cbxCRS.getSelectedItem());
    }

    private void chbFollowOnMapActionPerformed(ActionEvent evt) {
        this.handler.setFollowOnMap(this.chbFollowOnMap.isSelected());
        this.showVisibility();
    }

    private void btnCenterMapActionPerformed(ActionEvent evt) {
        this.handler.setGPSCenter();
    }

    private void btnZoomTrackActionPerformed(ActionEvent evt) {
        this.handler.zoomTrack();
    }

    private void chbShowGPSCoordinateActionPerformed(ActionEvent evt) {
        this.handler.setShowGPSCoordinate(this.chbShowGPSCoordinate.isSelected());
        this.showVisibility();
    }

    private void btnAddPointInLayerActionPerformed(ActionEvent evt) {
        try {
            this.handler.tryCreatePoint();
        }
        catch (Exception ex) {
            GUISupport.msgbox((Component)this, (String)ex.getMessage(), (String)I18N.get("common.error"));
        }
    }

    private void btnDoTrackPointsActionPerformed(ActionEvent evt) {
        if (!this.btnDoTrackPoints.isSelected()) {
            GPSNMEAUtilsModel.refillPointLayer(this.cbxPointsLayer);
        }
        this.handler.setDoTrackPoints(this.btnDoTrackPoints.isSelected());
        this.handler.setDoTrackPointsLayerKey(this.cbxPointsLayer.getSelectedItem() == null ? null : ((Layer)this.cbxPointsLayer.getSelectedItem()).getKey());
        this.showVisibility();
    }

    private void chbShowTrackActionPerformed(ActionEvent evt) {
        this.handler.setShowGPSTrack(this.chbShowTrack.isSelected());
        this.showVisibility();
    }

    private void btnDoTrackActionPerformed(ActionEvent evt) {
        this.handler.setTracking(this.btnDoTrack.isSelected());
        this.showVisibility();
    }

    private void btnResetTrackActionPerformed(ActionEvent evt) {
        this.handler.resetTrack();
    }

    private void btnAddTrackInLayerActionPerformed(ActionEvent evt) {
        try {
            this.handler.tryCreateLine();
        }
        catch (Exception ex) {
            LOG.error("Error creating line", (Throwable)ex);
            GUISupport.msgbox((Component)this, (String)ex.getMessage(), (String)I18N.get("common.error"));
        }
    }

    private void cbxCommBaudRateActionPerformed(ActionEvent evt) {
        if (this.handler != null) {
            this.handler.getGPSReaderConfig().setBaudrate(BaudRateInputVerifier.parseBaudRate(this.cbxCommBaudRate.getSelectedItem()));
        }
    }

    private void cbxCommPortsActionPerformed(ActionEvent evt) {
        if (this.handler != null) {
            this.handler.getGPSReaderConfig().setCommPortName(this.cbxCommPorts.getSelectedItem() == null ? "" : this.cbxCommPorts.getSelectedItem().toString());
        }
    }

    private void btnAdvancedConfigActionPerformed(ActionEvent evt) {
        GPSReaderConfigDialog.showGPSReaderConfig(null, this.handler.getGPSReaderConfig(), this.cbxCRS.getModel());
    }

    private void showVisibility() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GPSNMEAPanel.this.cbxCommBaudRate.setEditable(!GPSNMEAPanel.this.handler.isGPSAvailable());
                GPSNMEAPanel.this.cbxCommPorts.setEditable(!GPSNMEAPanel.this.handler.isGPSAvailable());
                GPSNMEAPanel.this.cbxCommBaudRate.setEnabled(!GPSNMEAPanel.this.handler.isGPSAvailable());
                GPSNMEAPanel.this.cbxCommPorts.setEnabled(!GPSNMEAPanel.this.handler.isGPSAvailable());
                GPSNMEAPanel.this.chbCommPortConnected.setSelected(GPSNMEAPanel.this.handler.isGPSAvailable());
                GPSNMEAPanel.this.cbxPointsLayer.setEnabled(!GPSNMEAPanel.this.btnDoTrackPoints.isSelected());
                GPSNMEAPanel.this.btnAddPointInLayer.setEnabled(GPSNMEAPanel.this.handler.hasLastTransPoint() && GPSNMEALayerUtils.canCreatePoints(EditingPanel.instanceOf().getCurrentLayer()));
                GPSNMEAPanel.this.btnAddTrackInLayer.setEnabled(GPSNMEALayerUtils.canCreateLines(EditingPanel.instanceOf().getCurrentLayer()) && GPSNMEAPanel.this.handler.hasTrackLine());
                GPSNMEAPanel.this.btnDoTrack.setSelected(GPSNMEAPanel.this.handler.isTracking());
                GPSNMEAPanel.this.chbShowGPSCoordinate.setSelected(GPSNMEAPanel.this.handler.isShowGPSCoordinate());
                GPSNMEAPanel.this.chbShowTrack.setSelected(GPSNMEAPanel.this.handler.isShowGPSTrack());
                GPSNMEAPanel.this.chbFollowOnMap.setSelected(GPSNMEAPanel.this.handler.isFollowOnMap());
                GPSNMEAPanel.setComboBoxWhenDiffers(GPSNMEAPanel.this.cbxCRS, GPSNMEAPanel.this.handler.getCrsDefinition());
                GPSNMEAPanel.this.jXTaskPane5.setVisible(false);
                GPSNMEAPanel.setEdtTextWhenDiffers(GPSNMEAPanel.this.edtCoordinate, GPSNMEAUtilsFormat.formatCoordinate(GPSNMEAPanel.this.handler.getGPSNMEADialogModel().getLastPoint()));
                GPSNMEAPanel.setEdtTextWhenDiffers(GPSNMEAPanel.this.edtTransCoordinate, GPSNMEAUtilsFormat.formatCoordinate(GPSNMEAPanel.this.handler.getGPSNMEADialogModel().getLastTransPoint()));
                GPSNMEAPanel.setEdtTextWhenDiffers(GPSNMEAPanel.this.edtDateTime, GPSNMEAUtilsFormat.formatDateTime(GPSNMEAPanel.this.handler.getGPSNMEADialogModel().getLastDate()));
                GPSNMEAPanel.this.cbFix.setSelected(GPSNMEAPanel.this.handler.getGPSNMEADialogModel().hasFix());
                GPSNMEAPanel.setEdtTextWhenDiffers(GPSNMEAPanel.this.edtSatCount, I18N.getMessage("ui.plugin.gpsnmea.GPSNMEADialog.formatInt", GPSNMEAPanel.this.handler.getGPSNMEADialogModel().getLastNumberOfSatellites()));
                GPSReaderConfigModel gpsReaderConfig = GPSNMEAPanel.this.handler.getGPSReaderConfig();
                GPSNMEAPanel.setComboBoxWhenDiffers(GPSNMEAPanel.this.cbxCommPorts, gpsReaderConfig.getComPortName());
                GPSNMEAPanel.setComboBoxWhenDiffers(GPSNMEAPanel.this.cbxCommBaudRate, gpsReaderConfig.getBaudrate() == null ? "" : gpsReaderConfig.getBaudrate().toString());
                if (GPSNMEAPanel.this.handler.isGPSAvailable()) {
                    if (GPSNMEAPanel.this.handler.getGPSNMEADialogModel().hasFix()) {
                        if (GPSNMEAPanel.this.handler.getGPSNMEADialogModel().getLastPoint() != null && GPSNMEAPanel.this.handler.getGPSNMEADialogModel().getLastPoint().getPrecision() == GPSNMEAPointPrecision.HIGH) {
                            this.setStatus(Color.BLACK, Color.ORANGE, I18N.getMessage("ui.plugin.gpsnmea.GPSNMEAPanel.ConnectedFixHigh", new Object[0]), I18N.getMessage("ui.plugin.gpsnmea.GPSNMEAPanel.ConnectedFixHigh.Tooltip", new Object[0]));
                        } else {
                            this.setStatus(Color.BLACK, Color.GREEN, I18N.getMessage("ui.plugin.gpsnmea.GPSNMEAPanel.ConnectedFix", new Object[0]), I18N.getMessage("ui.plugin.gpsnmea.GPSNMEAPanel.ConnectedFix.Tooltip", new Object[0]));
                        }
                    } else {
                        this.setStatus(Color.WHITE, Color.RED, I18N.getMessage("ui.plugin.gpsnmea.GPSNMEAPanel.ConnectedNotFix", new Object[0]), I18N.getMessage("ui.plugin.gpsnmea.GPSNMEAPanel.ConnectedNotFix.Tooltip", new Object[0]));
                    }
                } else {
                    this.setStatus(Color.WHITE, Color.BLACK, I18N.getMessage("ui.plugin.gpsnmea.GPSNMEAPanel.NotConnectedNotFix", new Object[0]), I18N.getMessage("ui.plugin.gpsnmea.GPSNMEAPanel.NotConnectedNotFix.Tooltip", new Object[0]));
                }
            }

            private void setStatus(Color fg, Color bg, String txt, String txtTooltip) {
                if (!StringUtils.equals((CharSequence)txt, (CharSequence)GPSNMEAPanel.this.edtStatus.getText())) {
                    GPSNMEAPanel.this.edtStatus.setForeground(fg);
                    GPSNMEAPanel.this.edtStatus.setBackground(bg);
                    GPSNMEAPanel.this.edtStatus.setText(txt);
                    GPSNMEAPanel.this.edtStatus.setToolTipText(txtTooltip);
                }
            }
        });
    }

    public static void setEdtTextWhenDiffers(JTextField textField, String newText) {
        if (!StringUtils.equals((CharSequence)textField.getText(), (CharSequence)newText)) {
            textField.setText(newText);
        }
    }

    public static void setComboBoxWhenDiffers(JComboBox<?> comboBox, Object newValue) {
        if (!ObjectUtils.equals((Object)newValue, (Object)comboBox.getSelectedItem())) {
            comboBox.setSelectedItem(newValue);
        }
    }
}

