/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.gpsnmea;

import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import lombok.Generated;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GPSNMEALayerUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GPSNMEALayerUtils.class);

    public static boolean canCreateGeometry(Layer l, Class<?> ... classes) {
        if (l != null && l.isEditable() && l.getFMD().isInsertAllowed()) {
            for (Class<?> currClass : classes) {
                if (l.getFMD() == null || !l.getFMD().isGeometryAllowed(currClass)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean canCreateLines(Layer l) {
        return GPSNMEALayerUtils.canCreateGeometry(l, LineString.class);
    }

    public static boolean canCreatePoints(Layer l) {
        return GPSNMEALayerUtils.canCreateGeometry(l, Point.class);
    }

    public static void setCenter(LayerViewPanel lvp, Coordinate coord) {
        if (coord != null && lvp != null) {
            boolean repaint = lvp.isRepainting();
            lvp.setRepaint(false);
            try {
                lvp.getViewport().zoomToViewPoint(lvp.getViewport().toViewPoint(coord), 1.0);
            }
            catch (Exception e) {
                log.error("Could not zoom to view point", (Throwable)e);
            }
            lvp.setRepaint(repaint);
            lvp.repaint();
        }
    }

    private GPSNMEALayerUtils() {
    }
}

