/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.gpsnmea;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.geom.EnvelopeUtil;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.FeatureDrawingUtil;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.gpsnmea.GPSNMEAConfigPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.gpsnmea.GPSNMEADialogModel;
import com.vividsolutions.jump.workbench.ui.plugin.gpsnmea.GPSNMEALayerUtils;
import com.vividsolutions.jump.workbench.ui.plugin.gpsnmea.GPSNMEAPoint;
import com.vividsolutions.jump.workbench.ui.plugin.gpsnmea.GPSNMEAPointPrecision;
import com.vividsolutions.jump.workbench.ui.plugin.gpsnmea.GPSNMEATransformation;
import com.vividsolutions.jump.workbench.ui.plugin.gpsnmea.GPSReaderConfigHelper;
import com.vividsolutions.jump.workbench.ui.plugin.gpsnmea.GPSReaderConfigModel;
import com.vividsolutions.jump.workbench.ui.plugin.gpsnmea.lines.CoordinatesToLineAlgorithm;
import com.vividsolutions.jump.workbench.ui.plugin.gpsnmea.lines.DefaultCoordinatesToLineAlgorithm;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.SaveLayerFeatureChangesPlugIn;
import de.riwagis.crs.CRSDefFactory;
import de.riwagis.crs.CRSDefinition;
import de.riwagis.crs.Transformer;
import de.riwagis.util.io.rxtx.ComPortConfiguration;
import de.riwagis.util.io.rxtx.ComPortSupport;
import de.riwagis.util.nmea.GPSReaderReader;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Timer;
import javax.swing.event.ChangeListener;
import ocss.nmea.api.NMEAClient;
import ocss.nmea.api.NMEAEvent;
import ocss.nmea.api.NMEAReader;
import ocss.nmea.parser.StringParsers;
import org.apache.commons.lang3.math.NumberUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GPSNMEAHandler {
    private static final Logger LOG = LoggerFactory.getLogger(GPSNMEAHandler.class);
    private static final Calendar calcDateCalendar = new GregorianCalendar();
    private static final GeometryFactory GFAC = new GeometryFactory();
    public static final String GPS_PREVIEW = "GPS_PREVIEW";
    private static final int[] KNOWN_BAUDRATES = new int[]{50, 300, 1200, 2400, 4800, 9600, 19200, 38400, 57600, 115200};
    private static final int LASTPOINTCOUNT = 100;
    private static final CRSDefinition CRS_WGS84 = CRSDefFactory.getCRSDefinition((String)"4326");
    private final GPSReaderConfigModel gpsReaderConfigModel = new GPSReaderConfigModel();
    private final GPSNMEADialogModel dialogModel = new GPSNMEADialogModel();
    private NMEAClient customClient = null;
    private final Timer t;
    private PlugInContext context;
    private GPSReaderReader currReader;
    private final List<GPSNMEAPoint> lastPoints = new LinkedList<GPSNMEAPoint>();
    private final Queue<GPSNMEAPoint> trackPoints = new LinkedList<GPSNMEAPoint>();
    private final List<GPSNMEAPoint> trackLinePoints = new LinkedList<GPSNMEAPoint>();
    private GPSNMEAPoint lastPoint = null;
    private Coordinate lastTransPoint = null;
    private boolean lastHasFix = true;
    private int lastNumberOfSatellites = 0;
    private Date lastDate = null;
    private boolean doTrackPoints = false;
    private String doTrackPointsLayerKey = null;
    private boolean tracking = false;
    private boolean showGPSCoordinate = true;
    private boolean showGPSTrack = true;
    private boolean followOnMap = false;
    private CRSDefinition crsDefinition = null;
    private DefaultComboBoxModel<String> commPortsModel = null;
    private DefaultComboBoxModel<Integer> baudRateModel = null;

    public boolean isFollowOnMap() {
        return this.followOnMap;
    }

    public void setFollowOnMap(boolean followOnMap) {
        PersistentBlackboardPlugIn.get().put("GPSNMEA.followOnMap", followOnMap);
        this.followOnMap = followOnMap;
    }

    public boolean isShowGPSTrack() {
        return this.showGPSTrack;
    }

    public void setShowGPSTrack(boolean showGPSTrack) {
        PersistentBlackboardPlugIn.get().put("GPSNMEA.lineTrack", showGPSTrack);
        this.showGPSTrack = showGPSTrack;
    }

    public boolean isShowGPSCoordinate() {
        return this.showGPSCoordinate;
    }

    public void setShowGPSCoordinate(boolean showGPSCoordinate) {
        PersistentBlackboardPlugIn.get().put("GPSNMEA.showCoordinate", showGPSCoordinate);
        this.showGPSCoordinate = showGPSCoordinate;
    }

    private String getDoTrackPointsLayerKey() {
        return this.doTrackPointsLayerKey;
    }

    public void setDoTrackPointsLayerKey(String doTrackPointsLayerKey) {
        PersistentBlackboardPlugIn.get().put("GPSNMEA.pointsTrackLayerKey", doTrackPointsLayerKey);
        this.doTrackPointsLayerKey = doTrackPointsLayerKey;
    }

    private boolean isDoTrackPoints() {
        return this.doTrackPoints;
    }

    public void setDoTrackPoints(boolean doTrackPoints) {
        this.doTrackPoints = doTrackPoints;
    }

    public void setContext(PlugInContext context) {
        this.context = context;
    }

    public GPSNMEAHandler() {
        this.initNMEAClient();
        this.loadConfig();
        final GPSNMEAHandler handler = this;
        ChangeListener configChangedListener = e -> handler.saveConfig();
        this.gpsReaderConfigModel.addChangeListener(configChangedListener);
        ActionListener repaintGPSPlot = new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                if (!GPSNMEAHandler.this.isGPSAvailable()) {
                    GPSNMEAHandler.this.lastHasFix = false;
                    GPSNMEAHandler.this.lastNumberOfSatellites = 0;
                    GPSNMEAHandler.this.lastDate = null;
                } else if (!GPSNMEAHandler.this.lastPoints.isEmpty()) {
                    GPSNMEAHandler.this.lastPoint = GPSNMEAHandler.this.lastPoints.get(GPSNMEAHandler.this.lastPoints.size() - 1);
                    try {
                        Transformer mt = GPSNMEAHandler.findCurrentTransformer(GPSNMEAHandler.this.lastPoint.getCrs(), GPSNMEAHandler.this.crsDefinition);
                        GPSNMEAHandler.this.lastTransPoint = GPSNMEATransformation.transformCoordinate(mt, GPSNMEAHandler.this.lastPoint.getCoord());
                    }
                    catch (Exception ex) {
                        LOG.warn("Error calculating to CRS", (Throwable)ex);
                    }
                }
                while (!GPSNMEAHandler.this.trackPoints.isEmpty()) {
                    Layer l;
                    GPSNMEAPoint currCoord;
                    Collection<GPSNMEAPoint> collection = GPSNMEAHandler.this.trackPoints;
                    synchronized (collection) {
                        currCoord = GPSNMEAHandler.this.trackPoints.poll();
                    }
                    if (currCoord == null) continue;
                    if (GPSNMEAHandler.this.isDoTrackPoints() && GPSNMEALayerUtils.canCreatePoints(l = WorkbenchContext.getInstance().getLayerManager().getLayerByKey(handler.getDoTrackPointsLayerKey()))) {
                        try {
                            Transformer mt = GPSNMEAHandler.findCurrentTransformer(currCoord.getCrs(), GPSNMEAHandler.this.crsDefinition);
                            this.addPointToLayer(l, GPSNMEATransformation.transformCoordinate(mt, currCoord.getCoord()));
                        }
                        catch (Exception ex) {
                            LOG.warn("Error calculating to CRS", (Throwable)ex);
                        }
                    }
                    if (!GPSNMEAHandler.this.isTracking()) continue;
                    collection = GPSNMEAHandler.this.trackLinePoints;
                    synchronized (collection) {
                        GPSNMEAHandler.this.trackLinePoints.add(currCoord);
                    }
                }
                GPSNMEAHandler.this.dialogModel.setData(GPSNMEAHandler.this.lastPoint, GPSNMEAHandler.this.lastTransPoint);
                GPSNMEAHandler.this.dialogModel.setData(GPSNMEAHandler.this.lastHasFix, GPSNMEAHandler.this.lastNumberOfSatellites, GPSNMEAHandler.this.lastDate);
                GPSNMEAHandler.this.drawPreview();
            }

            private void addPointToLayer(Layer l, Coordinate currCoord) {
                Point geom = GFAC.createPoint(currCoord);
                UndoableCommand cmd = FeatureDrawingUtil.createAddCommand((Geometry)geom, JUMPWorkbench.getBlackboard().get(EditTransaction.ROLLING_BACK_INVALID_EDITS_KEY, false), WorkbenchContext.getInstance().getLayerViewPanel(), l, I18N.get("ui.plugin.gpsnmea.GPSNMEADialog.set_gps_point"));
                GPSNMEAConfigPlugIn.execute(cmd, (LayerManagerProxy)GPSNMEAHandler.this.context);
                SaveLayerFeatureChangesPlugIn.commitLayer(l, true, false, false);
            }
        };
        this.t = new Timer(200, repaintGPSPlot);
        this.t.start();
    }

    private Geometry buildTrackLineTrans(CoordinatesToLineAlgorithm la, List<GPSNMEAPoint> trackLinePoints) {
        LinkedList<Coordinate> trackLineTransPoints = new LinkedList<Coordinate>();
        try {
            for (GPSNMEAPoint currCoord : trackLinePoints) {
                Transformer mt = GPSNMEAHandler.findCurrentTransformer(currCoord.getCrs(), this.crsDefinition);
                trackLineTransPoints.add(GPSNMEATransformation.transformCoordinate(mt, currCoord.getCoord()));
            }
        }
        catch (Exception ex) {
            LOG.warn("Error calculating to CRS", (Throwable)ex);
        }
        return la.calculateLine(trackLineTransPoints);
    }

    public ComboBoxModel<String> getCommPortModel() {
        if (this.commPortsModel == null) {
            this.commPortsModel = new DefaultComboBoxModel();
            this.commPortsModel.removeAllElements();
            Enumeration e = CommPortIdentifier.getPortIdentifiers();
            while (e.hasMoreElements()) {
                CommPortIdentifier id = (CommPortIdentifier)e.nextElement();
                LOG.debug(String.format("COM-Port: %s", id));
                this.commPortsModel.addElement(id.getName());
            }
            this.commPortsModel.setSelectedItem(this.gpsReaderConfigModel.getComPortName());
        }
        return this.commPortsModel;
    }

    public ComboBoxModel<Integer> getCommBaudRateModel() {
        if (this.baudRateModel == null) {
            this.baudRateModel = new DefaultComboBoxModel();
            this.baudRateModel.removeAllElements();
            int[] nArray = KNOWN_BAUDRATES;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer currBR = nArray[i];
                this.baudRateModel.addElement(currBR);
            }
            this.baudRateModel.setSelectedItem(this.gpsReaderConfigModel.getBaudrate() == null ? "" : this.gpsReaderConfigModel.getBaudrate());
        }
        return this.baudRateModel;
    }

    private void loadConfig() {
        Blackboard bb = PersistentBlackboardPlugIn.get();
        GPSReaderConfigHelper.loadConfiguration(this.getGPSReaderConfig(), bb);
        this.crsDefinition = GPSReaderConfigHelper.getCRSDefinition(bb, "GPSNMEA.CRSKey");
        this.followOnMap = bb.get("GPSNMEA.followOnMap", false);
        this.doTrackPointsLayerKey = bb.get("GPSNMEA.pointsTrackLayerKey", null);
        this.showGPSTrack = bb.get("GPSNMEA.lineTrack", true);
        this.showGPSCoordinate = bb.get("GPSNMEA.showCoordinate", true);
    }

    public CRSDefinition getCrsDefinition() {
        return this.crsDefinition;
    }

    public static Transformer findCurrentTransformer(CRSDefinition srcCRS, CRSDefinition destCRS) throws Exception {
        CRSDefinition dstCRS = GPSNMEATransformation.determineDestinationCRS(destCRS);
        return new Transformer(srcCRS.getCRS(), dstCRS.getCRS());
    }

    public void setCrsDefinition(CRSDefinition crsDefinition) {
        this.crsDefinition = crsDefinition;
        PersistentBlackboardPlugIn.get().put("GPSNMEA.CRSKey", crsDefinition == null ? null : CRSDefFactory.getKey((CRSDefinition)crsDefinition));
    }

    private void saveConfig() {
        Blackboard bb = PersistentBlackboardPlugIn.get();
        GPSReaderConfigHelper.saveConfiguration(this.getGPSReaderConfig(), bb);
        bb.put("GPSNMEA.CRSKey", this.getCrsDefinition() == null ? "" : this.getCrsDefinition().getCode());
        bb.put("GPSNMEA.followOnMap", this.isFollowOnMap());
        bb.put("GPSNMEA.pointsTrackLayerKey", this.getDoTrackPointsLayerKey());
        bb.put("GPSNMEA.lineTrack", this.isShowGPSTrack());
        bb.put("GPSNMEA.showCoordinate", this.isShowGPSCoordinate());
    }

    public GPSReaderConfigModel getGPSReaderConfig() {
        return this.gpsReaderConfigModel;
    }

    public void tryCreatePoint() throws Exception {
        if (this.lastTransPoint != null) {
            Layer ly = EditingPanel.instanceOf().getCurrentLayer();
            if (!GPSNMEALayerUtils.canCreatePoints(ly)) {
                throw new Exception(MessageFormat.format(I18N.get("ui.plugin.gpsnmea.GPSNMEADialog.no-points-allowed-in-layer"), ly.getName()));
            }
            Point geom = GFAC.createPoint(this.lastTransPoint);
            UndoableCommand cmd = FeatureDrawingUtil.createAddCommand((Geometry)geom, JUMPWorkbench.getBlackboard().get(EditTransaction.ROLLING_BACK_INVALID_EDITS_KEY, false), WorkbenchContext.getInstance().getLayerViewPanel(), I18N.get("ui.plugin.gpsnmea.GPSNMEADialog.set_gps_point"));
            GPSNMEAConfigPlugIn.execute(cmd, (LayerManagerProxy)WorkbenchContext.getInstance());
            SaveLayerFeatureChangesPlugIn.commitLayer(EditingPanel.instanceOf().getCurrentLayer(), true, false, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryCreateLine() throws Exception {
        Layer ly = EditingPanel.instanceOf().getCurrentLayer();
        if (!GPSNMEALayerUtils.canCreatePoints(ly)) {
            throw new Exception(MessageFormat.format(I18N.get("ui.plugin.gpsnmea.GPSNMEADialog.no-lines-allowed-in-layer"), ly.getName()));
        }
        List<GPSNMEAPoint> list = this.trackLinePoints;
        synchronized (list) {
            DefaultCoordinatesToLineAlgorithm la = new DefaultCoordinatesToLineAlgorithm(GFAC, WorkbenchContext.getTask().getDrawingUnit());
            Geometry geom = this.buildTrackLineTrans(la, this.trackLinePoints);
            if (geom != null) {
                UndoableCommand cmd = FeatureDrawingUtil.createAddCommand(geom, JUMPWorkbench.getBlackboard().get(EditTransaction.ROLLING_BACK_INVALID_EDITS_KEY, false), WorkbenchContext.getInstance().getLayerViewPanel(), I18N.get("ui.plugin.gpsnmea.GPSNMEADialog.set_gps_point"));
                GPSNMEAConfigPlugIn.execute(cmd, (LayerManagerProxy)WorkbenchContext.getInstance());
                SaveLayerFeatureChangesPlugIn.commitLayer(EditingPanel.instanceOf().getCurrentLayer(), true, false, false);
            }
        }
    }

    public boolean isGPSAvailable() {
        return this.currReader.isCanReadGPS();
    }

    public boolean hasLastTransPoint() {
        return this.getGPSNMEADialogModel().getLastTransPoint() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetTrack() {
        List<GPSNMEAPoint> list = this.trackLinePoints;
        synchronized (list) {
            this.trackLinePoints.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zoomTrack(Viewport viewport) {
        Geometry trackGeom;
        List<GPSNMEAPoint> list = this.trackLinePoints;
        synchronized (list) {
            DefaultCoordinatesToLineAlgorithm la = new DefaultCoordinatesToLineAlgorithm(GFAC, WorkbenchContext.getTask().getDrawingUnit());
            trackGeom = this.buildTrackLineTrans(la, this.trackLinePoints);
        }
        if (trackGeom == null) {
            return;
        }
        Envelope proposedEnvelope = EnvelopeUtil.bufferByFraction(trackGeom.getEnvelopeInternal(), 0.1);
        Envelope envView = viewport.getEnvelopeInModelCoordinates();
        proposedEnvelope = EnvelopeUtil.getProportionalEnvelope(envView, proposedEnvelope);
        viewport.zoom(proposedEnvelope);
    }

    public boolean hasTrackLine() {
        return this.trackLinePoints.size() >= 2;
    }

    public GPSNMEADialogModel getGPSNMEADialogModel() {
        return this.dialogModel;
    }

    public void setTracking(boolean selected) {
        this.tracking = selected;
    }

    public boolean isTracking() {
        return this.tracking;
    }

    public void startReading() throws IOException {
        try {
            if (this.currReader.isCanReadGPS()) {
                this.currReader.stopReading();
                try {
                    Thread.sleep(300L);
                }
                catch (Exception ex) {
                    LOG.error("Error while sleeping.", (Throwable)ex);
                }
            }
            SerialPort comPort = ComPortSupport.openCommPort((ComPortConfiguration)this.getGPSReaderConfig());
            this.currReader.startReading(comPort);
        }
        catch (IOException ioex) {
            LOG.error("Error opening port", (Throwable)ioex);
            throw ioex;
        }
    }

    public void setGPSCenter() {
        if (WorkbenchContext.getInstance().getLayerViewPanel() != null) {
            this.setGPSCenter(WorkbenchContext.getInstance().getLayerViewPanel());
        }
    }

    public void stopReading() {
        this.currReader.stopReading();
    }

    public void zoomTrack() {
        if (WorkbenchContext.getInstance().getLayerViewPanel() != null) {
            this.zoomTrack(WorkbenchContext.getInstance().getLayerViewPanel().getViewport());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawPreview() {
        LayerViewPanel lvp;
        if (WorkbenchContext.getInstance() != null && (lvp = WorkbenchContext.getInstance().getLayerViewPanel()) != null) {
            Geometry coordGeom = (Geometry)WorkbenchContext.getBlackboard().get("GPS_PREVIEW_COORD");
            Geometry trackGeom = (Geometry)WorkbenchContext.getBlackboard().get("GPS_PREVIEW_LINE");
            if (!this.showGPSCoordinate) {
                coordGeom = null;
            }
            if (!this.showGPSTrack) {
                trackGeom = null;
            }
            Viewport vp = lvp.getViewport();
            if (this.lastTransPoint != null) {
                if (this.showGPSCoordinate && vp != null) {
                    double xc = this.lastTransPoint.x;
                    double yc = this.lastTransPoint.y;
                    double crossSize = 50.0 / vp.getScale();
                    LineString ls1 = GFAC.createLineString(new Coordinate[]{new Coordinate(xc, yc - crossSize), new Coordinate(xc, yc + crossSize)});
                    LineString ls2 = GFAC.createLineString(new Coordinate[]{new Coordinate(xc - crossSize, yc), new Coordinate(xc + crossSize, yc)});
                    coordGeom = GFAC.createGeometryCollection(new Geometry[]{ls1, ls2});
                }
                if (this.showGPSTrack) {
                    DefaultCoordinatesToLineAlgorithm la = new DefaultCoordinatesToLineAlgorithm(GFAC, WorkbenchContext.getTask().getDrawingUnit());
                    List<GPSNMEAPoint> list = this.trackLinePoints;
                    synchronized (list) {
                        trackGeom = this.buildTrackLineTrans(la, this.trackLinePoints);
                    }
                }
                if (this.followOnMap && this.isGPSAvailable() && !vp.getEnvelopeInModelCoordinates().contains(this.lastTransPoint)) {
                    GPSNMEALayerUtils.setCenter(lvp, this.lastTransPoint);
                }
            }
            boolean doRepaint = !Objects.equals(String.valueOf(WorkbenchContext.getBlackboard().get("GPS_PREVIEW_COORD")), String.valueOf(coordGeom)) || !Objects.equals(String.valueOf(WorkbenchContext.getBlackboard().get("GPS_PREVIEW_LINE")), String.valueOf(trackGeom));
            WorkbenchContext.getBlackboard().put("GPS_PREVIEW_COORD", coordGeom);
            WorkbenchContext.getBlackboard().put("GPS_PREVIEW_LINE", trackGeom);
            if (doRepaint) {
                lvp.copyTo();
            }
        }
    }

    private void initNMEAClient() throws NumberFormatException {
        String prefix = "GP";
        String[] array = new String[]{"RMC", "GGA", "PPM"};
        this.customClient = new NMEAClient(prefix, array){
            private Coordinate lastPoint;
            private final AtomicInteger missedPPMInt;
            {
                this.lastPoint = null;
                this.missedPPMInt = new AtomicInteger(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dataDetectedEvent(NMEAEvent e) {
                LOG.debug(String.format("Received: %s", e.getContent()));
                LOG.debug(String.format("RMC: %s", StringParsers.parseRMC((String)e.getContent())));
                String[] x = e.getContent().split(",");
                boolean hasFixPPM = false;
                if (!GPSNMEAHandler.this.gpsReaderConfigModel.isPPMIgnore().booleanValue() && "$GPPPM".equals(x[0])) {
                    int numberOfSatellites = NumberUtils.toInt((String)x[7], (int)0);
                    boolean bl = hasFixPPM = !"0".equals(x[6]);
                    if (hasFixPPM) {
                        this.missedPPMInt.set(0);
                        Coordinate currCoordinate = GPSNMEATransformation.calcCoordinate(Double.parseDouble(x[2]), x[3], Double.parseDouble(x[4]), x[5]);
                        if (this.lastPoint == null || !currCoordinate.equals2D(this.lastPoint)) {
                            this.lastPoint = currCoordinate;
                            GPSNMEAPoint gpsnmeaPoint = new GPSNMEAPoint(currCoordinate, numberOfSatellites, hasFixPPM, GPSNMEAPointPrecision.HIGH, GPSNMEAHandler.this.gpsReaderConfigModel.getPPMCrsDefinition());
                            Collection<GPSNMEAPoint> collection = GPSNMEAHandler.this.lastPoints;
                            synchronized (collection) {
                                GPSNMEAHandler.this.lastPoints.add(gpsnmeaPoint);
                            }
                            collection = GPSNMEAHandler.this.trackPoints;
                            synchronized (collection) {
                                GPSNMEAHandler.this.trackPoints.offer(gpsnmeaPoint);
                            }
                        }
                    }
                }
                if ("$GPGGA".equals(x[0])) {
                    boolean hasFixGPS = !"0".equals(x[6]);
                    boolean bl = GPSNMEAHandler.this.lastHasFix = hasFixGPS || hasFixPPM;
                    if (hasFixGPS) {
                        int missedPPM = this.missedPPMInt.getAndIncrement();
                        if (GPSNMEAHandler.this.getGPSReaderConfig().isPPMIgnore().booleanValue() || missedPPM > GPSNMEAHandler.this.getGPSReaderConfig().getPPMFallbackGPS()) {
                            int numberOfSatellites = NumberUtils.toInt((String)x[7], (int)0);
                            Coordinate currCoordinate = GPSNMEATransformation.calcCoordinate(GPSNMEATransformation.calcDegrees(x[2]), x[3], GPSNMEATransformation.calcDegrees(x[4]), x[5]);
                            if (this.lastPoint == null || !currCoordinate.equals2D(this.lastPoint)) {
                                this.lastPoint = currCoordinate;
                                GPSNMEAPoint gpsnmeaPoint = new GPSNMEAPoint(currCoordinate, numberOfSatellites, hasFixGPS, GPSNMEAPointPrecision.LOW, CRS_WGS84);
                                Collection<GPSNMEAPoint> collection = GPSNMEAHandler.this.lastPoints;
                                synchronized (collection) {
                                    GPSNMEAHandler.this.lastPoints.add(gpsnmeaPoint);
                                }
                                collection = GPSNMEAHandler.this.trackPoints;
                                synchronized (collection) {
                                    GPSNMEAHandler.this.trackPoints.offer(gpsnmeaPoint);
                                }
                            }
                        }
                    }
                }
                if ("$GPRMC".equals(x[0])) {
                    boolean timeOk = true;
                    if (!x[1].isEmpty()) {
                        calcDateCalendar.set(11, Integer.parseInt(x[1].substring(0, 2)));
                        calcDateCalendar.set(12, Integer.parseInt(x[1].substring(2, 4)));
                        calcDateCalendar.set(13, Integer.parseInt(x[1].substring(4, 6)));
                    } else {
                        timeOk = false;
                    }
                    if (!x[9].isEmpty()) {
                        calcDateCalendar.set(5, Integer.parseInt(x[9].substring(0, 2)));
                        calcDateCalendar.set(2, Integer.parseInt(x[9].substring(2, 4)) - 1);
                        calcDateCalendar.set(1, Integer.parseInt("20" + x[9].substring(4, 6)));
                    } else {
                        timeOk = false;
                    }
                    Date date = GPSNMEAHandler.this.lastDate = timeOk ? calcDateCalendar.getTime() : null;
                }
                while (GPSNMEAHandler.this.lastPoints.size() > 100) {
                    GPSNMEAHandler.this.lastPoints.remove(0);
                }
                GPSNMEAHandler.this.lastNumberOfSatellites = GPSNMEAHandler.this.lastPoints.isEmpty() ? 0 : GPSNMEAHandler.this.lastPoints.get(GPSNMEAHandler.this.lastPoints.size() - 1).getNumberOfSatellites();
            }
        };
        this.customClient.initClient();
        this.currReader = new GPSReaderReader((Collection)this.customClient.getListeners());
        this.customClient.setReader((NMEAReader)this.currReader);
        this.customClient.startWorking();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.t != null) {
            this.t.stop();
        }
    }

    private void setGPSCenter(LayerViewPanel lvp) {
        GPSNMEALayerUtils.setCenter(lvp, this.getGPSNMEADialogModel().getLastTransPoint());
    }
}

