/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.gpsnmea;

import com.vividsolutions.jump.workbench.ui.plugin.gpsnmea.GPSNMEAPoint;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.locationtech.jts.geom.Coordinate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GPSNMEADialogModel {
    private static final Logger LOG = LoggerFactory.getLogger(GPSNMEADialogModel.class);
    private final Collection<ChangeListener> changeListeners = new LinkedHashSet<ChangeListener>();
    private boolean hasFix = false;
    private int lastNumberOfSatellites = 0;
    private Coordinate lastTransPoint = null;
    private GPSNMEAPoint lastPoint = null;
    private Date lastDate = null;

    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    private void fireModelChanged() {
        ChangeEvent ev = new ChangeEvent(this);
        for (ChangeListener listener : this.changeListeners) {
            listener.stateChanged(ev);
        }
    }

    public void setData(GPSNMEAPoint lastPoint, Coordinate lastTransPoint) {
        this.lastPoint = lastPoint;
        this.lastTransPoint = lastTransPoint;
        this.fireModelChanged();
    }

    public void setData(boolean hasFix, int lastNumberOfSatellites, Date lastDate) {
        this.hasFix = hasFix;
        this.lastDate = lastDate == null ? null : new Date(lastDate.getTime());
        this.lastNumberOfSatellites = lastNumberOfSatellites;
        this.fireModelChanged();
    }

    public boolean hasFix() {
        return this.hasFix;
    }

    public Date getLastDate() {
        return this.lastDate == null ? null : new Date(this.lastDate.getTime());
    }

    public int getLastNumberOfSatellites() {
        return this.lastNumberOfSatellites;
    }

    public GPSNMEAPoint getLastPoint() {
        return this.lastPoint;
    }

    public Coordinate getLastTransPoint() {
        return this.lastTransPoint;
    }
}

