/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.gpsnmea;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.gpsnmea.GPSNMEAHandler;
import com.vividsolutions.jump.workbench.ui.plugin.gpsnmea.GPSNMEAPanel;
import de.riwagis.util.Support;
import javax.swing.JTabbedPane;
import org.locationtech.jts.geom.GeometryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GPSNMEAConfigPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private static final Logger LOG = LoggerFactory.getLogger(GPSNMEAConfigPlugIn.class);
    public static final GeometryFactory GEOM_FACTORY = new GeometryFactory();
    public static final String GPS_ACTIVE = "GLOBAL_CONFIG_GPSACTIVE";
    private GPSNMEAHandler currHandler = null;

    @Override
    public void initialize(PlugInContext context) throws Exception {
        try {
            if (Support.isWindows() && PersistentBlackboardPlugIn.get().get(GPS_ACTIVE, false)) {
                this.currHandler = new GPSNMEAHandler();
                JTabbedPane tabbedPane = context.getWorkbenchFrame().getDesktopPanel().getRightTabbedPane();
                GPSNMEAPanel gpsnmeapanel = new GPSNMEAPanel(this.currHandler);
                tabbedPane.add(I18N.get("ui.plugin.gpsnmea.GPSNMEAPanel.title"), gpsnmeapanel);
                this.currHandler.setContext(context);
            }
        }
        catch (Throwable t) {
            LOG.error(String.format("unable to initialize GPS plugin: %s", t.getMessage()), t);
        }
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    public String getName() {
        return I18N.get("ui.plugin.gpsnmea.GPSNMEAPlugIn.name");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        return false;
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(checkFactory.createTaskWindowMustBeActiveCheck());
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

