/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.gps;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.gps.SelectedGPSFeature;
import de.riwagis.crs.Transformer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;

public class SelectedGPSFeatureList
extends DefaultTableModel
implements Iterable<SelectedGPSFeature> {
    private static final String KEY_GPS_EXPORT_FEATURES = "GPS_EXPORT_FEATURES";
    private final List<SelectedGPSFeature> selectedGPSFeatureList = new LinkedList<SelectedGPSFeature>();
    private final Collection<String> selectedGPSFeatureSet = new HashSet<String>();

    public static final SelectedGPSFeatureList retrieveSelectedGPSFeatureList(PlugInContext context) {
        SelectedGPSFeatureList gpsfeature = (SelectedGPSFeatureList)WorkbenchContext.getBlackboard().get(KEY_GPS_EXPORT_FEATURES);
        if (gpsfeature == null) {
            gpsfeature = new SelectedGPSFeatureList();
            WorkbenchContext.getBlackboard().put(KEY_GPS_EXPORT_FEATURES, gpsfeature);
        }
        return gpsfeature;
    }

    void add(SimpleFeature currFeature, String text, Layer layer, Transformer trans) throws Exception {
        Geometry geom = (Geometry)((Geometry)currFeature.getDefaultGeometry()).clone();
        trans.transform2d(geom);
        ArrayList<SelectedGPSFeature> newFeatures = new ArrayList<SelectedGPSFeature>();
        SelectedGPSFeatureList.buildGeomFeat(currFeature, layer, text, geom, newFeatures);
        for (SelectedGPSFeature currNewFeature : newFeatures) {
            if (this.selectedGPSFeatureSet.contains(currNewFeature.getKey())) continue;
            this.selectedGPSFeatureList.add(currNewFeature);
            this.selectedGPSFeatureSet.add(currNewFeature.getKey());
        }
        this.fireTableRowsInserted(this.selectedGPSFeatureList.size() - newFeatures.size(), this.selectedGPSFeatureList.size() - 1);
    }

    public static void buildGeomFeat(SimpleFeature currFeature, Layer layer, String text, Geometry geom, Collection<SelectedGPSFeature> newFeatures) {
        if (geom.getNumGeometries() == 1) {
            SelectedGPSFeature currSelectedFeature = new SelectedGPSFeature(currFeature.getID(), layer, text, newFeatures.size(), geom.getCoordinates());
            newFeatures.add(currSelectedFeature);
        } else {
            for (int i = 0; i < geom.getNumGeometries(); ++i) {
                SelectedGPSFeatureList.buildGeomFeat(currFeature, layer, text, geom.getGeometryN(i), newFeatures);
            }
        }
    }

    @Override
    public int getRowCount() {
        return this.selectedGPSFeatureList == null ? 0 : this.selectedGPSFeatureList.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return I18N.get("ui.plugin.gpx.SelectedGPSFeatureList.layer");
            }
            case 1: {
                return I18N.get("ui.plugin.gpx.SelectedGPSFeatureList.text");
            }
            case 2: {
                return I18N.get("ui.plugin.gpx.SelectedGPSFeatureList.type");
            }
        }
        return super.getColumnName(column);
    }

    @Override
    public Object getValueAt(int row, int column) {
        SelectedGPSFeature currSelectedFeature = this.selectedGPSFeatureList.get(row);
        switch (column) {
            case 0: {
                return currSelectedFeature.getLayerName();
            }
            case 1: {
                return currSelectedFeature.getText();
            }
            case 2: {
                return currSelectedFeature.getFeatureType();
            }
        }
        return super.getValueAt(row, column);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 1;
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        if (this.isCellEditable(row, column)) {
            SelectedGPSFeature currSelectedFeature = this.selectedGPSFeatureList.get(row);
            switch (column) {
                case 1: {
                    currSelectedFeature.setText(aValue != null ? aValue.toString().trim() : null);
                }
            }
        }
    }

    public void deleteEntry(int index) {
        SelectedGPSFeature sl = this.selectedGPSFeatureList.remove(index);
        if (sl != null) {
            this.selectedGPSFeatureSet.remove(sl.getKey());
        }
        this.fireTableRowsDeleted(Math.min(index - 1, 0), index);
    }

    void deleteAllEntries() {
        this.selectedGPSFeatureList.clear();
        this.selectedGPSFeatureSet.clear();
        this.fireTableDataChanged();
    }

    void deleteEntries(Collection<SelectedGPSFeature> delObj) {
        for (SelectedGPSFeature curDelObj : delObj) {
            this.selectedGPSFeatureList.remove(curDelObj);
            this.selectedGPSFeatureSet.remove(curDelObj.getKey());
        }
        this.fireTableDataChanged();
    }

    void deleteEntries(int[] selectedRows) {
        ArrayList<SelectedGPSFeature> delObj = new ArrayList<SelectedGPSFeature>();
        for (int idx : selectedRows) {
            delObj.add(this.selectedGPSFeatureList.get(idx));
        }
        this.deleteEntries(delObj);
    }

    public SelectedGPSFeature getEntry(int row) {
        return this.selectedGPSFeatureList.get(row);
    }

    @Override
    public Iterator<SelectedGPSFeature> iterator() {
        return this.selectedGPSFeatureList.iterator();
    }
}

