/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.gps;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Layer;
import org.locationtech.jts.geom.Coordinate;
import org.opengis.feature.simple.SimpleFeature;

public class SelectedGPSFeature {
    private final Coordinate[] coordinates;
    private final String layerName;
    private final String layerKey;
    private final String featureFID;
    private final int counter;
    private String text;

    public static final String buildKey(Layer layer, SimpleFeature feature) {
        return SelectedGPSFeature.buildKey(layer.getKey(), feature.getID(), 0);
    }

    public static final String buildKey(String layerKey, String featureID, int counter) {
        return layerKey + "_" + featureID + (String)(counter == 0 ? "" : "_" + counter);
    }

    public SelectedGPSFeature(String _featureFID, Layer _layer, String text, int counter, Coordinate[] _coordinates) {
        this.featureFID = _featureFID;
        this.layerName = _layer.getName();
        this.layerKey = _layer.getKey();
        this.text = text;
        this.counter = counter;
        this.coordinates = _coordinates;
    }

    public String getKey() {
        return SelectedGPSFeature.buildKey(this.layerKey, this.featureFID, this.counter);
    }

    public String getFeatureType() {
        if (this.coordinates != null) {
            if (this.coordinates.length > 1) {
                return I18N.get("ui.plugin.gpx.SelectedGPSFeature.line");
            }
            if (this.coordinates.length == 1) {
                return I18N.get("ui.plugin.gpx.SelectedGPSFeature.point");
            }
        }
        return I18N.get("ui.plugin.gpx.SelectedGPSFeature.illegal");
    }

    public String getLayerKey() {
        return this.layerKey;
    }

    public Coordinate[] getCoordinates() {
        return this.coordinates;
    }

    public String getFeatureFID() {
        return this.featureFID;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getLayerName() {
        return this.layerName;
    }

    public String getText() {
        return this.text;
    }
}

