/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.gps;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerStyleCollection;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.plugin.AbstractExportPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.label.GetLabelPropertiesPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.gps.GPXElements;
import com.vividsolutions.jump.workbench.ui.plugin.gps.GPXSupport;
import com.vividsolutions.jump.workbench.ui.plugin.gps.SelectedGPSFeatureList;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManager;
import de.riwagis.crs.Transformer;
import java.util.Iterator;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectGPSExportPlugIn
extends AbstractExportPlugIn
implements GPXElements {
    private static final Logger LOG = LoggerFactory.getLogger(SelectGPSExportPlugIn.class);

    public static void addSelectedFeaturesToModel(PlugInContext context, SelectedGPSFeatureList gpsfeature) throws Exception {
        if (gpsfeature != null) {
            Transformer trans = SelectGPSExportPlugIn.buildProjectTransformer(context);
            SelectionManager selMan = context.getLayerViewPanel().getSelectionManager();
            for (Layer layer : selMan.getLayersWithSelectedItems()) {
                for (SimpleFeature currFeat : selMan.getFeaturesWithSelectedItems(layer)) {
                    String text = SelectGPSExportPlugIn.retrieveText(layer, currFeat);
                    gpsfeature.add(currFeat, text, layer, trans);
                }
            }
        }
    }

    public static Transformer buildProjectTransformer(PlugInContext context) throws Exception {
        CoordinateReferenceSystem projectCRS = context.getTask().getCRSDefinition().getCRS();
        if (projectCRS == null) {
            throw new Exception(I18N.get("ui.plugin.gps.SaveGPXFilePlugIn.illegalCoordinateReferenceSystem"));
        }
        Transformer trans = GPXSupport.buildTransformer(projectCRS);
        return trans;
    }

    @Override
    public String getName() {
        return I18N.get("ui.plugin.gps.SelectGPSExportPlugIn.name");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        SelectedGPSFeatureList gpsfeature = SelectedGPSFeatureList.retrieveSelectedGPSFeatureList(context);
        SelectGPSExportPlugIn.addSelectedFeaturesToModel(context, gpsfeature);
        return true;
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(SelectGPSExportPlugIn.createExportAllowedCheck()).add(checkFactory.createTaskWindowMustBeActiveCheck());
    }

    private static final String retrieveText(Layer layer, SimpleFeature currFeat) {
        String strText = layer.getFMD().getTextAtt();
        String strTextValue = "unbekannt";
        if (layer.getFMD().getUseText() && StringUtils.isNotEmpty((CharSequence)strText)) {
            if (StringUtils.isNotEmpty((CharSequence)strText) && currFeat.getFeatureType().indexOf(strText) > -1) {
                strTextValue = ObjectUtils.toString((Object)currFeat.getAttribute(strText));
            }
        } else {
            LayerStyleCollection scol = (LayerStyleCollection)layer.getValidStyleCollection();
            if (scol != null) {
                strTextValue = GetLabelPropertiesPlugIn.retrieveTextByLSC(scol, currFeat, strTextValue);
            } else {
                Iterator<StyleCollection> scolGuessIt = layer.getStyleCollections().iterator();
                String tempText = null;
                while (scolGuessIt.hasNext() && tempText == null) {
                    LayerStyleCollection scolGuess = (LayerStyleCollection)scolGuessIt.next();
                    tempText = GetLabelPropertiesPlugIn.retrieveTextByLSC(scolGuess, currFeat, null);
                }
                if (tempText != null) {
                    strTextValue = tempText;
                }
            }
        }
        if (strTextValue != null) {
            strTextValue = strTextValue.replaceAll("[\n\t]", " ");
        }
        return strTextValue;
    }
}

