/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.gps;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractExportPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.gps.GPXElements;
import com.vividsolutions.jump.workbench.ui.plugin.gps.GPXSupport;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManager;
import de.riwagis.crs.Transformer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.XMLOutputter;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveGPXFilePlugIn
extends AbstractExportPlugIn
implements GPXElements {
    public static final String NS_GPX_NAME = "http://www.topografix.com/GPX/1/1";
    public static final Namespace NS_GPX = Namespace.getNamespace((String)"http://www.topografix.com/GPX/1/1");
    private static final Logger LOG = LoggerFactory.getLogger(SaveGPXFilePlugIn.class);
    private static final String KEY_DIR = SaveGPXFilePlugIn.class.getName() + "_Dir";

    @Override
    public String getName() {
        return I18N.get("ui.plugin.gps.SaveGPXFilePlugIn.name");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Blackboard BB = PersistentBlackboardPlugIn.get();
        File defFile = new File(BB.get(KEY_DIR, ""));
        File gpxFile = GPXSupport.selectGPXFile(context.getWorkbenchFrame(), defFile);
        if (gpxFile != null) {
            BB.put(KEY_DIR, gpxFile.toString());
            SaveGPXFilePlugIn.writeSelectionToGPXFile(context, gpxFile);
        }
        return true;
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(SaveGPXFilePlugIn.createExportAllowedCheck()).add(checkFactory.createTaskWindowMustBeActiveCheck());
    }

    private static final void writeSelectionToGPXFile(PlugInContext context, File gpxFile) throws Exception {
        try {
            CoordinateReferenceSystem projectCRS = context.getTask().getCRSDefinition().getCRS();
            if (projectCRS == null) {
                throw new Exception(I18N.get("ui.plugin.gps.SaveGPXFilePlugIn.illegalCoordinateReferenceSystem"));
            }
            Transformer trans = GPXSupport.buildTransformer(projectCRS);
            LinkedList<Element> tracks = new LinkedList<Element>();
            LinkedList<Element> waypoints = new LinkedList<Element>();
            SelectionManager selMan = context.getLayerViewPanel().getSelectionManager();
            for (Layer layer : selMan.getLayersWithSelectedItems()) {
                Element trkElem = new Element("trk", NS_GPX);
                tracks.add(trkElem);
                Element trkNameElem = new Element("name", NS_GPX);
                trkNameElem.setText(layer.getName());
                trkElem.addContent((Content)trkNameElem);
                for (SimpleFeature currFeat : selMan.getFeaturesWithSelectedItems(layer)) {
                    Element trkSegElem = new Element("trkseg", NS_GPX);
                    trkElem.addContent((Content)trkSegElem);
                    Geometry geom = (Geometry)currFeat.getDefaultGeometry();
                    trans.transform2d(geom);
                    for (Coordinate coord : geom.getCoordinates()) {
                        Element trkptElement = new Element("trkpt", NS_GPX);
                        trkSegElem.addContent((Content)trkptElement);
                        trkptElement.setAttribute("lat", GPXSupport.formatNumber(coord.y));
                        trkptElement.setAttribute("lon", GPXSupport.formatNumber(coord.x));
                    }
                    Point p = geom.getCentroid();
                    trans.transform2d((Geometry)p);
                    Element wptElement = new Element("wpt", NS_GPX);
                    Element wptNameElement = new Element("name", NS_GPX);
                    wptElement.addContent((Content)wptNameElement);
                    wptNameElement.setText(String.valueOf(currFeat.getAttribute("name")));
                    wptElement.setAttribute("lat", GPXSupport.formatNumber(p.getCoordinate().y));
                    wptElement.setAttribute("lon", GPXSupport.formatNumber(p.getCoordinate().x));
                    waypoints.add(wptElement);
                }
            }
            Document d = new Document();
            Element gpx = new Element("gpx", NS_GPX);
            gpx.setAttribute("version", "1.1");
            gpx.setAttribute("creator", "RIWA GIS Zentrum 2 http://www.riwa-gis.de");
            d.setRootElement(gpx);
            for (Element currWaypoint : waypoints) {
                gpx.addContent((Content)currWaypoint);
            }
            for (Element currTrack : tracks) {
                gpx.addContent((Content)currTrack);
            }
            XMLOutputter out = new XMLOutputter();
            out.output(d, (OutputStream)new FileOutputStream(gpxFile, false));
        }
        catch (Exception ex) {
            LOG.error("Error writing '" + String.valueOf(gpxFile) + "': " + ex.getLocalizedMessage(), (Throwable)ex);
            throw new Exception(I18N.getMessage("ui.plugin.gps.SaveGPXFilePlugIn.errorSave", gpxFile, ex.getLocalizedMessage()), ex);
        }
    }
}

