/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.gps;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractExportPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.gps.GPSExportConfig;
import com.vividsolutions.jump.workbench.ui.plugin.gps.GPSExportDialog;
import com.vividsolutions.jump.workbench.ui.plugin.gps.GPSExportDialogListener;
import com.vividsolutions.jump.workbench.ui.plugin.gps.GPXElements;
import com.vividsolutions.jump.workbench.ui.plugin.gps.GPXSupport;
import com.vividsolutions.jump.workbench.ui.plugin.gps.SaveGPXFilePlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.gps.SelectGPSExportPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.gps.SelectedGPSFeature;
import com.vividsolutions.jump.workbench.ui.plugin.gps.SelectedGPSFeatureList;
import com.vividsolutions.jump.workbench.ui.zoom.ZoomToSelectedItemsPlugIn;
import java.awt.Frame;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedList;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.locationtech.jts.geom.Coordinate;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveGPSExportPlugIn
extends AbstractExportPlugIn
implements GPXElements,
GPSExportDialogListener {
    private static final Logger LOG = LoggerFactory.getLogger(SaveGPSExportPlugIn.class);
    private static final Blackboard BB = PersistentBlackboardPlugIn.get();
    private static final String KEY_DIR = SaveGPXFilePlugIn.class.getName() + "_Dir";
    private static final String KEY_DELETEAFTEREXPORT = SaveGPXFilePlugIn.class.getName() + "_DeleteAfterExport";
    private static final String KEY_EXPORTONLYMARKED = SaveGPXFilePlugIn.class.getName() + "_ExportOnlyMarked";
    private PlugInContext context = null;
    private final ZoomToSelectedItemsPlugIn zoomToSelectedItemsPlugIn = new ZoomToSelectedItemsPlugIn();
    private GPSExportDialog gpsED = null;

    @Override
    public String getName() {
        return I18N.get("ui.plugin.gps.SaveGPSExportPlugIn.name");
    }

    private GPSExportDialog getDialog(Frame parent) {
        if (this.gpsED == null) {
            this.gpsED = new GPSExportDialog(parent);
            int x = this.context.getWorkbenchFrame().getLocationOnScreen().x;
            int y = this.context.getWorkbenchFrame().getLocationOnScreen().y;
            this.gpsED.setLocation(x + 20, y + 90);
            GPSExportConfig config = new GPSExportConfig();
            config.deleteAfterExport = Boolean.parseBoolean(BB.get(KEY_DELETEAFTEREXPORT, Boolean.toString(true)));
            config.exportOnlyMarked = Boolean.parseBoolean(BB.get(KEY_EXPORTONLYMARKED, Boolean.toString(false)));
            this.gpsED.setConfiguration(config);
            SelectedGPSFeatureList retrievedSelectedGPSFeatureList = SelectedGPSFeatureList.retrieveSelectedGPSFeatureList(this.context);
            this.gpsED.setTableModel(retrievedSelectedGPSFeatureList);
            this.gpsED.addGPSExportDialogListener(this);
        }
        return this.gpsED;
    }

    @Override
    public boolean execute(PlugInContext context) {
        this.context = context;
        this.getDialog(JUMPWorkbench.getFrame()).setVisible(true);
        return true;
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(SaveGPSExportPlugIn.createExportAllowedCheck()).add(checkFactory.createTaskWindowMustBeActiveCheck());
    }

    private void writeSelectedGPSFeaturesToFile(Collection<SelectedGPSFeature> gpsfeature, File gpxFile) throws Exception {
        LinkedList<Element> routes = new LinkedList<Element>();
        LinkedList<Element> waypoints = new LinkedList<Element>();
        try {
            for (SelectedGPSFeature currFeat : gpsfeature) {
                Coordinate[] coordinates = currFeat.getCoordinates();
                if (coordinates.length > 1) {
                    Element rteElem = new Element("rte", SaveGPXFilePlugIn.NS_GPX);
                    routes.add(rteElem);
                    Element rteNameElem = new Element("name", SaveGPXFilePlugIn.NS_GPX);
                    rteNameElem.setText(currFeat.getText());
                    rteElem.addContent((Content)rteNameElem);
                    for (Object object : coordinates) {
                        Element rteptElement = new Element("rtept", SaveGPXFilePlugIn.NS_GPX);
                        rteElem.addContent((Content)rteptElement);
                        rteptElement.setAttribute("lat", GPXSupport.formatNumber(((Coordinate)object).y));
                        rteptElement.setAttribute("lon", GPXSupport.formatNumber(((Coordinate)object).x));
                    }
                }
                if (coordinates.length != 1) continue;
                Element wptElement = new Element("wpt", SaveGPXFilePlugIn.NS_GPX);
                Element wptNameElement = new Element("name", SaveGPXFilePlugIn.NS_GPX);
                wptElement.addContent((Content)wptNameElement);
                wptNameElement.setText(currFeat.getText());
                Object wptCoord = coordinates[0];
                wptElement.setAttribute("lat", GPXSupport.formatNumber(((Coordinate)wptCoord).y));
                wptElement.setAttribute("lon", GPXSupport.formatNumber(((Coordinate)wptCoord).x));
                waypoints.add(wptElement);
            }
            Document d = new Document();
            Element gpx = new Element("gpx", SaveGPXFilePlugIn.NS_GPX);
            gpx.setAttribute("version", "1.1");
            gpx.setAttribute("creator", "RIWA GIS Zentrum 2 http://www.riwa-gis.de");
            d.setRootElement(gpx);
            for (Element currWaypoint : waypoints) {
                gpx.addContent((Content)currWaypoint);
            }
            for (Element currTrack : routes) {
                gpx.addContent((Content)currTrack);
            }
            XMLOutputter out = new XMLOutputter();
            out.setFormat(Format.getPrettyFormat());
            out.output(d, (OutputStream)new FileOutputStream(gpxFile, false));
        }
        catch (Exception ex) {
            LOG.error("Error writning '" + String.valueOf(gpxFile) + "': " + ex.getLocalizedMessage(), (Throwable)ex);
            throw new Exception(I18N.getMessage("ui.plugin.gps.SaveGPXFilePlugIn.errorSave", gpxFile, ex.getLocalizedMessage()), ex);
        }
    }

    @Override
    public void showFeatures(Collection<SelectedGPSFeature> features) {
        this.context.getLayerViewPanel().getSelectionManager().clear();
        for (SelectedGPSFeature currFeat : features) {
            Layer ly = this.context.getLayerManager().getLayerByKey(currFeat.getLayerKey());
            try {
                SimpleFeature f = ly.getFeatureByKey(currFeat.getFeatureFID());
                this.context.getLayerViewPanel().getSelectionManager().getFeatureSelection().selectItems(ly, f);
            }
            catch (Exception ex) {
                LOG.warn("Error selecting feature on Layer '" + currFeat.getLayerKey() + "': " + currFeat.getFeatureFID(), (Throwable)ex);
            }
        }
        try {
            this.zoomToSelectedItemsPlugIn.zoom(this.context.getLayerViewPanel().getSelectionManager().getSelectedItems(), this.context.getLayerViewPanel());
        }
        catch (Exception ex) {
            LOG.warn("Error zooming", (Throwable)ex);
        }
    }

    @Override
    public void exportFeatures(Collection<SelectedGPSFeature> features) {
        try {
            File defFile = new File(BB.get(KEY_DIR, ""));
            File gpxFile = GPXSupport.selectGPXFile(this.context.getWorkbenchFrame(), defFile);
            if (gpxFile != null) {
                BB.put(KEY_DIR, gpxFile.toString());
                this.writeSelectedGPSFeaturesToFile(features, gpxFile);
            }
        }
        catch (Exception ex) {
            WorkbenchContext.getErrorHandler().handleThrowable(ex);
        }
    }

    @Override
    public void isClosing() {
    }

    @Override
    public void addSelectedFeaturesClicked(SelectedGPSFeatureList model) {
        try {
            SelectGPSExportPlugIn.addSelectedFeaturesToModel(this.context, model);
        }
        catch (Exception ex) {
            WorkbenchContext.getErrorHandler().handleThrowable(ex);
        }
    }
}

