/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.gps;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.gps.GPXElements;
import com.vividsolutions.jump.workbench.ui.plugin.layer.cad.CadFeatureAtts;
import com.vividsolutions.jump.workbench.ui.plugin.layer.redline.AddRedlineLayerPlugIn;
import de.riwagis.crs.CRSDefFactory;
import de.riwagis.crs.Transformer;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.components.WaitDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadGPXFilePlugIn
extends AbstractPlugIn
implements GPXElements {
    private static final Logger LOG = LoggerFactory.getLogger(LoadGPXFilePlugIn.class);
    private static final Blackboard BB = PersistentBlackboardPlugIn.get();
    public static final String KEY_DIR = LoadGPXFilePlugIn.class.getName() + "_Dir";
    private static final FileFilter GPX_FILEFILTER = GUISupport.createFileFilter((String)"GPX", (String[])new String[]{"gpx"});
    public static final GeometryFactory GEOM_FACTORY = new GeometryFactory();

    private static void addFeatures(RedlineLayer rdl, List<SimpleFeature> zeichenebeneFeatures) {
        boolean useDefaultFeature = rdl.getUseDefaultFeature();
        rdl.setUseDefaultFeature(false);
        try {
            rdl.editFeature(zeichenebeneFeatures, 1);
        }
        finally {
            rdl.setUseDefaultFeature(useDefaultFeature);
        }
    }

    private static void addPoints(List<SimpleFeature> punkteFeatures, List<Element> lstWpt, RedlineLayer rly, Transformer trans, Namespace ns) throws Exception {
        ArrayList<Element> l = new ArrayList<Element>();
        for (Element currWpt : lstWpt) {
            l.clear();
            l.add(currWpt);
            SimpleFeature currFeat = LoadGPXFilePlugIn.addRedlineGeometry(rly, l, trans, true);
            punkteFeatures.add(currFeat);
            StringBuilder sbText = new StringBuilder();
            if (StringUtils.isNotBlank((CharSequence)currWpt.getChildText("name", ns))) {
                sbText.append(currWpt.getChildText("name", ns));
            }
            if (StringUtils.isNotBlank((CharSequence)currWpt.getChildText("time", ns))) {
                sbText.append(" (").append(currWpt.getChildText("time", ns)).append(")");
            }
            if (StringUtils.isNotBlank((CharSequence)currWpt.getChildText("desc"))) {
                sbText.append(": ").append(currWpt.getChildText("desc"));
            }
            String text = sbText.toString().trim();
            currFeat.setAttribute(CadFeatureAtts.NAME.getName(), (Object)text);
            currFeat.setAttribute(CadFeatureAtts.MTEXT.getName(), (Object)text);
        }
    }

    private static SimpleFeature addRedlineGeometry(RedlineLayer rly, List<Element> lstWPt, Transformer trans, boolean isPoint) throws Exception {
        CoordinateArraySequence sq;
        SimpleFeatureType featType = rly.getFeatureType();
        Coordinate[] points = new Coordinate[lstWPt.size()];
        for (int i = 0; i < lstWPt.size(); ++i) {
            Element ptElem = lstWPt.get(i);
            points[i] = new Coordinate(Double.parseDouble(ptElem.getAttributeValue("lon")), Double.parseDouble(ptElem.getAttributeValue("lat")));
        }
        LineString p = null;
        if (lstWPt.size() > 1) {
            if (!isPoint) {
                sq = new CoordinateArraySequence(points);
                p = new LineString((CoordinateSequence)sq, GEOM_FACTORY);
            } else {
                Point[] xp = new Point[points.length];
                for (int i = 0; i < points.length; ++i) {
                    CoordinateArraySequence sq2 = new CoordinateArraySequence(new Coordinate[]{points[i]});
                    xp[i] = new Point((CoordinateSequence)sq2, GEOM_FACTORY);
                }
                p = new MultiPoint(xp, GEOM_FACTORY);
            }
        }
        if (lstWPt.size() == 1) {
            sq = new CoordinateArraySequence(points);
            p = new Point((CoordinateSequence)sq, GEOM_FACTORY);
        }
        SimpleFeature theFeature = null;
        if (p != null) {
            trans.transform2d(p);
            theFeature = FeatureUtil.createFeature((SimpleFeatureType)featType, (Geometry)p);
            FeatureUtil.copyFeatureData((SimpleFeature)rly.getDefaultFeature(), (SimpleFeature)theFeature);
            theFeature.setDefaultGeometry((Object)p);
        }
        return theFeature;
    }

    @Override
    public String getName() {
        return I18N.get("ui.plugin.gps.LoadGPXFilePlugIn.name");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        File[] gpxFiles = LoadGPXFilePlugIn.selectFiles(context.getWorkbenchFrame());
        WaitDialog dlgWait = new WaitDialog((Window)WorkbenchContext.getFrame(), I18N.get("common.wait"));
        Runnable run = () -> {
            try {
                if (!ArrayUtils.isEmpty((Object[])gpxFiles)) {
                    BB.put(KEY_DIR, gpxFiles[0].toString());
                    LoadGPXFilePlugIn.addGPXFiles(context, gpxFiles);
                }
            }
            catch (Exception e) {
                dlgWait.setError(e);
            }
        };
        dlgWait.addWorkToDo(run);
        dlgWait.setVisible(true);
        if (dlgWait.getError() != null) {
            ExceptionDialog.handleGuiException((Component)WorkbenchContext.getFrame(), (Throwable)dlgWait.getError(), (String)"riwagis");
        }
        return true;
    }

    public static void addGPXFiles(PlugInContext context, File[] arrFiles) throws Exception {
        SAXBuilder sb = new SAXBuilder();
        CoordinateReferenceSystem projCRS = context.getTask().getCRSDefinition().getCRS();
        if (projCRS == null) {
            throw new Exception(I18N.get("ui.plugin.gps.LoadGPXFilePlugIn.illegalCoordinateReferenceSystem"));
        }
        CoordinateReferenceSystem wgs84CRS = CRSDefFactory.createCRS((String)"EPSG:4326");
        Transformer trans = new Transformer(wgs84CRS, projCRS);
        for (File currGPXFile : arrFiles) {
            try {
                List tracksElem;
                List routes;
                Category cat = context.getLayerManager().addCategory(I18N.get("ui.plugin.gps.LoadGPXFilePlugIn.name"));
                String layername = context.getLayerManager().uniqueCategoryName(I18N.getMessage("ui.plugin.gps.LoadGPXFilePlugIn.gpxfile", FilenameUtils.getBaseName((String)currGPXFile.getName())));
                Category currentGPXFileCat = context.getLayerManager().addCategory(layername);
                cat.addSubcategory(currentGPXFileCat);
                LinkedList<SimpleFeature> punkteFeatures = new LinkedList<SimpleFeature>();
                Document gpxDoc = sb.build(currGPXFile);
                Namespace ns = gpxDoc.getRootElement().getNamespace();
                RedlineLayer pktLayer = AddRedlineLayerPlugIn.addLayer(context, currentGPXFileCat, I18N.get("ui.plugin.gps.LoadGPXFilePlugIn.points"));
                Element gpxElem = gpxDoc.getRootElement();
                List lstWpt = gpxElem.getChildren("wpt", ns);
                if (lstWpt.size() > 0) {
                    LinkedList<SimpleFeature> zeichenebeneFeatures = new LinkedList<SimpleFeature>();
                    RedlineLayer wptLayer = AddRedlineLayerPlugIn.addLayer(context, currentGPXFileCat, I18N.get("ui.plugin.gps.LoadGPXFilePlugIn.waypoints"));
                    ArrayList<Element> l = new ArrayList<Element>();
                    for (Element currWpt : lstWpt) {
                        l.clear();
                        l.add(currWpt);
                        SimpleFeature currFeat = LoadGPXFilePlugIn.addRedlineGeometry(wptLayer, l, trans, true);
                        zeichenebeneFeatures.add(currFeat);
                        StringBuilder sbText = new StringBuilder();
                        if (StringUtils.isNotBlank((CharSequence)currWpt.getChildText("name", ns))) {
                            sbText.append(currWpt.getChildText("name", ns));
                        }
                        if (StringUtils.isNotBlank((CharSequence)currWpt.getChildText("time", ns))) {
                            sbText.append(" (").append(currWpt.getChildText("time", ns)).append(")");
                        }
                        if (StringUtils.isNotBlank((CharSequence)currWpt.getChildText("desc"))) {
                            sbText.append(": ").append(currWpt.getChildText("desc"));
                        }
                        String text = sbText.toString().trim();
                        currFeat.setAttribute(CadFeatureAtts.NAME.getName(), (Object)text);
                        currFeat.setAttribute(CadFeatureAtts.MTEXT.getName(), (Object)text);
                    }
                    LoadGPXFilePlugIn.addFeatures(wptLayer, zeichenebeneFeatures);
                    LoadGPXFilePlugIn.addPoints(punkteFeatures, lstWpt, pktLayer, trans, ns);
                    if (zeichenebeneFeatures.size() > 0) {
                        RedlineLayer wptLayerText = AddRedlineLayerPlugIn.addLayer(context, currentGPXFileCat, I18N.get("ui.plugin.gps.LoadGPXFilePlugIn.waypointstext"));
                        LinkedList<SimpleFeature> zeichenebeneFeaturesText = new LinkedList<SimpleFeature>();
                        for (SimpleFeature currF : zeichenebeneFeatures) {
                            SimpleFeature fText = FeatureUtil.createFeature((SimpleFeatureType)wptLayerText.getFeatureType(), (Geometry)((Geometry)currF.getDefaultGeometry()));
                            String text = (String)currF.getAttribute(CadFeatureAtts.NAME.getName());
                            if (!StringUtils.isNotEmpty((CharSequence)text)) continue;
                            zeichenebeneFeaturesText.add(fText);
                            fText.setAttribute(CadFeatureAtts.TEXT.getName(), currF.getAttribute(CadFeatureAtts.NAME.getName()));
                        }
                        LoadGPXFilePlugIn.addFeatures(wptLayerText, zeichenebeneFeaturesText);
                    }
                }
                if ((routes = gpxElem.getChildren("rte", ns)).size() > 0) {
                    LinkedList<SimpleFeature> zeichenebeneFeatures = new LinkedList<SimpleFeature>();
                    RedlineLayer rteLayer = AddRedlineLayerPlugIn.addLayer(context, currentGPXFileCat, I18N.get("ui.plugin.gps.LoadGPXFilePlugIn.routes"));
                    for (Element currRoute : routes) {
                        String text = currRoute.getChildText("name", ns);
                        List routePoints = currRoute.getChildren("rtept", ns);
                        SimpleFeature currFeat = LoadGPXFilePlugIn.addRedlineGeometry(rteLayer, routePoints, trans, false);
                        if (currFeat != null) {
                            zeichenebeneFeatures.add(currFeat);
                            currFeat.setAttribute(CadFeatureAtts.NAME.getName(), (Object)text);
                            currFeat.setAttribute(CadFeatureAtts.MTEXT.getName(), (Object)text);
                        }
                        LoadGPXFilePlugIn.addPoints(punkteFeatures, routePoints, pktLayer, trans, ns);
                    }
                    LoadGPXFilePlugIn.addFeatures(rteLayer, zeichenebeneFeatures);
                }
                if ((tracksElem = gpxElem.getChildren("trk", ns)).size() > 0) {
                    for (int i = 0; i < tracksElem.size(); ++i) {
                        Element currTrackElem = (Element)tracksElem.get(i);
                        List trackSegElem = currTrackElem.getChildren("trkseg", ns);
                        LinkedList<SimpleFeature> zeichenebeneFeatures = new LinkedList<SimpleFeature>();
                        RedlineLayer trkLayer = AddRedlineLayerPlugIn.addLayer(context, currentGPXFileCat, I18N.getMessage("ui.plugin.gps.LoadGPXFilePlugIn.track", i, currTrackElem.getChildText("name", ns)));
                        for (Element currTrackSeg : trackSegElem) {
                            String text = currTrackSeg.getChildText("name", ns);
                            List trackPoints = currTrackSeg.getChildren("trkpt", ns);
                            SimpleFeature currFeat = LoadGPXFilePlugIn.addRedlineGeometry(trkLayer, trackPoints, trans, false);
                            if (currFeat != null) {
                                zeichenebeneFeatures.add(currFeat);
                                currFeat.setAttribute(CadFeatureAtts.NAME.getName(), (Object)text);
                                currFeat.setAttribute(CadFeatureAtts.MTEXT.getName(), (Object)text);
                            }
                            LoadGPXFilePlugIn.addPoints(punkteFeatures, trackPoints, pktLayer, trans, ns);
                        }
                        LoadGPXFilePlugIn.addFeatures(trkLayer, zeichenebeneFeatures);
                    }
                }
                LoadGPXFilePlugIn.addFeatures(pktLayer, punkteFeatures);
            }
            catch (Exception ex) {
                LOG.error("Error importing '" + String.valueOf(currGPXFile) + "': " + ex.getLocalizedMessage(), (Throwable)ex);
                throw new Exception(I18N.getMessage("ui.plugin.gps.LoadGPXFilePlugIn.errorLoad", currGPXFile, ex.getLocalizedMessage()), ex);
            }
        }
    }

    public static File[] selectFiles(Frame parent) {
        JFileChooser fChoose = GUISupport.createJFileChooser((boolean)true);
        fChoose.setAcceptAllFileFilterUsed(false);
        fChoose.setFileFilter(GPX_FILEFILTER);
        fChoose.setMultiSelectionEnabled(true);
        fChoose.setSelectedFile(new File(BB.get(KEY_DIR, "")));
        int intRetVal = fChoose.showOpenDialog(parent);
        if (intRetVal != 1) {
            return fChoose.getSelectedFiles();
        }
        return new File[0];
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return checkFactory.createTaskWindowMustBeActiveCheck();
    }
}

