/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.gps;

import de.riwagis.crs.CRSDefFactory;
import de.riwagis.crs.Transformer;
import de.riwagis.util.gui.GUISupport;
import java.awt.Frame;
import java.io.File;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FilenameUtils;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GPXSupport {
    private static final Logger LOG = LoggerFactory.getLogger(GPXSupport.class);
    private static final FileFilter GPX_FILEFILTER = GUISupport.createFileFilter((String)"GPX", (String[])new String[]{"gpx"});
    private static final DecimalFormat NF = GPXSupport.createGPXDecimalFormat();
    private static final CoordinateReferenceSystem WGS84CRS = GPXSupport.createWGS84CRS();

    public static final String formatNumber(double y) {
        return NF.format(y);
    }

    public static final Transformer buildTransformer(CoordinateReferenceSystem projectCRS) throws Exception {
        return new Transformer(projectCRS, WGS84CRS);
    }

    private static final CoordinateReferenceSystem createWGS84CRS() {
        try {
            return CRSDefFactory.createCRS((String)"EPSG:4326");
        }
        catch (Exception ex) {
            LOG.error("Error creating CRS", (Throwable)ex);
            return null;
        }
    }

    public static final File selectGPXFile(Frame parent, File defaultFile) {
        JFileChooser fChoose = GUISupport.createJFileChooserOverwritePrompting();
        fChoose.setAcceptAllFileFilterUsed(false);
        fChoose.setFileFilter(GPX_FILEFILTER);
        fChoose.setMultiSelectionEnabled(false);
        fChoose.setSelectedFile(defaultFile);
        int intRetVal = fChoose.showSaveDialog(parent);
        if (intRetVal != 1) {
            File selectedFile = fChoose.getSelectedFile();
            if (FilenameUtils.getExtension((String)selectedFile.getAbsolutePath()).isEmpty()) {
                selectedFile = new File(selectedFile.getAbsolutePath() + ".gpx");
            }
            return selectedFile;
        }
        return null;
    }

    private static final DecimalFormat createGPXDecimalFormat() {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        dfs.setGroupingSeparator('X');
        DecimalFormat lDF = new DecimalFormat("0.0", dfs);
        lDF.setGroupingUsed(false);
        lDF.setMaximumFractionDigits(13);
        lDF.setDecimalFormatSymbols(dfs);
        return lDF;
    }

    private GPXSupport() {
    }
}

