/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.gps;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.ui.plugin.gps.GPSExportConfig;
import com.vividsolutions.jump.workbench.ui.plugin.gps.GPSExportDialogListener;
import com.vividsolutions.jump.workbench.ui.plugin.gps.SelectedGPSFeature;
import com.vividsolutions.jump.workbench.ui.plugin.gps.SelectedGPSFeatureList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;

public class GPSExportDialog
extends JDialog {
    private final TableModelListener showRowCountListener = new TableModelListener(){

        @Override
        public void tableChanged(TableModelEvent e) {
            if (GPSExportDialog.this.jTable1.getModel() != null) {
                GPSExportDialog.this.jLabel2.setText(I18N.getMessage("ui.plugin.gpx.GPXExportDialog.entrycount", GPSExportDialog.this.jTable1.getModel().getRowCount()));
            }
        }
    };
    private SelectedGPSFeatureList tableModel;
    private final Set<GPSExportDialogListener> listeners = new LinkedHashSet<GPSExportDialogListener>();
    private JButton btnAddSelectedFeatures;
    private JButton btnClose;
    private JButton btnDeleteAll;
    private JButton btnDeleteSingle;
    private JButton btnShowInMap;
    private JButton btnStartExport;
    private JCheckBox chkDeleteAfterExport;
    private JCheckBox chkSelectedElementsOnly;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel6;
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private JTextPane jTextPane1;

    protected List<SelectedGPSFeature> selectedFeatures(boolean onlySelected) {
        LinkedList<SelectedGPSFeature> selected = new LinkedList<SelectedGPSFeature>();
        if (onlySelected) {
            for (int idx : this.jTable1.getSelectedRows()) {
                selected.add(this.tableModel.getEntry(idx));
            }
        } else {
            for (SelectedGPSFeature idx : this.tableModel) {
                selected.add(idx);
            }
        }
        return selected;
    }

    public void addGPSExportDialogListener(GPSExportDialogListener listener) {
        this.listeners.add(listener);
    }

    public void removeGPSExportDialogListener(GPSExportDialogListener listener) {
        this.listeners.remove(listener);
    }

    public GPSExportDialog(Frame parent) {
        super(parent, false);
        this.initComponents();
        this.i18n();
        this.setSize(280, 400);
        this.jTable1.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "selectNextColumnCell");
    }

    public void setTableModel(SelectedGPSFeatureList model) {
        if (this.tableModel != null) {
            model.removeTableModelListener(this.showRowCountListener);
        }
        this.tableModel = model;
        if (this.tableModel != null) {
            model.addTableModelListener(this.showRowCountListener);
        }
        this.jTable1.setModel(model);
        this.tableModel.fireTableDataChanged();
    }

    public void setConfiguration(GPSExportConfig expConf) {
        this.chkSelectedElementsOnly.setSelected(expConf.exportOnlyMarked);
        this.chkDeleteAfterExport.setSelected(expConf.deleteAfterExport);
    }

    public void getConfiguration(GPSExportConfig expConf) {
        expConf.exportOnlyMarked = this.chkSelectedElementsOnly.isSelected();
        expConf.deleteAfterExport = this.chkDeleteAfterExport.isSelected();
    }

    private void fireAddSelectedFeaturesClicked() {
        for (GPSExportDialogListener currListener : this.listeners) {
            currListener.addSelectedFeaturesClicked(this.tableModel);
        }
    }

    private void fireExportFeatures() {
        List<SelectedGPSFeature> selEntries = this.selectedFeatures(this.chkSelectedElementsOnly.isSelected());
        if (selEntries.size() > 0) {
            for (GPSExportDialogListener currListener : this.listeners) {
                currListener.exportFeatures(selEntries);
            }
            if (this.chkDeleteAfterExport.isSelected()) {
                this.tableModel.deleteEntries(selEntries);
            }
        }
    }

    private void fireIsClosing() {
        for (GPSExportDialogListener currListener : this.listeners) {
            currListener.isClosing();
        }
    }

    private void fireShowFeatures() {
        for (GPSExportDialogListener currListener : this.listeners) {
            currListener.showFeatures(this.selectedFeatures(true));
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jTextPane1 = new JTextPane();
        this.jPanel3 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jLabel2 = new JLabel();
        this.jPanel4 = new JPanel();
        this.jLabel1 = new JLabel();
        this.btnDeleteSingle = new JButton();
        this.btnShowInMap = new JButton();
        this.btnDeleteAll = new JButton();
        this.jPanel6 = new JPanel();
        this.chkSelectedElementsOnly = new JCheckBox();
        this.chkDeleteAfterExport = new JCheckBox();
        this.btnStartExport = new JButton();
        this.jPanel2 = new JPanel();
        this.btnAddSelectedFeatures = new JButton();
        this.btnClose = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("GPX-Export");
        this.setMinimumSize(new Dimension(280, 400));
        this.setName("GPXExport");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                GPSExportDialog.this.formWindowClosed(evt);
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                GPSExportDialog.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(I18N.get("ui.plugin.gpx.GPXExportDialog.remarktitle")));
        this.jPanel1.setPreferredSize(new Dimension(250, 78));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jTextPane1.setBackground(new Color(212, 208, 200));
        this.jTextPane1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jTextPane1.setEditable(false);
        this.jTextPane1.setText("Die Genauigkeit der Koordinatenumrechnung in das GPS Koordinatensystem (WGS84) liegt bei etwa ein bis zwei Metern. ");
        this.jTextPane1.setMargin(new Insets(3, 3, 30, 3));
        this.jTextPane1.setMaximumSize(null);
        this.jTextPane1.setPreferredSize(new Dimension(250, 78));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jTextPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel3.setMinimumSize(new Dimension(0, 224));
        this.jPanel3.setPreferredSize(new Dimension(0, 224));
        this.jPanel3.setLayout(new GridBagLayout());
        this.jScrollPane1.setMaximumSize(null);
        this.jScrollPane1.setMinimumSize(null);
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable1.setMaximumSize(null);
        this.jTable1.setMinimumSize(null);
        this.jTable1.setPreferredSize(null);
        this.jTable1.setRowHeight(16);
        this.jScrollPane1.setViewportView(this.jTable1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabel2.setHorizontalAlignment(11);
        this.jLabel2.setText("jLabel2");
        this.jLabel2.setMaximumSize(null);
        this.jLabel2.setMinimumSize(null);
        this.jLabel2.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.jPanel3.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel4.setMaximumSize(null);
        this.jLabel1.setText("Auswahl:");
        this.btnDeleteSingle.setText("l\u00f6schen");
        this.btnDeleteSingle.setMargin(new Insets(1, 7, 1, 7));
        this.btnDeleteSingle.setMaximumSize(null);
        this.btnDeleteSingle.setMinimumSize(null);
        this.btnDeleteSingle.setPreferredSize(null);
        this.btnDeleteSingle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GPSExportDialog.this.btnDeleteSingleActionPerformed(evt);
            }
        });
        this.btnShowInMap.setText("in Karte anzeigen");
        this.btnShowInMap.setMargin(new Insets(1, 7, 1, 7));
        this.btnShowInMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GPSExportDialog.this.btnShowInMapActionPerformed(evt);
            }
        });
        this.btnDeleteAll.setText("Liste leeren");
        this.btnDeleteAll.setMargin(new Insets(1, 7, 1, 7));
        this.btnDeleteAll.setMaximumSize(null);
        this.btnDeleteAll.setMinimumSize(null);
        this.btnDeleteAll.setPreferredSize(null);
        this.btnDeleteAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GPSExportDialog.this.btnDeleteAllActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnDeleteSingle, -2, 90, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnDeleteAll, -2, 103, -2).addComponent(this.btnShowInMap, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.btnDeleteSingle, -2, -1, -2).addComponent(this.btnShowInMap)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnDeleteAll, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.jPanel4, gridBagConstraints);
        this.jPanel6.setBorder(BorderFactory.createTitledBorder("Export"));
        this.jPanel6.setLayout(new GridBagLayout());
        this.chkSelectedElementsOnly.setText("Nur ausgew\u00e4hlte Elemente exportieren");
        this.chkSelectedElementsOnly.setMaximumSize(null);
        this.chkSelectedElementsOnly.setMinimumSize(null);
        this.chkSelectedElementsOnly.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel6.add((Component)this.chkSelectedElementsOnly, gridBagConstraints);
        this.chkDeleteAfterExport.setText("Nach Export aus Liste entfernen");
        this.chkDeleteAfterExport.setMaximumSize(null);
        this.chkDeleteAfterExport.setMinimumSize(null);
        this.chkDeleteAfterExport.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel6.add((Component)this.chkDeleteAfterExport, gridBagConstraints);
        this.btnStartExport.setText("Export starten");
        this.btnStartExport.setMargin(new Insets(1, 7, 1, 7));
        this.btnStartExport.setMaximumSize(null);
        this.btnStartExport.setMinimumSize(null);
        this.btnStartExport.setPreferredSize(null);
        this.btnStartExport.setSelected(true);
        this.btnStartExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GPSExportDialog.this.btnStartExportActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel6.add((Component)this.btnStartExport, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.jPanel6, gridBagConstraints);
        this.jPanel2.setRequestFocusEnabled(false);
        this.jPanel2.setLayout(new GridBagLayout());
        this.btnAddSelectedFeatures.setText("Objekte dazu");
        this.btnAddSelectedFeatures.setToolTipText("Selektierte Objekte aus Karte hinzuf\u00fcgen");
        this.btnAddSelectedFeatures.setMargin(new Insets(1, 7, 1, 7));
        this.btnAddSelectedFeatures.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GPSExportDialog.this.btnAddSelectedFeaturesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.btnAddSelectedFeatures, gridBagConstraints);
        this.btnClose.setText("Schliessen");
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GPSExportDialog.this.btnCloseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.jPanel2.add((Component)this.btnClose, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.pack();
    }

    private void i18n() {
        this.setTitle(I18N.get("ui.plugin.gpx.GPXExportDialog.title"));
        this.jTextPane1.setText(I18N.get("ui.plugin.gpx.GPXExportDialog.remark"));
        this.btnClose.setText(I18N.get("ui.plugin.gpx.GPXExportDialog.btnClose"));
        this.btnDeleteAll.setText(I18N.get("ui.plugin.gpx.GPXExportDialog.btnDeleteAll"));
        this.btnDeleteSingle.setText(I18N.get("ui.plugin.gpx.GPXExportDialog.btnDeleteSingle"));
        this.btnShowInMap.setText(I18N.get("ui.plugin.gpx.GPXExportDialog.btnShowInMap"));
        this.btnStartExport.setText(I18N.get("ui.plugin.gpx.GPXExportDialog.btnStartExport"));
        this.chkDeleteAfterExport.setText(I18N.get("ui.plugin.gpx.GPXExportDialog.chkDeleteAfterExport"));
        this.chkSelectedElementsOnly.setText(I18N.get("ui.plugin.gpx.GPXExportDialog.chkSelectedElementsOnly"));
        this.btnAddSelectedFeatures.setText(I18N.get("ui.plugin.gpx.GPXExportDialog.btnAddSelectedFeatures"));
        this.btnAddSelectedFeatures.setToolTipText(I18N.get("ui.plugin.gpx.GPXExportDialog.btnAddSelectedFeatures.tooltip"));
    }

    private void btnDeleteAllActionPerformed(ActionEvent evt) {
        if (this.tableModel != null) {
            this.tableModel.deleteAllEntries();
        }
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.fireIsClosing();
        this.setVisible(false);
    }

    private void btnStartExportActionPerformed(ActionEvent evt) {
        this.fireExportFeatures();
    }

    private void btnDeleteSingleActionPerformed(ActionEvent evt) {
        this.tableModel.deleteEntries(this.jTable1.getSelectedRows());
    }

    private void btnShowInMapActionPerformed(ActionEvent evt) {
        this.fireShowFeatures();
    }

    private void formWindowClosing(WindowEvent evt) {
    }

    private void btnAddSelectedFeaturesActionPerformed(ActionEvent evt) {
        this.fireAddSelectedFeaturesClicked();
    }

    private void formWindowClosed(WindowEvent evt) {
    }
}

