/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.dxf;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;

class FileEncodingDetector {
    private static final byte[] UTF8_BOM = new byte[]{-17, -69, -65};

    FileEncodingDetector() {
    }

    public static boolean fileIsUtf8BomEncoded(Path filePath) throws IOException {
        try (InputStream is = Files.newInputStream(filePath, new OpenOption[0]);){
            byte[] fileStart = new byte[3];
            int bytesRead = is.read(fileStart);
            if (bytesRead > 0 && bytesRead < 3) {
                boolean bl = false;
                return bl;
            }
            boolean bl = Arrays.equals(UTF8_BOM, fileStart);
            return bl;
        }
    }

    public static boolean doesEncodingMatchFileContent(Path filePath, Charset charset) {
        boolean bl;
        CharsetDecoder decoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        InputStreamReader reader = new InputStreamReader(Files.newInputStream(filePath, new OpenOption[0]), decoder);
        try {
            StringWriter writer = new StringWriter();
            reader.transferTo(writer);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                return false;
            }
        }
        ((Reader)reader).close();
        return bl;
    }
}

