/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.dxf;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.CategoryEventType;
import com.vividsolutions.jump.workbench.model.DimLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.plugin.AbstractExportPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.dxf.ACadColorIndex;
import com.vividsolutions.jump.workbench.ui.plugin.dxf.AutocadUnicodeEscaper;
import com.vividsolutions.jump.workbench.ui.plugin.dxf.DxfExportDialog;
import com.vividsolutions.jump.workbench.ui.plugin.dxf.DxfExportParameters;
import com.vividsolutions.jump.workbench.ui.plugin.dxf.DxfFeatureParameters;
import com.vividsolutions.jump.workbench.ui.plugin.dxf.DxfGeometryParameters;
import com.vividsolutions.jump.workbench.ui.plugin.dxf.FileEncodingDetector;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.ExportStyle;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.ExportStyleFactory;
import com.vividsolutions.jump.workbench.ui.visibility.VisibilityPanel;
import com.vividsolutions.jump.workbench.ui.visibility.VisibilityProfile;
import de.riwagis.geotools.data.riwasrv.RiwaSrvDataStore;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.riwajump.data.model.DMDCollection;
import de.riwagis.unit.DrawingUnit;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.jts.JTSSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.Normalizer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.commons.text.translate.CharSequenceTranslator;
import org.geotools.data.DataStore;
import org.geotools.data.Query;
import org.geotools.feature.FeatureIterator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.geom.util.AffineTransformation;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DxfExportPlugIn
extends AbstractExportPlugIn {
    private static final Logger LOG = LoggerFactory.getLogger(DxfExportPlugIn.class);
    private static final String DEFAULT_CHARSET = "ANSI_1252";
    private static final NumberFormat nf = NumberFormat.getInstance();
    private static final Pattern ACAD_PATTERN = Pattern.compile("[\"<>/\\:;?*|,=`]");
    private static final double RIWA_LINE_2_ACAD = 0.25;
    private static final int TRANSPARENCY_BOUNDARY = 200;
    private int dxf_cnt = 300000;
    private final Map<Object, String> mapTextSyle = new HashMap<Object, String>();
    private int newTextStyleCnt = 0;
    private int dxfTextStyleCnt = 0;
    private final Map<Object, String> mapLineType = new HashMap<Object, String>();
    private int newLineTypeCnt = 0;
    private final Map<Object, String> mapBlock = new HashMap<Object, String>();
    private int newBlockCnt = 0;
    private int iAcadUnit = 0;
    private int DxfVersion = 0;
    private AffineTransformation trans = null;
    private double transrot = 0.0;
    private double txt_ori_set = 1000.0;
    private double sym_ori_set = 1000.0;
    private double maxAreaSquareKilometers = 64.0;
    private int maxFeaturesRiwaSrvDatastore = 100000;

    @Override
    public void initialize(PlugInContext context) {
        try {
            if (JUMPWorkbench.GIS_CONTEXT != null) {
                Object objMaxArea = JUMPWorkbench.GIS_CONTEXT.getModuleApp().getUserInfo().get("usr_maxarea4export_sqkm");
                Object objMaxFeatures = JUMPWorkbench.GIS_CONTEXT.getModuleApp().getUserInfo().get("usr_maxfeatures4export");
                if (objMaxArea != null) {
                    this.maxAreaSquareKilometers = Double.parseDouble(objMaxArea.toString());
                    if (this.maxAreaSquareKilometers <= 0.0) {
                        this.maxAreaSquareKilometers = 2.147483647E9;
                    }
                }
                if (objMaxFeatures != null) {
                    this.maxFeaturesRiwaSrvDatastore = Integer.parseInt(objMaxFeatures.toString());
                    if (this.maxFeaturesRiwaSrvDatastore <= 0) {
                        this.maxFeaturesRiwaSrvDatastore = Integer.MAX_VALUE;
                    }
                }
            } else {
                this.maxAreaSquareKilometers = 2.147483647E9;
                this.maxFeaturesRiwaSrvDatastore = Integer.MAX_VALUE;
            }
        }
        catch (Throwable t) {
            LOG.error(String.format("Unexpected error reading limits for data export. Limits are now for features %s, area %s.", this.maxFeaturesRiwaSrvDatastore, this.maxAreaSquareKilometers), t);
        }
    }

    @Override
    public boolean execute(PlugInContext context) {
        LOG.info("Charset: {}", (Object)Charset.defaultCharset().toString());
        LOG.info("Locale: {}", (Object)Locale.getDefault().toString());
        DxfExportDialog dlgDxfExp = new DxfExportDialog(context.getWorkbenchFrame(), this, context);
        dlgDxfExp.setEnvelope2VisibleRectangle();
        dlgDxfExp.setVisible(true);
        return true;
    }

    @Override
    public EnableCheck createEnableCheck() {
        return new MultiEnableCheck().add(DxfExportPlugIn.createExportAllowedCheck()).add(EnableCheckFactory.getInstance().createWindowWithLayerManagerMustBeActiveCheck());
    }

    @Override
    public String getName() {
        return I18N.get("ui.plugin.dxf.DxfExportPlugIn.name") + "...";
    }

    protected void dxfPoint(BufferedWriter dxf, Geometry geom, String lyName) throws Exception {
        Point point = (Point)geom;
        Coordinate[] p = point.getCoordinates();
        int cnt = point.getNumPoints();
        dxf.write("\r\n  0\r\nPOINT\r\n  5\r\n" + Integer.toHexString(this.dxf_cnt++).toUpperCase() + "\r\n330\r\n18\r\n100\r\nAcDbEntity");
        dxf.write("\r\n  8\r\n" + lyName + "\r\n100\r\nAcDbPoint");
        for (int i = 0; i < cnt; ++i) {
            dxf.write("\r\n 10\r\n" + p[i].x + "\r\n 20\r\n" + p[i].y + "\r\n 30\r\n0.0");
        }
    }

    private double getZ(Coordinate coord, SimpleFeature f) {
        if (FeatureUtil.hasAttribute((SimpleFeature)f, (String)"z")) {
            Object objZ = FeatureUtil.getAttribute((SimpleFeature)f, (String)"z");
            if (objZ != null && objZ instanceof Number) {
                return ((Number)objZ).doubleValue();
            }
            return 0.0;
        }
        double z = coord.getZ();
        if (Double.isNaN(z) || z == 0.0) {
            return 0.0;
        }
        return z;
    }

    private void dxfSymbol(BufferedWriter dxf, DxfExportParameters expParams, DxfFeatureParameters featParams, DxfGeometryParameters geomParams) throws Exception {
        String strSymbolName = featParams.getExportStyle().getSymName4Geom(geomParams.getExportStyleGeometryType());
        double scaleX = featParams.getExportStyle().getSymWidth4Geom(geomParams.getExportStyleGeometryType());
        double scaleY = featParams.getExportStyle().isUseSymHeight4Geom(geomParams.getExportStyleGeometryType()) ? featParams.getExportStyle().getSymHeight4Geom(geomParams.getExportStyleGeometryType()) : scaleX;
        Color fillColor = featParams.getExportStyle().getSymFillColor();
        int iSymColor = DxfExportPlugIn.colorToInt(fillColor);
        int iACIcolSym = ACadColorIndex.getACadColorIndex(fillColor).getIndex();
        int idxDot = strSymbolName.indexOf(46);
        String sName = idxDot > 0 ? strSymbolName.substring(0, idxDot).toUpperCase().replace('/', '$') : strSymbolName.toUpperCase().replace('/', '$');
        if (!this.mapBlock.containsValue(sName.toUpperCase())) {
            this.mapBlock.put(this.newBlockCnt++, sName.toUpperCase());
        }
        for (ExportStyle.InsertionPoint currSym : featParams.getExportStyle().getSymInsertPoints()) {
            Coordinate p = currSym.getCoordinate();
            p.setZ(this.getZ(p, featParams.getFeature()));
            double rotate = this.sym_ori_set < 1000.0 ? this.txt_ori_set : currSym.getOrientation() + this.transrot;
            Coordinate pd = DxfExportPlugIn.transform2DpreserveZ(this.trans, p);
            JTSSupport.to3D((Coordinate)pd);
            dxf.write("\r\n  0\r\nINSERT\r\n  5\r\n" + Integer.toHexString(this.dxf_cnt++).toUpperCase() + "\r\n330\r\n18\r\n100\r\nAcDbEntity");
            dxf.write("\r\n  8\r\n" + featParams.getLayerName());
            if (!featParams.getExportStyle().isSymOverwriteFillColor()) {
                dxf.write("\r\n 62\r\n0");
            }
            if (this.DxfVersion >= 2004 && featParams.getExportStyle().isSymOverwriteFillColor()) {
                dxf.write("\r\n420\r\n" + iSymColor);
            }
            dxf.write("\r\n100\r\nAcDbBlockReference\r\n  2\r\n" + sName + "\r\n 10\r\n" + pd.x + "\r\n 20\r\n" + pd.y + "\r\n");
            dxf.write(" 30\r\n" + pd.getZ() + "\r\n 41\r\n" + scaleX + "\r\n 42\r\n" + scaleY + "\r\n 50\r\n" + rotate);
        }
    }

    private Coordinate correctTextPosition(Coordinate p, double d, double w, int linecnt, double korr) {
        Coordinate pt = new Coordinate();
        double dt = d * 1.3 * (double)linecnt + d * korr;
        double b = Math.toRadians(w);
        pt.x = p.x + dt * Math.sin(b);
        pt.y = p.y - dt * Math.cos(b);
        pt.setZ(p.getZ());
        return pt;
    }

    private void dxfText(BufferedWriter dxf, DxfExportParameters expParams, DxfFeatureParameters featParams, DxfGeometryParameters geomParams) throws Exception {
        ExportStyle expStyle = featParams.getExportStyle();
        String strText = this.transformToUnicode(this.newLineToHtml(expStyle.getText()), expParams.getCharset());
        Font TextFont = expStyle.getTextFont();
        String strFontText = TextFont.getFontName();
        int iTxtColor = DxfExportPlugIn.colorToInt(expStyle.getTextColor());
        int iACI_Text = ACadColorIndex.getACadColorIndex(expStyle.getTextColor()).getIndex();
        double dblHeight = expStyle.getTextSize() * 0.75;
        if (!this.mapTextSyle.containsValue(strFontText.toUpperCase())) {
            this.mapTextSyle.put(this.newTextStyleCnt++, strFontText.toUpperCase());
        }
        String[] arrText = strText.split("<BR>");
        for (ExportStyle.InsertionPoint currInsPoint : expStyle.getTextInsertPoints()) {
            for (int l = 0; l < arrText.length; ++l) {
                String currText = arrText[l];
                if (currText == null || currText.isEmpty()) continue;
                Coordinate ptxt = currInsPoint.getCoordinate();
                Coordinate pd = DxfExportPlugIn.transform2DpreserveZ(this.trans, ptxt);
                JTSSupport.to3D((Coordinate)pd);
                double dblOriText = this.txt_ori_set < 1000.0 ? this.txt_ori_set : currInsPoint.getOrientation() + this.transrot;
                int intTextInsert = currInsPoint.getPosition();
                ptxt = intTextInsert > 6 ? this.correctTextPosition(pd, dblHeight, dblOriText, l - arrText.length + 1, 0.3) : this.correctTextPosition(pd, dblHeight, dblOriText, l, 0.3);
                dxf.write("\r\n  0\r\nTEXT\r\n  5\r\n" + Integer.toHexString(this.dxf_cnt++).toUpperCase() + "\r\n330\r\n18\r\n100\r\nAcDbEntity");
                dxf.write("\r\n  8\r\n" + featParams.getLayerName() + "\r\n100\r\nAcDbText");
                if (iACI_Text >= 0) {
                    dxf.write("\r\n 62\r\n" + iACI_Text);
                }
                if (this.DxfVersion >= 2004 && iACI_Text != 7) {
                    dxf.write("\r\n420\r\n" + iTxtColor);
                }
                dxf.write("\r\n 10\r\n" + ptxt.x + "\r\n 20\r\n" + ptxt.y + "\r\n 30\r\n" + ptxt.getZ());
                dxf.write("\r\n 11\r\n" + ptxt.x + "\r\n 21\r\n" + ptxt.y + "\r\n 31\r\n" + ptxt.getZ());
                int hor = (intTextInsert - 1) % 3;
                if (hor > 2) {
                    hor = 0;
                }
                int ver = 3 - (intTextInsert - 1) / 3;
                dxf.write("\r\n 40\r\n" + dblHeight + "\r\n 71\r\n   0\r\n 72\r\n " + hor);
                dxf.write("\r\n  1\r\n" + currText.replaceAll("\r\n", "\\P") + "\r\n 50\r\n" + dblOriText);
                dxf.write("\r\n  7\r\n" + strFontText);
                dxf.write("\r\n100\r\nAcDbText");
                dxf.write("\r\n 73\r\n" + ver);
            }
        }
    }

    private String transformToUnicode(String text, Charset charset) {
        StringEscapeUtils.Builder escaper = StringEscapeUtils.builder((CharSequenceTranslator)new AutocadUnicodeEscaper(charset));
        String nfcNormalized = Normalizer.normalize(text, Normalizer.Form.NFC);
        return escaper.escape(nfcNormalized).toString();
    }

    private String newLineToHtml(String text) {
        return text.replaceAll("\r\n", "<BR>").replaceAll("\n", "<BR>").replaceAll("\r", "<BR>");
    }

    private void dxfLine(BufferedWriter dxf, DxfExportParameters expParams, DxfFeatureParameters featParams, DxfGeometryParameters geomParams) throws Exception {
        Object LName;
        LineString line = (LineString)geomParams.getGeom();
        ExportStyle expStyle = featParams.getExportStyle();
        int cnt = line.getNumPoints();
        int iLineColor = DxfExportPlugIn.colorToInt(expStyle.getLineBaseColor());
        Color cl = expStyle.getLineBaseColor();
        int iACI_Line = ACadColorIndex.getACadColorIndex(expStyle.getLineBaseColor()).getIndex();
        String linePattern = expStyle.getLineBasePattern();
        if (linePattern == null || linePattern.isEmpty()) {
            LName = "Continuous";
        } else {
            if (linePattern.indexOf(44) > 0) {
                linePattern = linePattern.replace(",", "_");
            }
            LName = linePattern.length() > 29 ? "L_" + linePattern.substring(0, 29) : "L_" + linePattern;
        }
        if (!this.mapLineType.containsValue(((String)LName).toUpperCase())) {
            this.mapLineType.put("N" + this.newLineTypeCnt, ((String)LName).toUpperCase());
            this.mapLineType.put("P" + this.newLineTypeCnt, linePattern);
            ++this.newLineTypeCnt;
        }
        dxf.write("\r\n  0\r\nLWPOLYLINE\r\n  5\r\n" + Integer.toHexString(this.dxf_cnt++).toUpperCase() + "\r\n330\r\n18\r\n100\r\nAcDbEntity");
        dxf.write("\r\n  8\r\n" + featParams.getLayerName());
        if (((String)LName).startsWith("L_")) {
            dxf.write("\r\n  6\r\n" + (String)LName);
        }
        if (iACI_Line >= 0) {
            dxf.write("\r\n 62\r\n" + iACI_Line);
        }
        if (this.DxfVersion >= 2004 && iACI_Line != 7) {
            dxf.write("\r\n420\r\n" + iLineColor);
        }
        if (((String)LName).startsWith("L_")) {
            dxf.write("\r\n 48\r\n0.25");
        }
        Object strLineWidth = " 0.0";
        if (expParams.isExpLineWidth()) {
            strLineWidth = " " + expStyle.getLineBaseWidth();
        }
        dxf.write("\r\n100\r\nAcDbPolyline\r\n 90\r\n" + cnt + "\r\n 70\r\n   0\r\n 43\r\n " + (String)strLineWidth);
        Coordinate coord4elevation = line.getCoordinateN(0);
        JTSSupport.to3D((Coordinate)coord4elevation);
        dxf.write("\r\n 38\r\n" + this.getZ(coord4elevation, featParams.getFeature()));
        for (int i = 0; i < cnt; ++i) {
            Coordinate ps = line.getCoordinateN(i);
            Coordinate pd = DxfExportPlugIn.transform2DpreserveZ(this.trans, ps);
            dxf.write("\r\n 10\r\n" + pd.x + "\r\n 20\r\n" + pd.y);
        }
    }

    private static int colorToInt(Color c) {
        return 65536 * c.getRed() + 256 * c.getGreen() + c.getBlue();
    }

    private void dxfPolygon(BufferedWriter dxf, DxfExportParameters expParams, DxfFeatureParameters featParams, DxfGeometryParameters geomParams) throws Exception {
        int dxf_hatch_id = 0;
        int dxf_poly_id = 0;
        Polygon poly = (Polygon)geomParams.getGeom();
        Coordinate coord4elevation = poly.getExteriorRing().getCoordinateN(0);
        JTSSupport.to3D((Coordinate)coord4elevation);
        double elevation = this.getZ(coord4elevation, featParams.getFeature());
        ExportStyle expStyle = featParams.getExportStyle();
        LinearRing line = poly.getExteriorRing();
        int cnt = line.getNumPoints();
        dxf_poly_id = this.dxf_cnt++;
        if (expStyle.isRenderingArea() || expStyle.isRenderingAreaHatch()) {
            dxf_hatch_id = this.dxf_cnt++;
            this.dxfHatch(dxf, (Geometry)poly, featParams.getLayerName(), dxf_hatch_id, dxf_poly_id, elevation, expStyle);
        }
        dxf.write("\r\n  0\r\nLWPOLYLINE\r\n  5\r\n" + Integer.toHexString(dxf_poly_id).toUpperCase());
        if (dxf_hatch_id > 0) {
            dxf.write("\r\n102\r\n{ACAD_REACTORS\r\n330\r\n" + Integer.toHexString(dxf_hatch_id).toUpperCase() + "\r\n102\r\n}");
        }
        int iLineColor = DxfExportPlugIn.colorToInt(expStyle.getLineBaseColor());
        int iACI_Line = ACadColorIndex.getACadColorIndex(expStyle.getLineBaseColor()).getIndex();
        dxf.write("\r\n330\r\n18\r\n100\r\nAcDbEntity");
        dxf.write("\r\n  8\r\n" + featParams.getLayerName());
        dxf.write("\r\n 62\r\n" + iACI_Line);
        if (this.DxfVersion >= 2004 && iACI_Line != 7) {
            dxf.write("\r\n420\r\n" + iLineColor);
        }
        Object strLineWidth = " 0.0";
        if (expParams.isExpLineWidth()) {
            strLineWidth = " " + expStyle.getLineBaseWidth();
        }
        dxf.write("\r\n100\r\nAcDbPolyline\r\n 90\r\n" + cnt + "\r\n 70\r\n   1\r\n 43\r\n " + (String)strLineWidth);
        dxf.write("\r\n 38\r\n" + elevation);
        for (int i = 0; i < cnt; ++i) {
            Coordinate ps = line.getCoordinateN(i);
            Coordinate pd = DxfExportPlugIn.transform2DpreserveZ(this.trans, ps);
            dxf.write("\r\n 10\r\n" + pd.x + "\r\n 20\r\n" + pd.y);
        }
        int cnthole = poly.getNumInteriorRing();
        for (int l = 0; l < cnthole; ++l) {
            this.dxfPolygonHole(dxf, expParams, featParams, geomParams, dxf_hatch_id, l, elevation);
        }
    }

    private void dxfPolygonHole(BufferedWriter dxf, DxfExportParameters expParams, DxfFeatureParameters featParams, DxfGeometryParameters geomParams, int dxf_hatch_id, int iRing, double elevation) throws Exception {
        Polygon poly = (Polygon)geomParams.getGeom();
        ExportStyle expStyle = featParams.getExportStyle();
        LinearRing line = poly.getInteriorRingN(iRing);
        int cnt = line.getNumPoints();
        int dxf_poly_id = this.dxf_cnt++;
        dxf.write("\r\n  0\r\nLWPOLYLINE\r\n  5\r\n" + Integer.toHexString(dxf_poly_id).toUpperCase());
        if (expStyle.isRenderingArea() || expStyle.isRenderingAreaHatch()) {
            dxf.write("\r\n102\r\n{ACAD_REACTORS\r\n330\r\n" + Integer.toHexString(dxf_hatch_id).toUpperCase() + "\r\n102\r\n}");
        }
        int iLineColor = DxfExportPlugIn.colorToInt(expStyle.getLineBaseColor());
        int iACI_Line = ACadColorIndex.getACadColorIndex(expStyle.getLineBaseColor()).getIndex();
        dxf.write("\r\n330\r\n18\r\n100\r\nAcDbEntity");
        dxf.write("\r\n  8\r\n" + featParams.getLayerName());
        dxf.write("\r\n 62\r\n" + iACI_Line);
        if (this.DxfVersion >= 2004 && iACI_Line != 7) {
            dxf.write("\r\n420\r\n" + iLineColor);
        }
        Object strLineWidth = " 0.0";
        if (expParams.isExpLineWidth()) {
            strLineWidth = " " + expStyle.getLineBaseWidth();
        }
        dxf.write("\r\n100\r\nAcDbPolyline\r\n 90\r\n" + cnt + "\r\n 70\r\n   1\r\n 43\r\n " + (String)strLineWidth);
        dxf.write("\r\n 38\r\n" + elevation);
        for (int i = 0; i < cnt; ++i) {
            Coordinate ps = line.getCoordinateN(i);
            Coordinate pd = DxfExportPlugIn.transform2DpreserveZ(this.trans, ps);
            dxf.write("\r\n 10\r\n" + pd.x + "\r\n 20\r\n" + pd.y);
        }
    }

    private void dxfHatch(BufferedWriter dxf, Geometry geom, String lyName, int dxf_hatch_id, int dxf_poly_id, double elevation, ExportStyle expStyle) throws Exception {
        int hatchkey;
        String HatchName;
        Polygon poly = (Polygon)geom;
        LinearRing line = poly.getExteriorRing();
        int cnt = line.getNumPoints() - 1;
        Color HatchColor = expStyle.getAreaColor();
        int iACI_Fill = ACadColorIndex.getACadColorIndex(HatchColor).getIndex();
        int iFillColor = DxfExportPlugIn.colorToInt(HatchColor);
        double dFillWitdh = expStyle.getAreaHatchWidth() / 5.0;
        int iTransparenz = HatchColor.getAlpha();
        if (iTransparenz < 5) {
            return;
        }
        dxf.write("\r\n  0\r\nHATCH\r\n  5\r\n" + Integer.toHexString(dxf_hatch_id).toUpperCase() + "\r\n330\r\n18\r\n100\r\nAcDbEntity");
        dxf.write("\r\n  8\r\n" + lyName);
        double[][] hatchtyp = new double[][]{{0.0, 45.0, -2.245, 2.245}, {90.0, 135.0, -2.245, -2.245}, {135.0, 180.0, 0.0, -3.175}, {45.0, 90.0, -3.175, 0.0}};
        if (iACI_Fill >= 0) {
            dxf.write("\r\n 62\r\n" + iACI_Fill);
        }
        if (this.DxfVersion >= 2004 && iACI_Fill != 7) {
            dxf.write("\r\n420\r\n" + iFillColor);
        }
        if ((HatchName = expStyle.getAreaHatch()) == null || HatchName.isEmpty()) {
            if (iTransparenz < 200) {
                double d;
                HatchName = "ANSI31";
                hatchkey = 1;
                dFillWitdh = iTransparenz;
                if (d < 1.0) {
                    dFillWitdh = 1.0;
                }
                dFillWitdh /= 200.0;
            } else {
                HatchName = "SOLID";
                hatchkey = -1;
            }
        } else {
            switch (HatchName) {
                case "hatch-right-left.svg": {
                    hatchkey = 1;
                    HatchName = "ANSI31";
                    break;
                }
                case "hatch-horizontal.svg": {
                    hatchkey = 2;
                    HatchName = "ANSI31";
                    break;
                }
                case "hatch-vertical.svg": {
                    hatchkey = 3;
                    HatchName = "ANSI31";
                    break;
                }
                default: {
                    hatchkey = 0;
                    HatchName = "ANSI31";
                }
            }
        }
        int cnthole = poly.getNumInteriorRing();
        dxf.write("\r\n100\r\nAcDbHatch\r\n 10\r\n0.0\r\n 20\r\n0.0\r\n 30\r\n" + elevation + "\r\n210\r\n0.0\r\n220\r\n0.0\r\n230\r\n1.0");
        if (!HatchName.equals("SOLID")) {
            dxf.write("\r\n  2\r\n" + HatchName + "\r\n 70\r\n     0\r\n 71\r\n     1");
        } else {
            dxf.write("\r\n  2\r\n" + HatchName + "\r\n 70\r\n     1\r\n 71\r\n     1");
        }
        dxf.write("\r\n 91\r\n   " + (cnthole + 1) + "\r\n 92\r\n     1\r\n 93\r\n    " + cnt);
        dxf.write("\r\n 72\r\n    1");
        Coordinate ps = line.getCoordinateN(0);
        Coordinate pd = DxfExportPlugIn.transform2DpreserveZ(this.trans, ps);
        for (int i = 1; i < cnt; ++i) {
            dxf.write("\r\n 10\r\n" + pd.x + "\r\n 20\r\n" + pd.y);
            ps = line.getCoordinateN(i);
            pd = DxfExportPlugIn.transform2DpreserveZ(this.trans, ps);
            dxf.write("\r\n 11\r\n" + pd.x + "\r\n 21\r\n" + pd.y);
            dxf.write("\r\n 72\r\n    1");
        }
        dxf.write("\r\n 10\r\n" + pd.x + "\r\n 20\r\n" + pd.y);
        ps = line.getCoordinateN(cnt);
        this.trans.transform(ps, pd);
        dxf.write("\r\n 11\r\n" + pd.x + "\r\n 21\r\n" + pd.y);
        dxf.write("\r\n 97\r\n     1\r\n330\r\n" + Integer.toHexString(dxf_poly_id).toUpperCase());
        if (cnthole > 0) {
            for (int l = 0; l < cnthole; ++l) {
                LinearRing currLine = poly.getInteriorRingN(l);
                cnt = currLine.getNumPoints() - 1;
                dxf.write("\r\n 92\r\n    16\r\n 93\r\n    " + cnt);
                ps = currLine.getCoordinateN(0);
                this.trans.transform(ps, pd);
                for (int i = 1; i < cnt; ++i) {
                    dxf.write("\r\n 72\r\n    1");
                    dxf.write("\r\n 10\r\n" + pd.x + "\r\n 20\r\n" + pd.y);
                    ps = currLine.getCoordinateN(i);
                    this.trans.transform(ps, pd);
                    dxf.write("\r\n 11\r\n" + pd.x + "\r\n 21\r\n" + pd.y);
                }
                dxf.write("\r\n 72\r\n    1");
                dxf.write("\r\n 10\r\n" + pd.x + "\r\n 20\r\n" + pd.y);
                ps = currLine.getCoordinateN(cnt);
                this.trans.transform(ps, pd);
                dxf.write("\r\n 11\r\n" + pd.x + "\r\n 21\r\n" + pd.y);
                dxf.write("\r\n 97\r\n    1");
                dxf.write("\r\n330\r\n " + Integer.toHexString(dxf_hatch_id + l + 1).toUpperCase());
            }
        }
        dxf.write("\r\n 75\r\n    0\r\n 76\r\n    1");
        if (!HatchName.equals("SOLID")) {
            dxf.write("\r\n 52\r\n" + hatchtyp[hatchkey][0] + "0.0\r\n 41\r\n" + dFillWitdh + ".0\r\n 77\r\n  0\r\n 78\r\n  1");
            dxf.write("\r\n 53\r\n" + hatchtyp[hatchkey][1] + "\r\n 43\r\n0.0\r\n 44\r\n0.0");
            dxf.write("\r\n 45\r\n" + hatchtyp[hatchkey][2] * dFillWitdh + "\r\n 46\r\n" + hatchtyp[hatchkey][3] * dFillWitdh + "\r\n 79\r\n     0");
        }
        dxf.write("\r\n 98\r\n        1\r\n 10\r\n0.0\r\n 20\r\n0.0");
    }

    private void readVersionFromDraft(BufferedReader draft) {
        int lcnt = 0;
        boolean binHEADER = false;
        boolean binVERSION = false;
        try {
            String val;
            block24: do {
                ++lcnt;
                int code = Integer.parseInt(draft.readLine().trim());
                val = draft.readLine().trim();
                switch (code) {
                    case 0: {
                        if (!val.equals("ENDSEC")) break;
                        binHEADER = false;
                        binVERSION = false;
                        break;
                    }
                    case 2: {
                        if (!val.equals("HEADER")) break;
                        binHEADER = true;
                        break;
                    }
                    case 9: {
                        if (!val.equalsIgnoreCase("$ACADVER")) break;
                        binVERSION = true;
                        break;
                    }
                    case 1: {
                        if (!binHEADER || !binVERSION) continue block24;
                        switch (val) {
                            case "AC1015": {
                                this.DxfVersion = 2000;
                                break;
                            }
                            case "AC1018": {
                                this.DxfVersion = 2004;
                                break;
                            }
                            case "AC1021": {
                                this.DxfVersion = 2007;
                                break;
                            }
                            case "AC1024": {
                                this.DxfVersion = 2010;
                                break;
                            }
                            case "AC1027": {
                                this.DxfVersion = 2013;
                                break;
                            }
                            case "AC1032": {
                                this.DxfVersion = 2018;
                            }
                        }
                        return;
                    }
                }
            } while (val != null && !val.equalsIgnoreCase("EOF"));
        }
        catch (Exception e) {
            LOG.error(String.format("DraftFile Lesefehler (Zeile: %d): %s", lcnt * 2, e.getMessage()), (Throwable)e);
        }
    }

    private void dxfScanDef(BufferedReader dxfin) {
        int maxcnt = 0;
        int lcnt = 0;
        boolean binTable = false;
        boolean binStyleDef = false;
        boolean binTableStyle = false;
        boolean binBlock = false;
        boolean binBlocks = false;
        int idxfSyleCntori = 0;
        int idxfSyleCnt = 0;
        int idxfBlockCnt = 0;
        boolean binLTypeDef = false;
        boolean binTableLType = false;
        int idxfLTypeCnt = 0;
        this.mapBlock.clear();
        this.newBlockCnt = 0;
        this.mapTextSyle.clear();
        this.newTextStyleCnt = 0;
        this.mapLineType.clear();
        this.newLineTypeCnt = 0;
        try {
            String val;
            block8: do {
                ++lcnt;
                int code = Integer.parseInt(dxfin.readLine().trim());
                val = dxfin.readLine().trim();
                switch (code) {
                    case 0: {
                        if (val.equals("ENDSEC")) {
                            binTable = false;
                            binTableStyle = false;
                            binStyleDef = false;
                            binBlocks = false;
                            binBlock = false;
                            break;
                        }
                        if (val.equals("TABLE")) {
                            binTable = true;
                        }
                        if (val.equals("BLOCK")) {
                            binBlock = true;
                        }
                        if (val.equals("ENDBLK")) {
                            binBlock = false;
                        }
                        if (val.equals("STYLE")) {
                            binTableStyle = false;
                            binStyleDef = true;
                            ++idxfSyleCnt;
                        }
                        if (val.equals("LTYPE")) {
                            binTableLType = false;
                            binLTypeDef = true;
                            ++idxfLTypeCnt;
                        }
                        if (!val.equals("ENDTAB")) break;
                        binTable = false;
                        binStyleDef = false;
                        break;
                    }
                    case 2: {
                        if (binTable && val.equals("STYLE")) {
                            binTableStyle = true;
                        }
                        if (binStyleDef) {
                            this.mapTextSyle.put("d" + idxfSyleCnt, val.toUpperCase());
                        }
                        if (binLTypeDef) {
                            this.mapLineType.put("d" + idxfLTypeCnt, val.toUpperCase());
                            binLTypeDef = false;
                        }
                        if (val.equals("BLOCKS")) {
                            binBlocks = true;
                        }
                        if (!binBlock || val.toUpperCase().substring(0, 1).equals("*")) continue block8;
                        this.mapBlock.put("d" + idxfBlockCnt++, val.toUpperCase());
                        binBlock = false;
                        break;
                    }
                    case 5: {
                        int itmp = Integer.parseInt(val, 16);
                        if (itmp <= maxcnt) break;
                        maxcnt = itmp;
                        break;
                    }
                    case 70: {
                        if (!binTableStyle) break;
                        idxfSyleCntori = Integer.parseInt(val);
                    }
                }
            } while (val != null && !val.equalsIgnoreCase("EOF"));
            this.dxfTextStyleCnt = idxfSyleCnt;
            if (this.dxf_cnt < 3000000) {
                this.dxf_cnt = 3000000;
            }
        }
        catch (Exception e) {
            LOG.error(String.format("DraftFile Lesefehler (Zeile: %d): %s", lcnt * 2, e.getMessage()), (Throwable)e);
        }
    }

    private void dxfInsertDummyBlock(String BlockName, BufferedWriter dxfout) throws Exception {
        dxfout.write("  0\r\nBLOCK\r\n  5\r\n" + Integer.toHexString(this.dxf_cnt++).toUpperCase() + "\r\n330\r\n230BC\r\n100\r\nAcDbEntity\r\n  8\r\n0\r\n 62\r\n     5\r\n100\r\nAcDbBlockBegin");
        dxfout.write("\r\n  2\r\n" + BlockName + "\r\n 70\r\n     0\r\n 10\r\n0.0\r\n 20\r\n0.0\r\n 30\r\n0.0\r\n  3\r\n" + BlockName + "\r\n  1\r\n");
        dxfout.write("\r\n  0\r\nLWPOLYLINE\r\n  5\r\n" + Integer.toHexString(this.dxf_cnt++).toUpperCase() + "\r\n330\r\n230BC\r\n100\r\nAcDbEntity\r\n  8\r\n0\r\n 62\r\n     0\r\n100\r\nAcDbPolyline\r\n 90\r\n        4");
        dxfout.write("\r\n 70\r\n     1\r\n 43\r\n0.0\r\n 10\r\n-0.5\r\n 20\r\n0.5\r\n 10\r\n0.5\r\n 20\r\n0.5\r\n 10\r\n0.5\r\n 20\r\n-0.5\r\n 10\r\n-0.5\r\n 20\r\n-0.5");
        dxfout.write("\r\n  0\r\nLINE\r\n  5\r\n" + Integer.toHexString(this.dxf_cnt++).toUpperCase() + "\r\n330\r\n230BC\r\n100\r\nAcDbEntity\r\n  8\r\n0\r\n 62\r\n     0\r\n100\r\nAcDbLine\r\n 10\r\n-0.5\r\n 20\r\n-0.5\r\n 30\r\n0.0\r\n 11\r\n0.5\r\n 21\r\n0.5\r\n 31\r\n0.0");
        dxfout.write("\r\n  0\r\nLINE\r\n  5\r\n" + Integer.toHexString(this.dxf_cnt++).toUpperCase() + "\r\n330\r\n230BC\r\n100\r\nAcDbEntity\r\n  8\r\n0\r\n 62\r\n     0\r\n100\r\nAcDbLine\r\n 10\r\n-0.5\r\n 20\r\n0.5\r\n 30\r\n0.0\r\n 11\r\n0.5\r\n 21\r\n-0.5\r\n 31\r\n0.0");
        dxfout.write("\r\n  0\r\nENDBLK\r\n  5\r\n" + Integer.toHexString(this.dxf_cnt++).toUpperCase() + "\r\n330\r\n230BC\r\n100\r\nAcDbEntity\r\n  8\r\n0\r\n 62\r\n     5\r\n100\r\nAcDbBlockEnd\r\n");
    }

    private void dxfInsertLineType(int pos, BufferedWriter dxfout) throws Exception {
        int i;
        String LineName = this.mapLineType.get("N" + pos);
        Object LPattern = this.mapLineType.get("P" + pos);
        String LDef = LineName.length() > 47 ? LineName.substring(1, 47) : LineName;
        String[] ldef = ((String)LPattern).split("_", 13);
        dxfout.write("  0\r\nLTYPE\r\n  5\r\n" + Integer.toHexString(this.dxf_cnt++).toUpperCase() + "\r\n330\r\n  5\r\n100\r\nAcDbSymbolTableRecord\r\n100\r\nAcDbLinetypeTableRecord");
        if (ldef.length % 2 == 1) {
            LPattern = (String)LPattern + "_" + ldef[ldef.length - 1];
            ldef = ((String)LPattern).split("_", 13);
        }
        float LTyp_length = 0.0f;
        float[] iLdef = new float[ldef.length];
        for (i = 0; i < ldef.length; ++i) {
            try {
                iLdef[i] = Float.parseFloat(ldef[i]);
            }
            catch (NumberFormatException ne) {
                LOG.warn("Wrong linetype at dxf export: " + ldef[i], (Throwable)ne);
                iLdef[i] = 1.0f;
            }
            LTyp_length += iLdef[i];
        }
        dxfout.write("\r\n  2\r\n" + LineName + "\r\n 70\r\n     0\r\n  3\r\n" + LDef + "\r\n 72\r\n    65");
        dxfout.write("\r\n 73\r\n" + ldef.length + "\r\n 40\r\n" + LTyp_length);
        for (i = 0; i < ldef.length; i += 2) {
            dxfout.write("\r\n  49\r\n" + iLdef[i] + "\r\n 74\r\n     0");
            dxfout.write("\r\n  49\r\n-" + iLdef[i + 1] + "\r\n 74\r\n     0");
        }
        dxfout.write("\r\n");
    }

    private void dxfExpandDef(BufferedReader dxfin, BufferedReader dxftmp, BufferedWriter dxfout, DxfExportParameters expParams) throws Exception {
        int lcnt = 0;
        boolean binUnits = false;
        boolean binVPORT = false;
        boolean binTable = false;
        boolean binTableSyle = false;
        boolean binStyleDef = false;
        boolean binBlocks = false;
        boolean binBlockRec = false;
        int idxfStyleCnt = 0;
        boolean binLTypeDef = false;
        boolean binTableLType = false;
        int idxfLTypeCnt = 0;
        try {
            Object stmp;
            Object val;
            do {
                ++lcnt;
                String strcode = dxfin.readLine();
                int code = Integer.parseInt(strcode.trim());
                val = dxfin.readLine();
                switch (code) {
                    case 0: {
                        int i;
                        if (((String)val).equals("ENDSEC")) {
                            if (binBlocks) {
                                for (i = 0; i < this.newBlockCnt; ++i) {
                                    stmp = this.mapBlock.get(i);
                                    this.dxfInsertDummyBlock((String)stmp, dxfout);
                                }
                            }
                            binBlocks = false;
                        }
                        if (binTable && ((String)val).equals("VPORT")) {
                            do {
                                dxfout.write(strcode + "\r\n" + (String)val + "\r\n");
                                strcode = dxfin.readLine();
                                code = Integer.parseInt(strcode.trim());
                                val = dxfin.readLine();
                                switch (code) {
                                    case 12: {
                                        val = String.valueOf((expParams.getEnv().getMinX() + expParams.getEnv().getMaxX()) / 2.0);
                                        break;
                                    }
                                    case 22: {
                                        val = String.valueOf((expParams.getEnv().getMinY() + expParams.getEnv().getMaxY()) / 2.0);
                                        break;
                                    }
                                    case 40: {
                                        val = String.valueOf(expParams.getEnv().getMaxX() - expParams.getEnv().getMinX());
                                        break;
                                    }
                                    case 41: {
                                        val = String.valueOf((expParams.getEnv().getMaxX() - expParams.getEnv().getMinX()) / (expParams.getEnv().getMaxY() - expParams.getEnv().getMinY()));
                                    }
                                }
                            } while (val != null && !((String)val).equalsIgnoreCase("ENDTAB"));
                            break;
                        }
                        if (((String)val).equals("TABLE")) {
                            binTable = true;
                        }
                        if (((String)val).equals("STYLE")) {
                            binTableSyle = false;
                            binStyleDef = true;
                            ++idxfStyleCnt;
                        }
                        if (((String)val).equals("LTYPE")) {
                            binTableLType = false;
                            binLTypeDef = true;
                            ++idxfLTypeCnt;
                        }
                        if (!((String)val).equals("ENDTAB")) break;
                        if (binStyleDef) {
                            for (i = 0; i < this.newTextStyleCnt; ++i) {
                                stmp = this.mapTextSyle.get(i);
                                dxfout.write("  0\r\nSTYLE\r\n  5\r\n" + Integer.toHexString(this.dxf_cnt++).toUpperCase() + "\r\n330\r\n3\r\n100\r\nAcDbSymbolTableRecord\r\n100\r\nAcDbTextStyleTableRecord");
                                dxfout.write("\r\n  2\r\n" + (String)stmp + "\r\n 70\r\n    0\r\n 40\r\n3.3\r\n 41\r\n1.0\r\n 50\r\n0.0\r\n 71\r\n0\r\n 42\r\n1.0\r\n  3\r\nARIAL.TTF\r\n 4\r\n\r\n1001\r\nACAD\r\n1000\r\nArial\r\n1071\r\n34\r\n");
                            }
                            binTable = false;
                            binStyleDef = false;
                        }
                        if (binLTypeDef) {
                            for (i = 0; i < this.newLineTypeCnt; ++i) {
                                this.dxfInsertLineType(i, dxfout);
                            }
                            binTable = false;
                            binLTypeDef = false;
                        }
                        if (!binBlockRec) break;
                        for (i = 0; i < this.newBlockCnt; ++i) {
                            stmp = this.mapBlock.get(i);
                            dxfout.write("  0\r\nBLOCK_RECORD\r\n  5\r\n" + Integer.toHexString(this.dxf_cnt++).toUpperCase() + "\r\n330\r\n1\r\n100\r\nAcDbSymbolTableRecord\r\n100\r\nAcDbBlockTableRecord\r\n  2\r\n" + (String)stmp + "\r\n340\r\n0\r\n");
                        }
                        binTable = false;
                        binStyleDef = false;
                        break;
                    }
                    case 2: {
                        if (binTable && ((String)val).equals("STYLE")) {
                            binTableSyle = true;
                        }
                        if (((String)val).equals("BLOCKS")) {
                            binBlocks = true;
                        }
                        if (((String)val).equals("BLOCK_RECORD")) {
                            binBlockRec = true;
                        }
                        if (!((String)val).equals("ENTITIES")) break;
                        boolean ignore = true;
                        while (ignore) {
                            strcode = dxfin.readLine();
                            code = Integer.parseInt(strcode.trim());
                            val = dxfin.readLine().trim();
                            if (code != 0 || !((String)val).equals("ENDSEC")) continue;
                            ignore = false;
                        }
                        while (dxftmp.ready()) {
                            dxfout.write(dxftmp.read());
                        }
                        code = 0;
                        val = "ENDSEC";
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 9: {
                        if (((String)val).equals("$INSUNITS")) {
                            binUnits = true;
                        }
                        if (((String)val).equals("$EXTMIN")) {
                            dxfout.write(strcode + "\r\n" + (String)val + "\r\n");
                            strcode = dxfin.readLine();
                            val = dxfin.readLine().trim();
                            dxfout.write(strcode + "\r\n" + expParams.getEnv().getMinX() + "\r\n");
                            strcode = dxfin.readLine();
                            val = dxfin.readLine().trim();
                            val = String.valueOf(expParams.getEnv().getMinY());
                        }
                        if (!((String)val).equals("$EXTMAX")) break;
                        dxfout.write(strcode + "\r\n" + (String)val + "\r\n");
                        strcode = dxfin.readLine();
                        val = dxfin.readLine().trim();
                        dxfout.write(strcode + "\r\n" + expParams.getEnv().getMaxX() + "\r\n");
                        strcode = dxfin.readLine();
                        val = dxfin.readLine().trim();
                        val = String.valueOf(expParams.getEnv().getMaxY());
                        break;
                    }
                    case 70: {
                        if (binUnits) {
                            val = "   " + this.iAcadUnit;
                            binUnits = false;
                        }
                        if (!binTableSyle) break;
                        val = "" + (this.dxfTextStyleCnt + this.newTextStyleCnt);
                    }
                }
                dxfout.write(strcode + "\r\n" + (String)val + "\r\n");
            } while (val != null && !((String)val).equalsIgnoreCase("EOF"));
            stmp = val;
        }
        catch (Exception e) {
            throw new SystemException(String.format("DraftFile Lesefehler (Zeile: %d): %s", lcnt * 2, e.getMessage()), (Throwable)e);
        }
    }

    private static Coordinate transform2DpreserveZ(AffineTransformation trans2d, Coordinate coord) {
        Coordinate destCoord = new Coordinate();
        trans2d.transform(coord, destCoord);
        destCoord.setZ(coord.getZ());
        return destCoord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportDxf(DxfExportParameters expParam) throws Exception {
        String encoding;
        String javaEncoding;
        if (expParam.getExpFile() == null) {
            throw new Exception("DXF export file is not specified.");
        }
        if (expParam.getDraftFile() == null || !expParam.getDraftFile().exists()) {
            throw new Exception("DXF draft file is not specified.");
        }
        String UnitKey = expParam.getLymngr().getTask().getDrawingUnit().getKey();
        if (UnitKey.equalsIgnoreCase("meter")) {
            this.iAcadUnit = 6;
        } else if (UnitKey.equalsIgnoreCase("kilometer")) {
            this.iAcadUnit = 7;
        } else if (UnitKey.equalsIgnoreCase("cm")) {
            this.iAcadUnit = 5;
        } else if (UnitKey.equalsIgnoreCase("mm")) {
            this.iAcadUnit = 4;
        } else if (UnitKey.equalsIgnoreCase("yard")) {
            this.iAcadUnit = 10;
        } else if (UnitKey.equalsIgnoreCase("foot")) {
            this.iAcadUnit = 2;
        } else if (UnitKey.equalsIgnoreCase("inch")) {
            this.iAcadUnit = 1;
        }
        File tempFile = File.createTempFile("Entities_", ".dxftmp");
        tempFile.deleteOnExit();
        this.trans = new AffineTransformation();
        this.trans.setToIdentity();
        this.transrot = 0.0;
        if (expParam.getTransFile() != null && !expParam.getTransFile().toString().isEmpty()) {
            try (BufferedReader tr = new BufferedReader(new FileReader(expParam.getTransFile().toString()));){
                String strline;
                while ((strline = tr.readLine()) != null) {
                    String[] arrtr;
                    if (strline.trim().startsWith("#") || (arrtr = strline.split(";", 10)) == null || arrtr.length < 2) continue;
                    if (arrtr[0].trim().equalsIgnoreCase("translate") && arrtr.length == 3) {
                        this.trans.translate(Double.parseDouble(arrtr[1].trim()), Double.parseDouble(arrtr[2].trim()));
                        continue;
                    }
                    if (arrtr[0].trim().equalsIgnoreCase("rotate") && arrtr.length == 4) {
                        this.trans.rotate(Double.parseDouble(arrtr[1].trim()), Double.parseDouble(arrtr[2].trim()), Double.parseDouble(arrtr[3].trim()));
                        this.transrot = Math.toDegrees(Double.parseDouble(arrtr[1].trim()));
                        continue;
                    }
                    if (arrtr[0].trim().equalsIgnoreCase("txt_ori_set") && arrtr.length == 2) {
                        this.txt_ori_set = Math.toDegrees(Double.parseDouble(arrtr[1].trim()));
                        continue;
                    }
                    if (!arrtr[0].trim().equalsIgnoreCase("sym_ori_set") || arrtr.length != 2) continue;
                    this.sym_ori_set = Math.toDegrees(Double.parseDouble(arrtr[1].trim()));
                }
            }
        }
        this.DxfVersion = 0;
        try (BufferedReader dxfin = DxfExportPlugIn.getReader(expParam.getDraftFile(), Charset.defaultCharset());){
            this.readVersionFromDraft(dxfin);
        }
        if (this.DxfVersion == 0) {
            LOG.warn("Unsupported DXF draft version in file: " + expParam.getDraftFile().getAbsolutePath());
        }
        if (!Charset.isSupported(javaEncoding = (encoding = this.readEncoding(expParam.getDraftFile()).orElse(DEFAULT_CHARSET)).replace("ANSI_", "Cp"))) {
            LOG.error("DXF file {} encoding {} is not supported!", (Object)expParam.getDraftFile(), (Object)encoding);
            GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.getMessage("ui.plugin.dxf.DxfExportPlugIn.wrong-encoding", encoding), (String)I18N.get("common.error"));
            return;
        }
        Charset charsetFromCodePage = Charset.forName(javaEncoding);
        Charset charset = this.checkEncodingOrFallbackToUTF8(expParam.getDraftFile().toPath(), charsetFromCodePage);
        expParam.setCharset(charset);
        Map<String, Object> mapVisi = this.activateVisibilityProfile(expParam.getLymngr().getTask(), expParam.getVisibilityProfile());
        double screenScale = expParam.getLymngr().getTask().getScale();
        expParam.getLymngr().getTask().setScale(expParam.getScale());
        try {
            try (BufferedReader dxfin = DxfExportPlugIn.getReader(expParam.getDraftFile(), charset);){
                this.dxfScanDef(dxfin);
            }
            StringBuilder failedLayers = new StringBuilder();
            try (BufferedWriter dxftmpw = DxfExportPlugIn.getWriter(tempFile, charset);){
                dxftmpw.write("  2\r\nENTITIES");
                dxftmpw.flush();
                ++this.dxf_cnt;
                String strError = this.checkExportIsAllowed(expParam.getLymngr(), expParam.getEnv());
                if (strError != null) {
                    DrawingUnit du = WorkbenchContext.getTask().getDrawingUnit();
                    double unitInMeter = du.getUnitInMeter();
                    long maxArea = (long)((double)((long)this.maxAreaSquareKilometers * 1000L * 1000L) / unitInMeter / unitInMeter);
                    GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.getMessage("ui.plugin.dxf.DxfExportPlugIn.export-not-allowed", strError, this.maxFeaturesRiwaSrvDatastore, maxArea, du.getUnitAbbreviation() + "\u00b2"), (String)I18N.get("common.error"));
                    return;
                }
                HashSet<String> dxfLayerNames = new HashSet<String>();
                for (Layer ly : this.getLayers(expParam.getLymngr())) {
                    this.exportLayer(ly, dxftmpw, expParam, dxfLayerNames, failedLayers);
                }
                dxftmpw.write("\r\n");
            }
            ++this.dxf_cnt;
            try (BufferedReader dxftmpr = DxfExportPlugIn.getReader(tempFile, charset);
                 BufferedReader dxfin = DxfExportPlugIn.getReader(expParam.getDraftFile(), charset);
                 BufferedWriter dxfout = DxfExportPlugIn.getWriter(expParam.getExpFile(), charset);){
                this.dxfExpandDef(dxfin, dxftmpr, dxfout, expParam);
            }
            if (failedLayers.length() > 0) {
                exportedMessage = I18N.getMessage("ui.plugin.dxf.DxfExportPlugIn.exported-with-warnings", expParam.getExpFile()) + "\r\n" + I18N.get("ui.plugin.dxf.DxfExportPlugIn.layer-without-data") + "\r\n" + String.valueOf(failedLayers);
                if (WorkbenchContext.getFrame() != null) {
                    GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)exportedMessage, (String)I18N.get("common.message"));
                } else {
                    LOG.info((String)exportedMessage);
                }
            } else {
                exportedMessage = I18N.getMessage("ui.plugin.dxf.DxfExportPlugIn.export-succeeded", expParam.getExpFile());
                if (WorkbenchContext.getFrame() != null) {
                    GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)exportedMessage, (String)I18N.get("common.message"));
                } else {
                    LOG.info((String)exportedMessage);
                }
            }
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)WorkbenchContext.getFrame(), (Exception)e, DxfExportPlugIn.class);
        }
        finally {
            this.activateOriginalVisibility(expParam.getLymngr().getTask(), mapVisi);
            expParam.getLymngr().getTask().setScale(screenScale);
        }
    }

    private Optional<String> readEncoding(File draft) {
        Optional<String> optional;
        block8: {
            Stream<String> lines = Files.lines(draft.toPath(), StandardCharsets.ISO_8859_1);
            try {
                optional = lines.map(String::trim).dropWhile(line -> !"$DWGCODEPAGE".equalsIgnoreCase((String)line)).skip(2L).findFirst();
                if (lines == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | UncheckedIOException e) {
                    LOG.error("Could not determine file encoding. Using default one", (Throwable)e);
                    return Optional.empty();
                }
            }
            lines.close();
        }
        return optional;
    }

    private Charset checkEncodingOrFallbackToUTF8(Path draftFile, Charset charset) throws IOException {
        if (this.DxfVersion < 1021) {
            return charset;
        }
        if (FileEncodingDetector.fileIsUtf8BomEncoded(draftFile)) {
            return StandardCharsets.UTF_8;
        }
        if (FileEncodingDetector.doesEncodingMatchFileContent(draftFile, StandardCharsets.UTF_8)) {
            return StandardCharsets.UTF_8;
        }
        return charset;
    }

    private boolean exportLayer(Layer ly, BufferedWriter dxftmpw, DxfExportParameters expParam, Set<String> dxfLayerNames, StringBuilder failedLayers) {
        Category ca;
        String layerName = ly.getName().trim();
        if (!ly.isExportable()) {
            LOG.debug("layer '{}' not exportable.", (Object)layerName);
            return false;
        }
        Matcher ACAD_m = ACAD_PATTERN.matcher(layerName);
        for (ca = ly.getCategory(); ca != null && ca.getParentCategory().getParentCategory() != null; ca = ca.getParentCategory()) {
        }
        String BasicCatName = ca.getName();
        String lyName = DxfExportPlugIn.retrieveUniqueDxfLayerName(dxfLayerNames, BasicCatName + "." + ACAD_m.replaceAll("_"));
        dxfLayerNames.add(lyName);
        LOG.debug(lyName);
        try (FeatureIterator<SimpleFeature> fi = ly.getFeatureIterator(expParam.getEnv());){
            while (fi.hasNext()) {
                SimpleFeature f = (SimpleFeature)fi.next();
                ExportStyle expStyleNew = ExportStyleFactory.createExportStyle(ly, f, expParam.getScale());
                if (expStyleNew == null || !expStyleNew.isEnabled()) continue;
                Object strEntityLyName = lyName;
                if (expParam.isExpThemes() && expStyleNew.getThemeLabel() != null && expStyleNew.getThemeLabel().trim().length() > 0) {
                    strEntityLyName = (String)strEntityLyName + "." + expStyleNew.getThemeLabel();
                }
                Matcher ACAD_ms = ACAD_PATTERN.matcher((CharSequence)strEntityLyName);
                strEntityLyName = ACAD_ms.replaceAll("_");
                DxfFeatureParameters featureParams = new DxfFeatureParameters();
                featureParams.setExportStyle(expStyleNew);
                featureParams.setFeature(f);
                featureParams.setLayerName((String)strEntityLyName);
                if (f.getDefaultGeometry() == null || ((Geometry)f.getDefaultGeometry()).isEmpty()) continue;
                this.dxfEntity(dxftmpw, expParam, featureParams, null);
            }
        }
        catch (Exception e) {
            failedLayers.append(BasicCatName).append("-").append(layerName).append("\n");
            LOG.error("Could not export layer '" + layerName + "' to DXF ", (Throwable)e);
            return true;
        }
        return false;
    }

    protected static String retrieveUniqueDxfLayerName(Set<String> dxfLayerNames, String newDxfLayer) {
        if (newDxfLayer == null) {
            newDxfLayer = "";
        }
        if (dxfLayerNames.contains(newDxfLayer)) {
            String[] nameParts = newDxfLayer.split("\\_");
            if (nameParts.length > 1) {
                String lastPart = nameParts[nameParts.length - 1];
                try {
                    int numLastPart = Integer.parseInt(lastPart) + 1;
                    Object newKey = "";
                    for (int i = 0; i < nameParts.length - 1; ++i) {
                        newKey = ((String)newKey).isEmpty() ? (String)newKey + nameParts[i] : (String)newKey + "_" + nameParts[i];
                    }
                    newDxfLayer = DxfExportPlugIn.retrieveUniqueDxfLayerName(dxfLayerNames, (String)newKey + "_" + numLastPart);
                }
                catch (NumberFormatException nfe) {
                    newDxfLayer = DxfExportPlugIn.retrieveUniqueDxfLayerName(dxfLayerNames, newDxfLayer + "_1");
                }
            } else {
                newDxfLayer = DxfExportPlugIn.retrieveUniqueDxfLayerName(dxfLayerNames, newDxfLayer + "_1");
            }
        }
        return newDxfLayer;
    }

    private void dxfEntity(BufferedWriter dxfout, DxfExportParameters expParams, DxfFeatureParameters featureParams, DxfGeometryParameters geomParams) throws Exception {
        if (geomParams == null) {
            geomParams = featureParams.produceGeometryParams();
        }
        if (geomParams.getGeom() instanceof GeometryCollection) {
            int intCountGeom = geomParams.getGeom().getNumGeometries();
            for (int i = 0; i < intCountGeom; ++i) {
                DxfGeometryParameters geomParamsInternal = new DxfGeometryParameters();
                geomParamsInternal.setGeom(geomParams.getGeom().getGeometryN(i));
                this.dxfEntity(dxfout, expParams, featureParams, geomParamsInternal);
            }
        } else {
            boolean bContains = expParams.getEnv().contains(geomParams.getGeom().getEnvelopeInternal());
            Geometry clipGeom = expParams.produceClipGeometry();
            if (bContains || geomParams.getGeom().intersects(clipGeom)) {
                if (expParams.isClip() && !geomParams.isClipped() && !bContains) {
                    DxfGeometryParameters clippedGeometryParams = new DxfGeometryParameters();
                    Geometry clippedGeom = clipGeom;
                    try {
                        clippedGeom = geomParams.getGeom().intersection(clipGeom);
                    }
                    catch (TopologyException te) {
                        LOG.warn("Error at clipping. Maybe because of invalid geometries in the export data", (Throwable)te);
                    }
                    clippedGeometryParams.setGeom(clippedGeom);
                    clippedGeometryParams.setClipped(true);
                    if (clippedGeometryParams.getGeom() instanceof GeometryCollection) {
                        int intCountGeom = clippedGeometryParams.getGeom().getNumGeometries();
                        for (int i = 0; i < intCountGeom; ++i) {
                            Geometry geomInternal = clippedGeometryParams.getGeom().getGeometryN(i);
                            DxfGeometryParameters geomParamsInternal = new DxfGeometryParameters();
                            geomParamsInternal.setGeom(geomInternal);
                            geomParamsInternal.setClipped(true);
                            this.dxfEntity(dxfout, expParams, featureParams, geomParamsInternal);
                        }
                        return;
                    }
                    geomParams = clippedGeometryParams;
                }
                if (geomParams.getGeom() instanceof Point) {
                    geomParams.setExportStyleGeometryType(0);
                    if (featureParams.getExportStyle().isRenderingSymbol()) {
                        this.dxfSymbol(dxfout, expParams, featureParams, geomParams);
                    }
                    if (featureParams.getExportStyle().isRenderingText()) {
                        this.dxfText(dxfout, expParams, featureParams, geomParams);
                    }
                } else if (geomParams.getGeom() instanceof LineString) {
                    geomParams.setExportStyleGeometryType(1);
                    this.dxfLine(dxfout, expParams, featureParams, geomParams);
                    if (featureParams.getExportStyle().isRenderingText4Geom(1)) {
                        this.dxfText(dxfout, expParams, featureParams, geomParams);
                    }
                } else if (geomParams.getGeom() instanceof Polygon) {
                    this.dxfPolygon(dxfout, expParams, featureParams, geomParams);
                    if (featureParams.getExportStyle().isRenderingText4Geom(4)) {
                        this.dxfText(dxfout, expParams, featureParams, geomParams);
                    }
                } else {
                    Assert.shouldNeverReachHere((String)("Geometry class is " + geomParams.getGeom().getClass().getName()));
                }
            }
        }
    }

    private Iterable<Layer> getLayers(LayerManager lyMngr) {
        Iterator<Layer> iLy = lyMngr.reverseIterator(Layer.class, false);
        ArrayList<Layer> lstLy = new ArrayList<Layer>();
        Iterator<Layer> it = iLy;
        while (it.hasNext()) {
            Layer ly = it.next();
            if (!ly.isVisibleOnScreen() || ly instanceof DimLayer) continue;
            lstLy.add(ly);
        }
        return lstLy;
    }

    private String checkExportIsAllowed(LayerManager lyMngr, Envelope env) throws Exception {
        Object strLayNames = null;
        for (Layer ly : this.getLayers(lyMngr)) {
            if (this.checkLayerIsAllowed4Export(ly, env)) continue;
            if (strLayNames == null) {
                strLayNames = ly.getName();
                continue;
            }
            strLayNames = (String)strLayNames + ", " + ly.getName();
        }
        return strLayNames;
    }

    private boolean checkLayerIsAllowed4Export(Layer ly, Envelope env) throws Exception {
        try {
            if (ly instanceof RedlineLayer) {
                return true;
            }
            DMDCollection dmdCol = ly.getLayerManager().getTask().getDataStores();
            DataStore ds = ly.getFMD().getDataStore(dmdCol);
            if (ds instanceof RiwaSrvDataStore) {
                Query query = ly.getFMD().getQuery((Filter)Filter.INCLUDE);
                int count = ((RiwaSrvDataStore)ds).getFeatureCount(query);
                if (count != -1 && count < this.maxFeaturesRiwaSrvDatastore) {
                    return true;
                }
                double unitInMeter = WorkbenchContext.getTask().getDrawingUnit().getUnitInMeter();
                return env.getArea() < (double)((long)this.maxAreaSquareKilometers * 1000L) / unitInMeter * 1000.0 / unitInMeter;
            }
            return true;
        }
        catch (Exception e) {
            LOG.error("Error checking if layer " + ly.getName() + " is allowed for export.", (Throwable)e);
            throw e;
        }
    }

    private static BufferedReader getReader(File f, Charset charset) throws FileNotFoundException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), charset));
    }

    private static BufferedWriter getWriter(File f, Charset charset) throws FileNotFoundException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), charset));
    }

    private final Map<String, Object> activateVisibilityProfile(Task task, String strProfileName) {
        if (strProfileName == null) {
            return null;
        }
        task.getLayerManager().setFiringEvents(false);
        Map<String, Object> currentVisi = VisibilityProfile.createProfile(task.getLayerManager());
        VisibilityPanel.instanceOf().activateProfile(strProfileName, task.getLayerManager());
        return currentVisi;
    }

    private final void activateOriginalVisibility(Task task, Map<String, Object> previousVisi) {
        try {
            if (previousVisi == null) {
                return;
            }
            VisibilityProfile.activateProfile(task.getLayerManager(), previousVisi);
        }
        finally {
            task.getLayerManager().setFiringEvents(true);
            task.getLayerManager().getRootCatBuildIn().fireCategoryChanged(CategoryEventType.METADATA_CHANGED);
            task.getLayerManager().getRootCatLocal().fireCategoryChanged(CategoryEventType.METADATA_CHANGED);
            if (WorkbenchContext.getInstance() != null) {
                WorkbenchContext.getInstance().getLayerViewPanel().repaint();
            }
        }
    }

    static {
        nf.setGroupingUsed(false);
    }
}

