/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.dxf;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.QuasimodeTool;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.dxf.ChooseDxfDraftDialog;
import com.vividsolutions.jump.workbench.ui.plugin.dxf.DxfExportParameters;
import com.vividsolutions.jump.workbench.ui.plugin.dxf.DxfExportPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.dxf.SetRegionTool;
import com.vividsolutions.jump.workbench.ui.visibility.VisibilityPanel;
import de.riwagis.riwajump.workbench.renderer.GenericOverlayFeature;
import de.riwagis.riwajump.workbench.renderer.GenericOverlayPlugin;
import de.riwagis.unit.DrawingUnit;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.components.WaitDialog;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang3.ObjectUtils;
import org.jdesktop.swingx.JXTaskPane;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DxfExportDialog
extends JDialog {
    private static final Logger LOG = LoggerFactory.getLogger(DxfExportDialog.class);
    private static final String EXP_FILE_KEY = String.format("%s - EXPFILE", DxfExportDialog.class);
    private static final String TRANS_FILE_KEY = String.format("%s - TRANSFILE", DxfExportDialog.class);
    private static final String SCALE_KEY = String.format("%s - SCALE", DxfExportDialog.class);
    private static final String VISIBILITY_KEY = String.format("%s - VISIBILITY", DxfExportDialog.class);
    private static final String CLIPPING_KEY = String.format("%s - CLIPPING", DxfExportDialog.class);
    private static final String EXPORT_LINE_WIDTH_KEY = String.format("%s - LINE_WIDTH", DxfExportDialog.class);
    private static final String EXPORT_THEMES_KEY = String.format("%s - EXPORT_THEMES", DxfExportDialog.class);
    private static final String DXF_PREVIEW = "PREVIEW_DXF";
    private static final GeometryFactory gfac = new GeometryFactory();
    private final NumberFormat df = new DecimalFormat();
    private final NumberFormat nf = NumberFormat.getIntegerInstance();
    private final PlugInContext context;
    private final DxfExportPlugIn dxfPlugIn;
    private File transFile = null;
    private Envelope envRegion = null;
    private File draftFile = null;
    private double scale = 1000.0;
    private boolean bolInScaleEvent = false;
    private final SetRegionTool regionTool = new SetRegionTool(this);
    private boolean bolDoExport = false;
    private CursorTool oldCursorTool = null;
    private JButton butCancel;
    private JButton butChooseDraft;
    private JButton butChooseRegion;
    private JButton butChooseTrans;
    private JButton butExport;
    private JCheckBox cboClipping;
    private JCheckBox cboExportLineWidth;
    private JCheckBox cboExportThemaLayers;
    private JComboBox<String> cmbScale;
    private JComboBox<String> cmbVisibility;
    private JPanel jPanel1;
    private JLabel lblArea;
    private JLabel lblDraft;
    private JLabel lblDraftName;
    private JLabel lblRegion;
    private JLabel lblScale;
    private JLabel lblTrans;
    private JLabel lblVisibility;
    private JXTaskPane optionsPane;
    private JTextField txtTrans;

    public DxfExportDialog(JFrame _owner, DxfExportPlugIn dxfPlugIn, PlugInContext _context) {
        super((Frame)_owner, false);
        this.context = _context;
        this.dxfPlugIn = dxfPlugIn;
        this.initComponents();
        this.i18n();
        this.init();
        this.checkEnabledState();
        this.pack();
        this.setLocation(_owner.getX() + 30, _owner.getY() + 180);
        this.setResizable(true);
    }

    private void i18n() {
        this.setTitle(I18N.get("ui.plugin.dxf.DxfExportDialog.title"));
        this.lblScale.setText(I18N.get("ui.plugin.dxf.DxfExportDialog.scale"));
        this.lblDraft.setText(I18N.get("ui.plugin.dxf.DxfExportDialog.draft"));
        this.lblDraft.setToolTipText(I18N.get("ui.plugin.dxf.DxfExportDialog.choose-draft-tooltip"));
        this.lblDraftName.setToolTipText(I18N.get("ui.plugin.dxf.DxfExportDialog.choose-draft-tooltip"));
        this.lblTrans.setText(I18N.get("ui.plugin.dxf.DxfExportDialog.trans"));
        this.butCancel.setText(I18N.get("common.cancel"));
        this.butChooseRegion.setText(I18N.get("ui.plugin.dxf.DxfExportDialog.choose"));
        this.butChooseDraft.setText(I18N.get("ui.plugin.dxf.DxfExportDialog.choose"));
        this.butChooseTrans.setText(I18N.get("ui.plugin.dxf.DxfExportDialog.choose"));
        this.butExport.setText(I18N.get("ui.plugin.dxf.DxfExportDialog.export"));
        this.lblRegion.setText(I18N.get("ui.plugin.dxf.DxfExportDialog.export-region"));
        this.lblArea.setText(I18N.get("ui.plugin.dxf.DxfExportDialog.area") + ": ---");
        this.lblVisibility.setText(I18N.get("ui.plugin.dxf.DxfExportDialog.visibility"));
        this.lblVisibility.setToolTipText(I18N.get("ui.plugin.dxf.DxfExportDialog.visibility-tooltip"));
        this.cboClipping.setText(I18N.get("ui.plugin.dxf.DxfExportDialog.clip-to-envelope"));
        this.cboExportThemaLayers.setText(I18N.get("ui.plugin.dxf.DxfExportDialog.export-themes"));
        this.cboExportLineWidth.setText(I18N.get("ui.plugin.dxf.DxfExportDialog.export-line-width"));
    }

    private void init() {
        this.df.setMaximumFractionDigits(2);
        this.df.setGroupingUsed(false);
        this.nf.setGroupingUsed(false);
        this.cmbScale.setSelectedIndex(2);
        this.optionsPane.setForeground(Color.black);
        this.optionsPane.setOpaque(false);
        ((JComponent)this.optionsPane.getContentPane()).setOpaque(false);
        List<String> lstProfileNames = VisibilityPanel.instanceOf().getProfileNames();
        this.cmbVisibility.addItem(I18N.get("ui.plugin.dxf.DxfExportDialog.visibility-no-profile"));
        for (String strProfile : lstProfileNames) {
            this.cmbVisibility.addItem(strProfile);
        }
        this.cmbVisibility.setSelectedIndex(0);
        String objTransFile = PersistentBlackboardPlugIn.get().get(TRANS_FILE_KEY, null);
        if (objTransFile != null) {
            this.transFile = new File(objTransFile.toString());
            if (!this.transFile.exists()) {
                this.transFile = null;
            } else {
                this.txtTrans.setText(ObjectUtils.toString((Object)this.transFile));
            }
        }
        this.scale = PersistentBlackboardPlugIn.get().get(SCALE_KEY, 1000.0);
        this.cmbScale.setSelectedItem("1 : " + this.nf.format(this.scale));
        String strVisibility = PersistentBlackboardPlugIn.get().get(VISIBILITY_KEY, "");
        if (strVisibility != null && strVisibility.length() > 0 && lstProfileNames.contains(strVisibility)) {
            this.cmbVisibility.setSelectedItem(strVisibility);
        }
        this.cboClipping.setSelected(PersistentBlackboardPlugIn.get().get(CLIPPING_KEY, false));
        this.cboExportThemaLayers.setSelected(PersistentBlackboardPlugIn.get().get(EXPORT_THEMES_KEY, true));
        this.cboExportLineWidth.setSelected(PersistentBlackboardPlugIn.get().get(EXPORT_LINE_WIDTH_KEY, false));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (DxfExportDialog.this.draftFile == null) {
                    File drFile = ChooseDxfDraftDialog.getLastDraft();
                    String drFileName = ChooseDxfDraftDialog.getLastDraftName();
                    if (drFile == null) {
                        DxfExportDialog.this.butChooseDraft_onActionPerformed(null);
                    } else {
                        DxfExportDialog.this.setDraftFile(drFile, drFileName);
                        DxfExportDialog.this.checkEnabledState();
                    }
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DxfExportDialog.this.cleanUp();
                DxfExportDialog.this.bolDoExport = false;
            }
        });
    }

    private void cleanUp() {
        this.removePreview();
        if (this.oldCursorTool != null) {
            this.context.getLayerViewPanel().setCurrentCursorTool(this.oldCursorTool);
            this.oldCursorTool = null;
        }
    }

    private void checkEnabledState() {
        if (this.envRegion != null && this.draftFile != null && this.draftFile.exists() && (this.transFile == null || this.transFile.exists())) {
            this.butExport.setEnabled(true);
        } else {
            this.butExport.setEnabled(false);
        }
    }

    void setEnvelope2VisibleRectangle() {
        Envelope env = this.context.getLayerViewPanel().getViewport().getEnvelopeInModelCoordinates();
        Envelope dxfEnv = new Envelope(env);
        dxfEnv.expandBy(env.getWidth() / -10.0);
        this.setEnvelope(dxfEnv);
        env.expandBy(env.getWidth() / 10.0);
    }

    void setEnvelope(Envelope env) {
        DrawingUnit unit = WorkbenchContext.getTask().getDrawingUnit();
        this.envRegion = env;
        CoordinateList lstCoord = new CoordinateList();
        lstCoord.add(new Coordinate(env.getMinX(), env.getMinY()));
        lstCoord.add(new Coordinate(env.getMaxX(), env.getMinY()));
        lstCoord.add(new Coordinate(env.getMaxX(), env.getMaxY()));
        lstCoord.add(new Coordinate(env.getMinX(), env.getMaxY()));
        lstCoord.add(new Coordinate(env.getMinX(), env.getMinY()));
        CoordinateSequence seqCoord = gfac.getCoordinateSequenceFactory().create(lstCoord.toCoordinateArray());
        LineString line = new LineString(seqCoord, gfac);
        GenericOverlayFeature fPreview = new GenericOverlayFeature((Geometry)new GeometryCollection(new Geometry[]{line}, gfac), (Stroke)new BasicStroke(2.0f), Color.RED, (Stroke)new BasicStroke(), new Color(0, 0, 0, 0));
        GenericOverlayPlugin.addFeature(DXF_PREVIEW, fPreview);
        this.context.getLayerViewPanel().copyTo();
        this.lblArea.setText(I18N.get("ui.plugin.dxf.DxfExportDialog.area") + ": " + this.nf.format(env.getArea()) + unit.getUnitAbbreviation() + "\u00b2");
        this.checkEnabledState();
    }

    private void removePreview() {
        GenericOverlayPlugin.removeFeature(DXF_PREVIEW);
        this.context.getLayerViewPanel().copyTo();
    }

    public boolean wasExportPressed() {
        return this.bolDoExport;
    }

    public Envelope getExportEnv() {
        return this.envRegion;
    }

    public File getDraftFile() {
        return this.draftFile;
    }

    public File getTransFile() {
        return this.transFile;
    }

    public double getExportScale() {
        return this.scale;
    }

    private void setDraftFile(File drFile, String strDraftName) {
        if (drFile == null || !drFile.exists()) {
            this.draftFile = null;
            this.lblDraftName.setText(I18N.get("ui.plugin.dxf.DxfExportDialog.choose-draft"));
            return;
        }
        this.draftFile = drFile;
        this.lblDraftName.setText(strDraftName);
    }

    private void initComponents() {
        this.lblRegion = new JLabel();
        this.lblArea = new JLabel();
        this.butChooseRegion = new JButton();
        this.lblDraft = new JLabel();
        this.lblDraftName = new JLabel();
        this.butChooseDraft = new JButton();
        this.lblScale = new JLabel();
        this.cmbScale = new JComboBox();
        this.lblVisibility = new JLabel();
        this.cmbVisibility = new JComboBox();
        this.optionsPane = new JXTaskPane();
        this.cboClipping = new JCheckBox();
        this.lblTrans = new JLabel();
        this.txtTrans = new JTextField();
        this.butChooseTrans = new JButton();
        this.cboExportThemaLayers = new JCheckBox();
        this.cboExportLineWidth = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.butExport = new JButton();
        this.butCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.lblRegion.setHorizontalAlignment(11);
        this.lblRegion.setText("Exportbereich:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.lblRegion, gridBagConstraints);
        this.lblArea.setText("Fl\u00e4che: ");
        this.lblArea.setBorder(BorderFactory.createBevelBorder(1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.lblArea, gridBagConstraints);
        this.butChooseRegion.setText("w\u00e4hlen...");
        this.butChooseRegion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DxfExportDialog.this.butChooseRegion_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.butChooseRegion, gridBagConstraints);
        this.lblDraft.setHorizontalAlignment(11);
        this.lblDraft.setText("Vorlage:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.lblDraft, gridBagConstraints);
        this.lblDraftName.setText("Standard (DXF 2004)");
        this.lblDraftName.setBorder(BorderFactory.createBevelBorder(1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.lblDraftName, gridBagConstraints);
        this.butChooseDraft.setText("w\u00e4hlen...");
        this.butChooseDraft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DxfExportDialog.this.butChooseDraft_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.butChooseDraft, gridBagConstraints);
        this.lblScale.setHorizontalAlignment(11);
        this.lblScale.setText("Ma\u00dfstab:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.lblScale, gridBagConstraints);
        this.cmbScale.setEditable(true);
        this.cmbScale.setModel(new DefaultComboBoxModel<String>(new String[]{"1 : 50", "1 : 250", "1 : 500", "1 : 1000", "1 : 2500", "1 : 5000", "1 : 7500", "1 : 10000", "1 : 25000", "1 : 50000", "1 : 100000", "1 : 500000", "1 : 1000000"}));
        this.cmbScale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DxfExportDialog.this.cmbScale_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add(this.cmbScale, gridBagConstraints);
        this.lblVisibility.setHorizontalAlignment(11);
        this.lblVisibility.setText("Sichtbarkeitsprofil:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.lblVisibility, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add(this.cmbVisibility, gridBagConstraints);
        this.optionsPane.setAnimated(false);
        this.optionsPane.setCollapsed(true);
        this.optionsPane.setTitle("Erweiterte Einstellungen");
        this.optionsPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DxfExportDialog.this.optionsPane_onPropertyChange(evt);
            }
        });
        this.optionsPane.setLayout((LayoutManager)new GridBagLayout());
        this.cboClipping.setText("Grafikelemente auf Bereich zuschneiden");
        this.cboClipping.setName("bClipState");
        this.cboClipping.setOpaque(false);
        this.cboClipping.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DxfExportDialog.this.cboClippingActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.optionsPane.add((Component)this.cboClipping, (Object)gridBagConstraints);
        this.cboClipping.getAccessibleContext().setAccessibleName("null");
        this.lblTrans.setText("<html>Tranformation<br>(Optional):</html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.optionsPane.add((Component)this.lblTrans, (Object)gridBagConstraints);
        this.txtTrans.setPreferredSize(new Dimension(150, 20));
        this.txtTrans.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DxfExportDialog.this.txtTrans_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.optionsPane.add((Component)this.txtTrans, (Object)gridBagConstraints);
        this.butChooseTrans.setText("w\u00e4hlen...");
        this.butChooseTrans.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DxfExportDialog.this.butChooseTrans_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.optionsPane.add((Component)this.butChooseTrans, (Object)gridBagConstraints);
        this.cboExportThemaLayers.setSelected(true);
        this.cboExportThemaLayers.setText("Themen als DXF Ebenen ausgeben");
        this.cboExportThemaLayers.setOpaque(false);
        this.cboExportThemaLayers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DxfExportDialog.this.cboExportThemaLayersActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.optionsPane.add((Component)this.cboExportThemaLayers, (Object)gridBagConstraints);
        this.cboExportLineWidth.setText("Linienbreiten exportieren");
        this.cboExportLineWidth.setOpaque(false);
        this.cboExportLineWidth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DxfExportDialog.this.cboExportLineWidthActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.optionsPane.add((Component)this.cboExportLineWidth, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.optionsPane, gridBagConstraints);
        this.butExport.setText("exportieren");
        this.butExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DxfExportDialog.this.butExport_onActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.butExport);
        this.butCancel.setText("abbrechen");
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DxfExportDialog.this.butCancel_onActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.butCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void butChooseDraft_onActionPerformed(ActionEvent evt) {
        try {
            ChooseDxfDraftDialog draftChooser = new ChooseDxfDraftDialog(this);
            GUISupport.centreOnScreen((Component)draftChooser);
            draftChooser.setVisible(true);
            this.setDraftFile(draftChooser.getDraft(), draftChooser.getDraftName());
            draftChooser.dispose();
        }
        finally {
            this.checkEnabledState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cmbScale_onActionPerformed(ActionEvent evt) {
        if (this.bolInScaleEvent) {
            return;
        }
        this.bolInScaleEvent = true;
        try {
            String strScale = (String)this.cmbScale.getSelectedItem();
            String[] arrScale = strScale.split("\\:");
            if (arrScale.length > 2) {
                this.scale = 1000.0;
            }
            if (arrScale.length == 2) {
                strScale = arrScale[1];
            }
            if (arrScale.length == 1) {
                strScale = arrScale[0];
            }
            try {
                this.scale = this.df.parse(strScale.trim()).doubleValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.cmbScale.setSelectedItem("1 : " + this.nf.format(this.scale));
        }
        finally {
            this.bolInScaleEvent = false;
            this.checkEnabledState();
        }
    }

    private void butExport_onActionPerformed(ActionEvent evt) {
        String strVisibilityProfile;
        boolean bolYes;
        File tmpFile = null;
        String objExpFile = PersistentBlackboardPlugIn.get().get(EXP_FILE_KEY, null);
        if (objExpFile != null && !(tmpFile = new File(objExpFile.toString())).getParentFile().exists()) {
            tmpFile = null;
        }
        if ((tmpFile = GUISupport.saveFile((Component)this, null, (String)"dxf", (File)tmpFile, (boolean)false)) == null) {
            return;
        }
        if (tmpFile.exists() && !(bolYes = GUISupport.yesnobox((Component)this, (String)I18N.get("ui.plugin.dxf.DxfExportDialog.overwrite-file"), (String)I18N.get("common.alert")))) {
            return;
        }
        final File expFile = tmpFile;
        this.cleanUp();
        this.dispose();
        this.bolDoExport = true;
        if (expFile != null) {
            PersistentBlackboardPlugIn.get().put(EXP_FILE_KEY, expFile.toString());
        } else {
            PersistentBlackboardPlugIn.get().remove(EXP_FILE_KEY);
        }
        if (this.transFile != null) {
            PersistentBlackboardPlugIn.get().put(TRANS_FILE_KEY, this.transFile.toString());
        } else {
            PersistentBlackboardPlugIn.get().remove(TRANS_FILE_KEY);
        }
        PersistentBlackboardPlugIn.get().put(SCALE_KEY, this.scale);
        if (this.cmbVisibility.getSelectedIndex() > 0) {
            strVisibilityProfile = this.cmbVisibility.getSelectedItem().toString();
            PersistentBlackboardPlugIn.get().put(VISIBILITY_KEY, strVisibilityProfile);
        } else {
            strVisibilityProfile = null;
            PersistentBlackboardPlugIn.get().remove(VISIBILITY_KEY);
        }
        PersistentBlackboardPlugIn.get().put(CLIPPING_KEY, this.cboClipping.isSelected());
        PersistentBlackboardPlugIn.get().put(EXPORT_THEMES_KEY, this.cboExportThemaLayers.isSelected());
        PersistentBlackboardPlugIn.get().put(EXPORT_LINE_WIDTH_KEY, this.cboExportLineWidth.isSelected());
        final WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)this.context.getWorkbenchFrame(), (String)I18N.get("ui.plugin.dxf.DxfExportDialog.please-wait"), (Runnable)new Runnable(this){

            @Override
            public void run() {
            }
        });
        Runnable runDxf = new Runnable(){

            @Override
            public void run() {
                try {
                    DxfExportParameters expParam = new DxfExportParameters();
                    expParam.setExpFile(expFile);
                    expParam.setEnv(DxfExportDialog.this.envRegion);
                    expParam.setScale(DxfExportDialog.this.scale);
                    expParam.setLymngr(DxfExportDialog.this.context.getLayerManager());
                    expParam.setVisibilityProfile(strVisibilityProfile);
                    expParam.setDraftFile(DxfExportDialog.this.draftFile);
                    expParam.setTransFile(DxfExportDialog.this.transFile);
                    expParam.setClip(DxfExportDialog.this.cboClipping.isSelected());
                    expParam.setExpThemes(DxfExportDialog.this.cboExportThemaLayers.isSelected());
                    expParam.setExpLineWidth(DxfExportDialog.this.cboExportLineWidth.isSelected());
                    DxfExportDialog.this.dxfPlugIn.exportDxf(expParam);
                }
                catch (Exception e) {
                    dlgWait.setError(e);
                }
            }
        };
        dlgWait.addWorkToDo(runDxf);
        dlgWait.setVisible(true);
        if (dlgWait.getError() != null) {
            ExceptionDialog.handleGuiException((Component)this.context.getWorkbenchFrame(), (Throwable)dlgWait.getError(), (String)"webgiscli");
        }
    }

    private void butCancel_onActionPerformed(ActionEvent evt) {
        this.bolDoExport = false;
        this.cleanUp();
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void butChooseRegion_onActionPerformed(ActionEvent evt) {
        try {
            CursorTool tempCursor = this.context.getLayerViewPanel().getCurrentCursorTool();
            if (this.oldCursorTool == null) {
                this.oldCursorTool = tempCursor;
            }
            QuasimodeTool quasimodeTool = QuasimodeTool.addStandardQuasimodes(this.regionTool);
            this.context.getLayerViewPanel().setCurrentCursorTool(quasimodeTool);
            this.setVisible(false);
        }
        finally {
            this.checkEnabledState();
        }
    }

    private void txtTrans_onKeyReleased(KeyEvent evt) {
        String strTransFile = this.txtTrans.getText();
        if (strTransFile.trim().length() == 0) {
            this.transFile = null;
            this.checkEnabledState();
            return;
        }
        this.transFile = new File(strTransFile);
        this.checkEnabledState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void butChooseTrans_onActionPerformed(ActionEvent evt) {
        try {
            String[] strSuffix = new String[]{"trans"};
            FileFilter fFilt = GUISupport.createFileFilter((String)"Transfom-File", (String[])strSuffix);
            JFileChooser fChoose = new JFileChooser();
            fChoose.setFileFilter(fFilt);
            fChoose.setFileSelectionMode(0);
            fChoose.setMultiSelectionEnabled(false);
            if (this.transFile != null) {
                fChoose.setSelectedFile(this.transFile);
            }
            fChoose.showOpenDialog(this);
            this.transFile = fChoose.getSelectedFile();
            if (this.transFile == null) {
                this.txtTrans.setText("");
                return;
            }
            this.txtTrans.setText(this.transFile.toString());
        }
        finally {
            this.checkEnabledState();
        }
    }

    private void cboClippingActionPerformed(ActionEvent evt) {
    }

    private void optionsPane_onPropertyChange(PropertyChangeEvent evt) {
        this.pack();
    }

    private void cboExportThemaLayersActionPerformed(ActionEvent evt) {
    }

    private void cboExportLineWidthActionPerformed(ActionEvent evt) {
    }
}

