/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.dxf;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.models.ListListModel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.ListModel;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChooseDxfDraftDialog
extends JDialog {
    private static final Logger LOG = LoggerFactory.getLogger(ChooseDxfDraftDialog.class);
    private static final String CURRENT_FILE_KEY = String.valueOf(ChooseDxfDraftDialog.class) + " - FILE";
    private static final String LAST_DRAFT_KEY = String.valueOf(ChooseDxfDraftDialog.class) + " - LASTDRAFT";
    private static final FileFilter FILEFILTER_DXF = new FileFilter(){

        @Override
        public String getDescription() {
            return I18N.get("ui.plugin.dxf.ChooseDxfDraftDialog.FileFilterName");
        }

        @Override
        public boolean accept(File f) {
            return f.exists() && f.isFile() && StringUtils.endsWithIgnoreCase((CharSequence)f.getName(), (CharSequence)".dxf") || f.isDirectory();
        }
    };
    private File dxfDraft = null;
    private String strFileName = null;
    private JPanel btnPanel;
    private JButton butCancel;
    private JButton butOpen;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JLabel lblDxfDraft;
    private JList<String> lstDraft;
    private JPanel pnlDefaultDraft;
    private JFileChooser pnlLocalDraft;
    private JTabbedPane tabPanel;

    public ChooseDxfDraftDialog(JDialog owner) {
        super((Dialog)owner, true);
        this.initComponents();
        this.i18n();
        this.init();
    }

    private void i18n() {
        this.setTitle(I18N.get("ui.plugin.dxf.ChooseDxfDraftDialog.title"));
        this.tabPanel.setTitleAt(0, I18N.get("ui.plugin.dxf.ChooseDxfDraftDialog.default"));
        this.tabPanel.setTitleAt(1, I18N.get("ui.plugin.dxf.ChooseDxfDraftDialog.local"));
        this.lblDxfDraft.setText(I18N.get("ui.plugin.dxf.ChooseDxfDraftDialog.dxf-drafts"));
        this.butCancel.setText(I18N.get("common.cancel"));
        this.butOpen.setText(I18N.get("common.open"));
    }

    private void init() {
        this.pnlLocalDraft.setFileFilter(FILEFILTER_DXF);
        Blackboard bb = PersistentBlackboardPlugIn.get();
        if (bb.contains(CURRENT_FILE_KEY)) {
            String strPath = (String)bb.get(CURRENT_FILE_KEY);
            this.pnlLocalDraft.setSelectedFile(new File(strPath));
        }
        this.pnlLocalDraft.setMultiSelectionEnabled(false);
        if (JUMPWorkbench.GIS_CONTEXT == null) {
            this.tabPanel.setEnabledAt(0, false);
            this.tabPanel.setSelectedIndex(1);
        } else {
            try {
                this.tabPanel.setEnabledAt(0, true);
                String[] arrFiles = JUMPWorkbench.GIS_CONTEXT.getModuleApp().getFileList("dxf_draft");
                Arrays.sort(arrFiles, String.CASE_INSENSITIVE_ORDER);
                ArrayList<String> lstFiles = new ArrayList<String>();
                for (String currFile : arrFiles) {
                    lstFiles.add(FilenameUtils.getBaseName((String)currFile));
                }
                ListListModel lstModel = new ListListModel(lstFiles);
                this.lstDraft.setModel((ListModel<String>)lstModel);
            }
            catch (Exception e) {
                ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"riwagis");
                this.tabPanel.getTabComponentAt(0).setVisible(false);
                this.tabPanel.getTabComponentAt(0).setEnabled(false);
            }
        }
    }

    public File getDraft() {
        return this.dxfDraft;
    }

    public String getDraftName() {
        return FilenameUtils.getBaseName((String)this.strFileName);
    }

    public static File getLastDraft() {
        try {
            String strDraftFile = (String)PersistentBlackboardPlugIn.get().get(LAST_DRAFT_KEY);
            if (strDraftFile == null) {
                return null;
            }
            File draftFile = new File(strDraftFile);
            if (draftFile.exists()) {
                return draftFile;
            }
            if (JUMPWorkbench.GIS_CONTEXT != null) {
                File gcDraftFile = ChooseDxfDraftDialog.getGisContextDraftFile(strDraftFile);
                return gcDraftFile;
            }
            return null;
        }
        catch (Exception e) {
            LOG.warn("Error retrieving last DXF draft.");
            return null;
        }
    }

    public static String getLastDraftName() {
        try {
            String strDraftFile = (String)PersistentBlackboardPlugIn.get().get(LAST_DRAFT_KEY);
            if (strDraftFile == null) {
                return null;
            }
            return FilenameUtils.getBaseName((String)strDraftFile);
        }
        catch (Exception e) {
            LOG.warn("Error retrieving last DXF draft name.");
            return null;
        }
    }

    public static File getGisContextDraftFile(String strFileName) throws Exception {
        if (JUMPWorkbench.GIS_CONTEXT != null) {
            return JUMPWorkbench.GIS_CONTEXT.getModuleApp().getFile("dxf_draft", strFileName);
        }
        LOG.error("ChooseDxfDraftDialog. GIS_CONTEXT is not initialised.");
        return null;
    }

    private void initComponents() {
        this.tabPanel = new JTabbedPane();
        this.pnlDefaultDraft = new JPanel();
        this.jPanel2 = new JPanel();
        this.lblDxfDraft = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.lstDraft = new JList();
        this.btnPanel = new JPanel();
        this.butOpen = new JButton();
        this.butCancel = new JButton();
        this.pnlLocalDraft = new JFileChooser();
        this.getContentPane().setLayout(new GridBagLayout());
        this.pnlDefaultDraft.setLayout(new GridBagLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        this.lblDxfDraft.setText("DXF-Vorlagen:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.lblDxfDraft, gridBagConstraints);
        this.lstDraft.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ChooseDxfDraftDialog.this.lstDraft_onMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.lstDraft);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlDefaultDraft.add((Component)this.jPanel2, gridBagConstraints);
        this.btnPanel.setLayout(new GridBagLayout());
        this.butOpen.setText("\u00d6ffnen");
        this.butOpen.setPreferredSize(new Dimension(120, 23));
        this.butOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChooseDxfDraftDialog.this.butOpen_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.btnPanel.add((Component)this.butOpen, gridBagConstraints);
        this.butCancel.setText("Abbrechen");
        this.butCancel.setPreferredSize(new Dimension(120, 23));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChooseDxfDraftDialog.this.butCancel_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.btnPanel.add((Component)this.butCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlDefaultDraft.add((Component)this.btnPanel, gridBagConstraints);
        this.tabPanel.addTab("Allgemein\n", this.pnlDefaultDraft);
        this.pnlLocalDraft.setAcceptAllFileFilterUsed(false);
        this.pnlLocalDraft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChooseDxfDraftDialog.this.pnlLocalDraft_actionPerformed(evt);
            }
        });
        this.tabPanel.addTab("Datei", this.pnlLocalDraft);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.tabPanel, gridBagConstraints);
        this.pack();
    }

    private void lstDraft_onMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.butOpen_onActionPerformed(null);
        }
    }

    private void butOpen_onActionPerformed(ActionEvent evt) {
        String selectedValue = this.lstDraft.getSelectedValue();
        if (selectedValue == null) {
            GUISupport.msgbox((Component)this, (String)I18N.get("ui.plugin.dxf.ChooseDxfDraftDialog.no-draft-selected"), (String)I18N.get("common.message"));
        } else {
            try {
                this.strFileName = selectedValue;
                this.dxfDraft = ChooseDxfDraftDialog.getGisContextDraftFile(this.strFileName);
                PersistentBlackboardPlugIn.get().put(LAST_DRAFT_KEY, this.strFileName);
                this.setVisible(false);
            }
            catch (Exception e) {
                ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"riwagis");
            }
        }
    }

    private void butCancel_onActionPerformed(ActionEvent evt) {
        this.dxfDraft = null;
        this.setVisible(false);
    }

    private void pnlLocalDraft_actionPerformed(ActionEvent evt) {
        try {
            if (evt.getActionCommand().equals("CancelSelection") || !this.pnlLocalDraft.getSelectedFile().exists()) {
                this.dxfDraft = null;
                this.strFileName = null;
                this.setVisible(false);
                return;
            }
            this.strFileName = this.pnlLocalDraft.getSelectedFile().getAbsolutePath();
            this.dxfDraft = new File(this.strFileName);
            Blackboard bb = PersistentBlackboardPlugIn.get();
            bb.put(CURRENT_FILE_KEY, this.strFileName);
            bb.put(LAST_DRAFT_KEY, this.strFileName);
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"riwagis");
        }
        finally {
            this.setVisible(false);
        }
    }
}

