/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.dxf;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.apache.commons.text.translate.CodePointTranslator;

class AutocadUnicodeEscaper
extends CodePointTranslator {
    private static final String UNICODE_ESCAPE = "\\U+";
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private final CharsetEncoder encoder;

    public AutocadUnicodeEscaper(Charset charset) {
        this.encoder = charset.newEncoder();
    }

    public boolean translate(int codepoint, Writer out) throws IOException {
        if (this.encoder.canEncode(Character.toString(codepoint))) {
            return false;
        }
        if (codepoint > 65535) {
            out.write(this.toUtf16Escape(codepoint));
        } else {
            out.write(UNICODE_ESCAPE);
            out.write(HEX_DIGITS[codepoint >> 12 & 0xF]);
            out.write(HEX_DIGITS[codepoint >> 8 & 0xF]);
            out.write(HEX_DIGITS[codepoint >> 4 & 0xF]);
            out.write(HEX_DIGITS[codepoint & 0xF]);
        }
        return true;
    }

    protected String toUtf16Escape(int codepoint) {
        return UNICODE_ESCAPE + AutocadUnicodeEscaper.hex((int)codepoint);
    }
}

