/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.clipboard;

import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.CollectionOfLayerablesTransferable;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.LayerableClipboardPlugIn;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasteLayersPlugIn
extends LayerableClipboardPlugIn {
    private static final Logger LOG = LoggerFactory.getLogger(PasteLayersPlugIn.class);

    @Override
    public String getNameWithMnemonic() {
        return StringUtil.replace(this.getName(), "P", "&P", false);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Transferable transferable = GUIUtil.getContents(Toolkit.getDefaultToolkit().getSystemClipboard());
        if (!transferable.isDataFlavorSupported(CollectionOfLayerablesTransferable.COLLECTION_OF_LAYERABLES_FLAVOR)) {
            return false;
        }
        Collection layerables = (Collection)transferable.getTransferData(CollectionOfLayerablesTransferable.COLLECTION_OF_LAYERABLES_FLAVOR);
        Category selectedCategory = context.getLayerNamePanel().getSelectedCategories().iterator().next();
        if (selectedCategory.isBuildIn()) {
            return false;
        }
        for (Layerable layerable : layerables) {
            Layerable clone = this.cloneLayerable(layerable);
            clone.setName(context.getLayerManager().uniqueLayerName(clone.getName()));
            clone.setKey(context.getLayerManager().uniqueLayerKey(clone.getKey()));
            clone.setLayerManager(context.getLayerManager());
            context.getLayerManager().addLayerable(selectedCategory, clone);
        }
        return true;
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createExactlyNLocalCategoriesMustBeSelectedCheck(1)).add(component -> {
            try {
                Transferable transferable = null;
                try {
                    transferable = GUIUtil.getContents(Toolkit.getDefaultToolkit().getSystemClipboard());
                }
                catch (Throwable t) {
                    return "System clipboard not available.";
                }
                if (transferable == null) {
                    return "Clipboard must not be empty";
                }
                if (!transferable.isDataFlavorSupported(CollectionOfLayerablesTransferable.COLLECTION_OF_LAYERABLES_FLAVOR)) {
                    return "Clipboard contents must be layers";
                }
                return null;
            }
            catch (Throwable t) {
                LOG.warn("Unknown error accessing clipboard", t);
                return String.format("Unknown error accessing clipboard: ", t.getMessage());
            }
        });
    }
}

