/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.clipboard;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.cursortool.QuasimodeTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.PasteItemsTool;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.CollectionOfFeaturesTransferable;
import de.riwagis.geotools.feature.util.FeatureUtil;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import lombok.Generated;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasteItemsPlugIn
extends AbstractPlugIn {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PasteItemsPlugIn.class);
    private PasteItemsTool pasteTool = null;
    private final TargetLayerProvider targetLayerProvider;

    public PasteItemsPlugIn(boolean useCurrentLayerTreeSelection) {
        this.targetLayerProvider = useCurrentLayerTreeSelection ? new CurrentlySelectedLayerTargetProvider() : new DigiLayerTargetProvider();
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        this.pasteTool = new PasteItemsTool();
        if (this.targetLayerProvider.shouldRegisterHotkey()) {
            this.registerPasteKey();
        }
    }

    private void registerPasteKey() {
        JUMPWorkbench.getFrame().addKeyboardShortcutForMap(86, 128, this, this.createEnableCheck());
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        ArrayList<SimpleFeature> features;
        Transferable transferable = GUIUtil.getContents(Toolkit.getDefaultToolkit().getSystemClipboard());
        if (transferable.isDataFlavorSupported(CollectionOfFeaturesTransferable.COLLECTION_OF_FEATURES_FLAVOR)) {
            features = (ArrayList<SimpleFeature>)GUIUtil.getContents(Toolkit.getDefaultToolkit().getSystemClipboard()).getTransferData(CollectionOfFeaturesTransferable.COLLECTION_OF_FEATURES_FLAVOR);
        } else {
            FeatureCollection fcol = FeatureUtil.readWKTFeatureCollection((Reader)new StringReader((String)transferable.getTransferData(DataFlavor.stringFlavor)));
            features = new ArrayList<SimpleFeature>();
            FeatureIterator fi = fcol.features();
            while (fi.hasNext()) {
                features.add((SimpleFeature)fi.next());
            }
        }
        this.pasteTool.setTargetLayer(this.targetLayerProvider.getTargetLayer());
        this.pasteTool.setPasteFeatures(new ArrayList<SimpleFeature>(features));
        context.getLayerViewPanel().setCurrentCursorTool(new QuasimodeTool(this.pasteTool));
        return true;
    }

    @Override
    public KeyStroke getKeyStroke() {
        return KeyStroke.getKeyStroke(86, 128);
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(this.targetLayerProvider.createEnableCheck()).add(new ClipboardContentIsValidCheck());
    }

    private static class CurrentlySelectedLayerTargetProvider
    implements TargetLayerProvider {
        private CurrentlySelectedLayerTargetProvider() {
        }

        @Override
        public EnableCheck createEnableCheck() {
            EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
            return new MultiEnableCheck().add(checkFactory.createExactlyNLayerablesMustBeSelectedCheck(1, Layer.class)).add(checkFactory.createSelectedLayersCanBeDigiLayerCheck());
        }

        @Override
        public Layer getTargetLayer() {
            return WorkbenchContext.getInstance().getLayerNamePanel().selectedNodes(Layer.class).iterator().next();
        }

        @Override
        public boolean shouldRegisterHotkey() {
            return false;
        }
    }

    private static interface TargetLayerProvider {
        public EnableCheck createEnableCheck();

        public Layer getTargetLayer();

        public boolean shouldRegisterHotkey();
    }

    private static class DigiLayerTargetProvider
    implements TargetLayerProvider {
        private DigiLayerTargetProvider() {
        }

        @Override
        public EnableCheck createEnableCheck() {
            return EditingPanel.instanceOf().getLayerEnableCheck();
        }

        @Override
        public Layer getTargetLayer() {
            return EditingPanel.instanceOf().getCurrentLayer();
        }

        @Override
        public boolean shouldRegisterHotkey() {
            return true;
        }
    }

    private static class ClipboardContentIsValidCheck
    implements EnableCheck {
        private ClipboardContentIsValidCheck() {
        }

        @Override
        public String check(JComponent component) {
            try {
                Transferable transferable = null;
                try {
                    transferable = GUIUtil.getContents(Toolkit.getDefaultToolkit().getSystemClipboard());
                }
                catch (Throwable t) {
                    return I18N.get("com.vividsolutions.jump.workbench.ui.plugin.clipboard.PasteItemsPlugIn.error-clipboard-not-available");
                }
                if (transferable == null) {
                    return I18N.get("com.vividsolutions.jump.workbench.ui.plugin.clipboard.PasteItemsPlugIn.error-clipboard-empty");
                }
                if (transferable.isDataFlavorSupported(CollectionOfFeaturesTransferable.COLLECTION_OF_FEATURES_FLAVOR)) {
                    return null;
                }
                if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor) && this.isWKT((String)transferable.getTransferData(DataFlavor.stringFlavor))) {
                    return null;
                }
                return I18N.get("com.vividsolutions.jump.workbench.ui.plugin.clipboard.PasteItemsPlugIn.error-no-geometry");
            }
            catch (Throwable t) {
                log.warn("Unknown error accessing clipboard", t);
                return I18N.getMessage("com.vividsolutions.jump.workbench.ui.plugin.clipboard.PasteItemsPlugIn.error-unknown", t.getMessage());
            }
        }

        private boolean isWKT(String s) {
            try {
                FeatureUtil.readWKTFeatureCollection((Reader)new StringReader(s));
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

