/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.clipboard;

import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.cursortool.AbstractCursorTool;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.AbstractTransferable;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.DummyClipboardOwner;
import com.vividsolutions.jump.workbench.ui.snap.SnapManager;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

public class CopyThisCoordinatePlugIn
extends AbstractPlugIn {
    public static final String DELIMITER = String.valueOf(CopyThisCoordinatePlugIn.class) + "_DELIMITER";
    public static final String DECIMAL_DELIMITER = String.valueOf(CopyThisCoordinatePlugIn.class) + "_DECIMAL_DELIMITER";
    private static final Blackboard pBB = PersistentBlackboardPlugIn.get();
    private static final GeometryFactory gfac = new GeometryFactory();
    private final DecimalFormat df = new DecimalFormat();
    private final SnapManager snapManager = new SnapManager();

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        this.snapManager.addPolicies(AbstractCursorTool.createStandardSnappingPolicies(PersistentBlackboardPlugIn.get()));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        final Coordinate c = this.snap(context, context.getLayerViewPanel().getViewport().toModelCoordinate(context.getLayerViewPanel().getLastClickedPoint()));
        context.getLayerViewPanel().flash(gfac.createGeometryCollection(new Geometry[]{gfac.createPoint(c)}));
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new AbstractTransferable(new DataFlavor[]{DataFlavor.plainTextFlavor}){

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                CopyThisCoordinatePlugIn.this.df.setGroupingUsed(false);
                String strDecSeparator = pBB.get(DECIMAL_DELIMITER, "" + new DecimalFormatSymbols().getDecimalSeparator());
                DecimalFormatSymbols dfs = new DecimalFormatSymbols();
                dfs.setDecimalSeparator(strDecSeparator.toCharArray()[0]);
                CopyThisCoordinatePlugIn.this.df.setDecimalFormatSymbols(dfs);
                CopyThisCoordinatePlugIn.this.df.setMaximumFractionDigits(2);
                CopyThisCoordinatePlugIn.this.df.setMinimumFractionDigits(2);
                return CopyThisCoordinatePlugIn.this.df.format(c.x) + pBB.get(DELIMITER, ";") + CopyThisCoordinatePlugIn.this.df.format(c.y);
            }
        }, new DummyClipboardOwner());
        return true;
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck());
    }

    private Coordinate snap(PlugInContext context, Coordinate modelCoordinate) {
        return this.snapManager.snap(context.getLayerViewPanel(), modelCoordinate);
    }
}

