/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.clipboard;

import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.AbstractLayerable;
import com.vividsolutions.jump.workbench.model.LabelLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerNamePanel;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.CollectionOfLayerablesTransferable;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.DummyClipboardOwner;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.LayerableClipboardPlugIn;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;

public class CopySelectedLayersPlugIn
extends LayerableClipboardPlugIn {
    @Override
    public String getNameWithMnemonic() {
        return StringUtil.replace(this.getName(), "C", "&C", false);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new CollectionOfLayerablesTransferable(this.clone(context.getLayerNamePanel().selectedNodes(Layerable.class))), new DummyClipboardOwner());
        return true;
    }

    private Collection clone(Collection layerables) {
        ArrayList<Layerable> clones = new ArrayList<Layerable>();
        for (Layerable layerable : layerables) {
            if ((!(layerable instanceof AbstractLayerable) || layerable.isBuildIn()) && !(layerable instanceof RedlineLayer)) continue;
            clones.add(this.cloneLayerable(layerable));
        }
        return clones;
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        final MultiEnableCheck checkLayerable = new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLocalLayerablesMustBeSelectedCheck(1, Layerable.class));
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                String strReturn = checkLayerable.check(component);
                LayerNamePanel lpnl = WorkbenchContext.getInstance().getLayerNamePanel();
                if (lpnl == null) {
                    return "No map active";
                }
                if (strReturn != null) {
                    Layer[] layers;
                    for (Layer layer : layers = lpnl.getSelectedLayers(true)) {
                        if (layer instanceof RedlineLayer) {
                            strReturn = null;
                        }
                        if (!(layer instanceof LabelLayer)) continue;
                        return "label layer can not be copied";
                    }
                    return strReturn;
                }
                Collection<Layerable> layers = lpnl.selectedNodes(Layerable.class);
                for (Layerable layer : layers) {
                    if (!(layer instanceof LabelLayer)) continue;
                    return "label layer can not be copied";
                }
                return null;
            }
        };
    }
}

