/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.clipboard;

import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.CollectionOfFeaturesTransferable;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.DummyClipboardOwner;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManager;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManagerProxy;
import de.riwagis.icons.IconLoader;
import java.awt.Toolkit;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.opengis.feature.simple.SimpleFeature;

public class CopySelectedItemsPlugIn
extends AbstractPlugIn {
    @Override
    public void initialize(PlugInContext context) throws Exception {
        this.registerCopyKey(context.getWorkbenchContext());
    }

    private void registerCopyKey(WorkbenchContext context) {
        JUMPWorkbench.getFrame().addKeyboardShortcutForMap(67, 128, this, this.createEnableCheck());
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        SelectionManager selectionManager = ((SelectionManagerProxy)((Object)context.getActiveInternalFrame())).getSelectionManager();
        List features = selectionManager.getLayersWithSelectedItems().stream().flatMap(layer -> {
            Stream<SimpleFeature> featureStream = selectionManager.createFeaturesFromSelectedItems((Layer)layer).stream();
            if (layer instanceof RedlineLayer) {
                return featureStream.map(feature -> {
                    feature.getUserData().put("RL_SOURCE_LAYER", layer);
                    return feature;
                });
            }
            return featureStream;
        }).collect(Collectors.toUnmodifiableList());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new CollectionOfFeaturesTransferable(features), new DummyClipboardOwner());
        return true;
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(checkFactory.createWindowWithSelectionManagerMustBeActiveCheck()).add(checkFactory.createAtLeastNItemsMustBeSelectedCheck(1));
    }

    @Override
    public KeyStroke getKeyStroke() {
        return KeyStroke.getKeyStroke(67, 128);
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.svgIcon((String)"common_copy.svg");
    }
}

