/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.clipboard;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.ExportImagePlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.AbstractTransferable;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.DummyClipboardOwner;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.KeyStroke;
import org.locationtech.jts.util.Assert;

public class CopyImagePlugIn
extends ExportImagePlugIn {
    @Override
    public void initialize(PlugInContext context) throws Exception {
        this.registerCopyImageKey(context.getWorkbenchContext());
    }

    private void registerCopyImageKey(WorkbenchContext context) {
        JUMPWorkbench.getFrame().addKeyboardShortcut(73, 128, this, this.createEnableCheck());
    }

    @Override
    public KeyStroke getKeyStroke() {
        return KeyStroke.getKeyStroke(73, 128);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Transferable transferable = this.createTransferable(context);
        if (transferable == null) {
            context.getWorkbenchFrame().warnUser(I18N.get("ui.plugin.clipboard.CopyImagePlugIn.could-not-copy-the-image-for-some-reason"));
            return false;
        }
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(transferable, new DummyClipboardOwner());
        return true;
    }

    private Transferable createTransferable(final PlugInContext context) {
        return new AbstractTransferable(new DataFlavor[]{DataFlavor.imageFlavor}){

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                Assert.isTrue((flavor == DataFlavor.imageFlavor ? 1 : 0) != 0);
                return CopyImagePlugIn.this.image(context.getLayerViewPanel());
            }
        };
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck());
    }
}

