/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.clipboard;

import com.vividsolutions.jump.io.FUTURE_JTS_WKTWriter;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.AbstractTransferable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;

public class CollectionOfFeaturesTransferable
extends AbstractTransferable {
    public static final DataFlavor COLLECTION_OF_FEATURES_FLAVOR = new DataFlavor((Class)Collection.class, "Collection of Features"){

        @Override
        public boolean equals(DataFlavor that) {
            return super.equals(that) && this.getHumanPresentableName().equals(that.getHumanPresentableName());
        }
    };
    private static final DataFlavor[] flavors = new DataFlavor[]{DataFlavor.stringFlavor, DataFlavor.plainTextFlavor, COLLECTION_OF_FEATURES_FLAVOR};
    private final Collection features;
    private final FUTURE_JTS_WKTWriter writer = new FUTURE_JTS_WKTWriter();

    public CollectionOfFeaturesTransferable(Collection features) {
        super(flavors);
        this.features = new ArrayList(features);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (flavor.equals(COLLECTION_OF_FEATURES_FLAVOR)) {
            return Collections.unmodifiableCollection(this.features);
        }
        if (flavor.equals(DataFlavor.stringFlavor)) {
            return this.toString(this.features);
        }
        if (flavor.equals(DataFlavor.plainTextFlavor)) {
            return new StringReader(this.toString(this.features));
        }
        throw new UnsupportedFlavorException(flavor);
    }

    private String toString(Collection features) {
        StringBuffer b = new StringBuffer();
        for (SimpleFeature feature : features) {
            b.append(this.writer.writeFormatted((Geometry)feature.getDefaultGeometry()) + "\n\n");
        }
        return b.toString();
    }
}

