/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.attributes.featureinfo;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.DesktopPanel;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.TaskFrameProxy;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.InfoModel;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.InfoPanel;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.featureinfo.FeatureInfoAction;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManager;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManagerProxy;
import java.util.Collection;
import java.util.function.Function;
import org.opengis.feature.simple.SimpleFeature;

public class ObjectInfoFeatureInfoAction
implements FeatureInfoAction {
    @Override
    public void reset(PlugInContext context) {
        this.getInfoModel(context).clear();
    }

    @Override
    public boolean process(Layer layerWithSelection, Function<Layer, Collection<SimpleFeature>> featureSupplier, boolean alreadyMatched, PlugInContext context) throws Exception {
        if (alreadyMatched && !this.getDesktopPanel(context).getBottomTabsVisible()) {
            return false;
        }
        Collection<SimpleFeature> selectedFeatures = featureSupplier.apply(layerWithSelection);
        if (selectedFeatures.isEmpty()) {
            return false;
        }
        this.getInfoModel(context).add(layerWithSelection, selectedFeatures);
        return true;
    }

    @Override
    public void execute(PlugInContext context) throws Exception {
        TaskFrame taskFrame = this.getTaskFrame(context);
        DesktopPanel desktopPanel = this.getDesktopPanel(context);
        InfoPanel infoPanel = this.getInfoPanel(context);
        InfoModel infoModel = this.getInfoModel(context);
        desktopPanel.removePane(infoPanel);
        if (infoModel.getLayers().isEmpty()) {
            return;
        }
        desktopPanel.addBottomPane(I18N.get("ui.InfoPanel.feature-info"), I18N.get("ui.InfoPanel.feature-info"), infoPanel, evt -> infoModel.clear(), taskFrame);
    }

    private DesktopPanel getDesktopPanel(PlugInContext context) {
        return context.getWorkbenchFrame().getDesktopPanel();
    }

    private InfoPanel getInfoPanel(PlugInContext context) {
        return this.getTaskFrame(context).getInfoPanel();
    }

    private InfoModel getInfoModel(PlugInContext context) {
        return this.getInfoPanel(context).getModel();
    }

    private TaskFrame getTaskFrame(PlugInContext context) {
        return ((TaskFrameProxy)((Object)context.getActiveInternalFrame())).getTaskFrame();
    }

    private SelectionManager getSelectionManager(PlugInContext context) {
        return ((SelectionManagerProxy)((Object)context.getActiveInternalFrame())).getSelectionManager();
    }
}

