/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.attributes.featureinfo;

import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.featureinfo.FeatureInfoAction;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.featureinfo.SelectionCallListDialog;
import de.riwagis.gis.context.module.ModuleAppContext;
import de.riwagis.gis.context.module.interfaces.SelectionExternalCall;
import java.awt.Frame;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.swing.JFrame;
import lombok.Generated;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterfaceCallFeatureInfoAction
implements FeatureInfoAction {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InterfaceCallFeatureInfoAction.class);
    private final Map<String, Set<SelectionExternalCall>> callsForLayers;
    private SelectionCallListDialog selectionCallListDialog;
    private Set<SelectionExternalCall> interfaceLayers = new HashSet<SelectionExternalCall>();

    public InterfaceCallFeatureInfoAction() {
        this.callsForLayers = new HashMap<String, Set<SelectionExternalCall>>();
        if (!JUMPWorkbench.gisContextAvailable()) {
            return;
        }
        ModuleAppContext modContext = JUMPWorkbench.GIS_CONTEXT.getModuleApp();
        Collection userTriggerableExternalCalls = modContext.getUserTriggerableExternalCalls();
        for (SelectionExternalCall c : userTriggerableExternalCalls) {
            c.layers().forEach(layer -> this.callsForLayers.computeIfAbsent((String)layer, l -> new HashSet()).add(c));
        }
    }

    @Override
    public void reset(PlugInContext context) {
        this.interfaceLayers.clear();
    }

    @Override
    public boolean process(Layer layerWithSelection, Function<Layer, Collection<SimpleFeature>> featureSupplier, boolean alreadyMatched, PlugInContext context) {
        if (alreadyMatched || !this.layerIsCoveredByInterfaceCall(layerWithSelection)) {
            return false;
        }
        this.interfaceLayers.addAll((Collection<SelectionExternalCall>)this.callsForLayers.get(layerWithSelection.getKey()));
        return true;
    }

    @Override
    public void execute(PlugInContext context) {
        this.callInterfaceIfRequired(context, this.interfaceLayers);
    }

    private void callInterfaceIfRequired(PlugInContext context, Set<SelectionExternalCall> possibleCalls) {
        Set<SelectionExternalCall> selectedEntries = this.getSelectionExternalCalls(context, possibleCalls);
        if (selectedEntries.isEmpty()) {
            log.info("Cancelled Interface Call");
            return;
        }
        selectedEntries.stream().forEach(x -> JUMPWorkbench.GIS_CONTEXT.getModuleApp().invokeExternalCallForSelection(x.getName()));
    }

    private Set<SelectionExternalCall> getSelectionExternalCalls(PlugInContext context, Set<SelectionExternalCall> possibleCalls) {
        if (possibleCalls.isEmpty()) {
            return Collections.emptySet();
        }
        if (possibleCalls.size() == 1) {
            return possibleCalls;
        }
        SelectionCallListDialog selectionCallListDialog = this.getTypeSelectionDialog(context.getWorkbenchFrame());
        selectionCallListDialog.setLocationRelativeTo(context.getWorkbenchFrame());
        selectionCallListDialog.setEntries(possibleCalls);
        selectionCallListDialog.setVisible(true);
        if (selectionCallListDialog.wasOKPressed()) {
            return selectionCallListDialog.getSelectedDataTypes();
        }
        return Collections.emptySet();
    }

    private SelectionCallListDialog getTypeSelectionDialog(JFrame rootFrame) {
        if (this.selectionCallListDialog == null) {
            this.selectionCallListDialog = new SelectionCallListDialog((Frame)rootFrame, true);
        }
        return this.selectionCallListDialog;
    }

    private boolean layerIsCoveredByInterfaceCall(Layer layer) {
        return this.callsForLayers.containsKey(layer.getKey());
    }
}

