/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.attributes.featureinfo;

import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.featureinfo.FeatureInfoAction;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.gis.context.module.DialogContext;
import de.riwagis.gis.context.module.ModuleAppContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.opengis.feature.simple.SimpleFeature;

public class GisDialogFeatureInfoAction
implements FeatureInfoAction {
    final Map<DialogContext, List<String>> mapDialogs2Show = new HashMap<DialogContext, List<String>>();

    @Override
    public void reset(PlugInContext context) {
        this.mapDialogs2Show.clear();
    }

    @Override
    public boolean process(Layer layerWithSelection, Function<Layer, Collection<SimpleFeature>> featureSupplier, boolean alreadyMatched, PlugInContext context) throws Exception {
        if (alreadyMatched || !JUMPWorkbench.gisContextAvailable()) {
            return false;
        }
        ModuleAppContext modContext = JUMPWorkbench.GIS_CONTEXT.getModuleApp();
        DialogContext[] dialogs = modContext.getDialogs4Layer(layerWithSelection.getKey());
        if (dialogs.length <= 0) {
            return false;
        }
        ArrayList<String> keys = new ArrayList<String>();
        String keyAttView = layerWithSelection.getFMD().getKeyAttView();
        if (StringUtils.isEmpty((CharSequence)keyAttView)) {
            for (SimpleFeature feature : featureSupplier.apply(layerWithSelection)) {
                String key = feature.getID();
                if (!StringUtils.isNotEmpty((CharSequence)key)) continue;
                keys.add(FeatureUtil.getFeatureIDWithoutTable((String)key));
            }
        } else {
            for (SimpleFeature feature : featureSupplier.apply(layerWithSelection)) {
                String attView = Objects.toString(FeatureUtil.getAttribute((SimpleFeature)feature, (String)keyAttView), null);
                if (!StringUtils.isNotEmpty((CharSequence)attView)) continue;
                keys.add(attView);
            }
        }
        if (keys.isEmpty()) {
            return false;
        }
        for (DialogContext dialog : dialogs) {
            this.mapDialogs2Show.computeIfAbsent(dialog, d -> new ArrayList()).addAll(keys);
        }
        return true;
    }

    @Override
    public void execute(PlugInContext context) throws Exception {
        for (Map.Entry<DialogContext, List<String>> dlgAndSelection : this.mapDialogs2Show.entrySet()) {
            DialogContext dlg = dlgAndSelection.getKey();
            List<String> selection = dlgAndSelection.getValue();
            dlg.setFilter((String[])selection.toArray(String[]::new));
            dlg.show();
        }
    }
}

