/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.attributes;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.TaskFrameProxy;
import com.vividsolutions.jump.workbench.ui.components.CloseablePanel;
import com.vividsolutions.jump.workbench.ui.components.HTMLPanel;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import de.riwagis.browser.util.BrowserSupport;
import de.riwagis.icons.IconLoader;
import de.riwagis.riwajump.model.style.WMSStyleModel;
import de.riwagis.util.gui.components.WaitDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JTabbedPane;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WmsFeatureInfoPlugIn
extends AbstractPlugIn {
    public static final String OPEN_WMS_IN_BROWSER = WmsFeatureInfoPlugIn.class.getName() + "_OPEN_WMS_IN_BROWSER";
    public static final ImageIcon ICON = IconLoader.svgIcon((String)"common_info.svg");
    private static final String EMPTY_FEATUREINFO_REGEXP = "(?i)(?s)^$|((<!DOCTYPE){0,1}.*?(<html.*?>).*?(<body[^>]*>)(</body>).*?(</html>).*?)";
    private static final Logger LOG = LoggerFactory.getLogger(WmsFeatureInfoPlugIn.class);
    private FeatureInfoDialog dialogInstance = null;

    @Override
    public ImageIcon getIcon() {
        return ICON;
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        final TaskFrame tFrame = ((TaskFrameProxy)((Object)context.getActiveInternalFrame())).getTaskFrame();
        final WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)context.getWorkbenchFrame(), (String)I18N.get("ui.plugin.ViewAttributesPlugIn.please-wait"));
        if (!this.isOpenInBrowser()) {
            if (this.dialogInstance == null) {
                this.dialogInstance = new FeatureInfoDialog();
            } else {
                this.dialogInstance.clear();
            }
        }
        final Point lastClickedPoint = tFrame.getLayerViewPanel().getLastClickedPoint();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    int layerCounter = 0;
                    for (WMSLayer wLy : tFrame.getTask().getLayerManager().getLayerables(WMSLayer.class)) {
                        if (!wLy.isVisibleOnScreen()) continue;
                        WMSStyleModel wmsStyle = wLy.getValidWMSStyle();
                        if (wmsStyle == null) {
                            Assert.shouldNeverReachHere((String)("no wms style found for layer" + wLy.getName()));
                        }
                        if (wmsStyle.isIgnoreFeatureInfo()) continue;
                        String strRegExp = (String)StringUtils.defaultIfEmpty((CharSequence)wmsStyle.getFeatureInfoRegExp(), (CharSequence)WmsFeatureInfoPlugIn.EMPTY_FEATUREINFO_REGEXP);
                        Pattern regExpPattern = Pattern.compile(strRegExp);
                        int subLayerCounter = 0;
                        ArrayList<String> lstTitles = new ArrayList<String>();
                        String[][] arrInfo = wLy.getFeatureInfo(tFrame.getLayerViewPanel(), lastClickedPoint);
                        if (arrInfo == null || arrInfo.length == 0) continue;
                        final HTMLPanel wmsPanel = !WmsFeatureInfoPlugIn.this.isOpenInBrowser() ? new HTMLPanel() : null;
                        for (int i = 0; i < arrInfo[0].length; ++i) {
                            String strInfo = arrInfo[1][i];
                            String strURL = arrInfo[2][i];
                            if ((strInfo = strInfo.trim()).length() == 0) continue;
                            Matcher regExpMatcher = regExpPattern.matcher(strInfo);
                            if (regExpMatcher.find()) {
                                LOG.debug("found empty feature info, matches: " + regExpPattern.pattern());
                                continue;
                            }
                            if (WmsFeatureInfoPlugIn.this.isOpenInBrowser()) {
                                if (layerCounter == 1) {
                                    Thread.sleep(2000L);
                                }
                                BrowserSupport.openBrowser((String)strURL);
                            } else {
                                strInfo = arrInfo[1][i];
                                if (layerCounter == 0) {
                                    WmsFeatureInfoPlugIn.this.dialogInstance.setVisible(true);
                                    WmsFeatureInfoPlugIn.this.dialogInstance.requestFocus();
                                }
                                lstTitles.add(arrInfo[0][i]);
                                if (subLayerCounter == 0) {
                                    ActionListener closeAction = new ActionListener(){

                                        @Override
                                        public void actionPerformed(ActionEvent evt) {
                                            if (WmsFeatureInfoPlugIn.this.dialogInstance.getTabbedPane().getSelectedIndex() > -1) {
                                                WmsFeatureInfoPlugIn.this.dialogInstance.getTabbedPane().removeTabAt(WmsFeatureInfoPlugIn.this.dialogInstance.getTabbedPane().getSelectedIndex());
                                                wmsPanel.dispose();
                                            }
                                        }
                                    };
                                    CloseablePanel closeablePanel = new CloseablePanel(ObjectUtils.toString(lstTitles.get(lstTitles.size() - 1)), wmsPanel, closeAction);
                                    wmsPanel.addRecordChangeListener(index -> {
                                        if (index > -1 && index < lstTitles.size()) {
                                            closeablePanel.setTitle(ObjectUtils.toString(lstTitles.get(index)));
                                        }
                                    });
                                    WmsFeatureInfoPlugIn.this.dialogInstance.addFeatureInfoTab(wLy.getName(), closeablePanel);
                                }
                                wmsPanel.createNewDocument(strInfo, strURL);
                            }
                            ++layerCounter;
                            ++subLayerCounter;
                        }
                    }
                    if (layerCounter > 0 && !WmsFeatureInfoPlugIn.this.isOpenInBrowser()) {
                        WmsFeatureInfoPlugIn.this.dialogInstance.setVisible(true);
                        WmsFeatureInfoPlugIn.this.dialogInstance.requestFocus();
                    } else if (WmsFeatureInfoPlugIn.this.dialogInstance != null) {
                        WmsFeatureInfoPlugIn.this.dialogInstance.setVisible(false);
                    }
                }
                catch (Exception e) {
                    dlgWait.setError(e);
                }
            }
        };
        dlgWait.addWorkToDo(run);
        dlgWait.setVisible(true);
        if (dlgWait.getError() != null) {
            throw dlgWait.getError();
        }
        return true;
    }

    public static String removeAllTags(String str) {
        StringBuilder sb = new StringBuilder(str);
        boolean bolInsideTag = false;
        for (int i = sb.length() - 1; i >= 0; --i) {
            if (sb.charAt(i) == '>') {
                bolInsideTag = true;
            }
            if (sb.charAt(i) == '<') {
                sb.deleteCharAt(i);
                bolInsideTag = false;
            }
            if (!bolInsideTag) continue;
            sb.deleteCharAt(i);
        }
        return sb.toString();
    }

    private boolean isOpenInBrowser() {
        return PersistentBlackboardPlugIn.get().get(OPEN_WMS_IN_BROWSER, false);
    }

    private class FeatureInfoDialog
    extends JDialog {
        private JTabbedPane tabbedPane;

        public FeatureInfoDialog() {
            super(WorkbenchContext.getFrame(), String.format("WMS %s", I18N.get("ui.InfoPanel.feature-info")), false);
            this.tabbedPane = new JTabbedPane();
            super.setDefaultCloseOperation(1);
            super.setSize(400, 600);
            this.tabbedPane.addChangeListener(e -> {
                if (this.tabbedPane.getTabCount() == 0) {
                    this.setVisible(false);
                }
            });
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.tabbedPane, "Center");
        }

        public void clear() {
            this.tabbedPane.removeAll();
        }

        public void addFeatureInfoTab(String name, JComponent content) {
            this.tabbedPane.add(name, content);
            this.tabbedPane.setSelectedComponent(content);
        }

        @Override
        public void dispose() {
            super.dispose();
            WmsFeatureInfoPlugIn.this.dialogInstance = null;
        }

        public JTabbedPane getTabbedPane() {
            return this.tabbedPane;
        }
    }
}

