/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.attributes;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.plugin.AbstractExportPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.DesktopPanel;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.TaskFrameProxy;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.OneLayerAttributeTab;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.gui.components.WaitDialog;
import java.awt.Component;
import java.awt.Window;
import javax.swing.ImageIcon;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class ViewAttributesPlugIn
extends AbstractExportPlugIn {
    @Override
    public String getName() {
        return I18N.get("ui.plugin.ViewAttributesPlugIn.view-edit-attributes");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Layer ly = context.getSelectedLayer(0);
        DesktopPanel desktopPanel = context.getWorkbenchFrame().getDesktopPanel();
        JTabbedPane bottomTabbedPane = desktopPanel.getBottomTabbedPane();
        int totalTabs = bottomTabbedPane.getTabCount();
        for (int i = 0; i < totalTabs; ++i) {
            OneLayerAttributeTab oneLayerAttributeTab;
            Component comp = bottomTabbedPane.getComponentAt(i);
            if (!(comp instanceof OneLayerAttributeTab) || !(oneLayerAttributeTab = (OneLayerAttributeTab)comp).getModel().getLayers().contains(ly)) continue;
            bottomTabbedPane.setSelectedIndex(i);
            if (!desktopPanel.getBottomTabsVisible()) {
                desktopPanel.setBottomTabsVisible(true);
            }
            oneLayerAttributeTab.setLayer(((OneLayerAttributeTab)comp).getLayer());
            desktopPanel.showUndockedPanel();
            return true;
        }
        TaskFrame tFrame = ((TaskFrameProxy)((Object)context.getActiveInternalFrame())).getTaskFrame();
        OneLayerAttributeTab attributeTab = new OneLayerAttributeTab(context.getWorkbenchContext(), tFrame, ly instanceof RedlineLayer);
        RemoveTabLayerListener removeTabLayerListener = new RemoveTabLayerListener(context, ly, attributeTab);
        context.getLayerManager().addLayerListener(removeTabLayerListener);
        Runnable run = () -> {
            attributeTab.setLayer(ly);
            SwingUtilities.invokeLater(() -> context.getWorkbenchFrame().getDesktopPanel().addBottomPane(ly.getName(), I18N.get("ui.plugin.ViewAttributesPlugIn.attributes"), attributeTab, evt -> attributeTab.getModel().dispose(), tFrame));
        };
        WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)context.getWorkbenchFrame(), (String)I18N.get("ui.plugin.ViewAttributesPlugIn.please-wait"), (Runnable)run);
        dlgWait.setVisible(true);
        if (dlgWait.getError() != null) {
            context.getWorkbenchFrame().handleThrowable(dlgWait.getError());
        }
        dlgWait.dispose();
        return true;
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(ViewAttributesPlugIn.createExportAllowedCheck()).add(checkFactory.createTaskWindowMustBeActiveCheck()).add(checkFactory.createExactlyNLayersMustBeSelectedCheck(1));
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.svgIcon((String)"show_attributes.svg");
    }

    private static class RemoveTabLayerListener
    implements LayerListener {
        private final Layer ly;
        private final PlugInContext context;
        private final OneLayerAttributeTab attributeTab;

        public RemoveTabLayerListener(PlugInContext context, Layer layer, OneLayerAttributeTab attributeTab) {
            this.ly = layer;
            this.context = context;
            this.attributeTab = attributeTab;
        }

        @Override
        public void featuresChanged(FeatureEvent e) {
        }

        @Override
        public void layerChanged(LayerEvent e) {
            if (e.getLayerable() == this.ly && e.getType() == LayerEventType.REMOVED) {
                this.context.getLayerManager().removeLayerListener(this);
                SwingUtilities.invokeLater(() -> this.context.getWorkbenchFrame().getDesktopPanel().removePane(this.attributeTab));
            }
        }

        @Override
        public void categoryChanged(CategoryEvent e) {
        }
    }
}

