/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.attributes;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerStyleCollection;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManager;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManagerProxy;
import de.riwagis.browser.util.BrowserSupport;
import de.riwagis.geotools.feature.bsh.FeatBshStringBuilder;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.OSFile;
import de.riwagis.util.gui.components.WaitDialog;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.apache.commons.lang3.ObjectUtils;
import org.opengis.feature.simple.SimpleFeature;

public class UrlFeatureInfoPlugIn
extends AbstractPlugIn {
    public static final ImageIcon ICON = IconLoader.svgIcon((String)"common_info_url.svg");
    private static final int MAX_URLS2CALL = 20;

    @Override
    public ImageIcon getIcon() {
        return ICON;
    }

    @Override
    public String getName() {
        return I18N.get("ui.plugin.attributes.UrlFeatureInfoPlugIn.name");
    }

    public static MultiEnableCheck createEnableCheck(final WorkbenchContext workbenchContext, final SelectionManagerProxy selMngrProxy) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        EnableCheck chkOneFeatureWithUrlLinkSelected = new EnableCheck(){

            @Override
            public String check(JComponent component) {
                LayerStyleCollection sCol;
                Collection<SimpleFeature> colFeat;
                Layer ly;
                Collection<Layer> colLy = selMngrProxy.getSelectionManager().getLayersWithSelectedItems();
                if (colLy.toArray().length == 1 && (ly = colLy.iterator().next()).getClass().equals(Layer.class) && (colFeat = selMngrProxy.getSelectionManager().getFeaturesWithSelectedItems(ly)).toArray().length < 20 && (sCol = (LayerStyleCollection)ly.getStyleCollectionByScale(workbenchContext.getLayerManager().getScreenScale())) != null && sCol.getBasicStyle() != null && sCol.getBasicStyle().isUseUrl()) {
                    return null;
                }
                return String.format("No feature on a layer with an url link is selected or more than %s features are selected.", 20);
            }
        };
        return new MultiEnableCheck().add(checkFactory.createWindowWithSelectionManagerMustBeActiveCheck()).add(checkFactory.createWindowWithLayerManagerMustBeActiveCheck()).add(checkFactory.createWindowWithAssociatedTaskFrameMustBeActiveCheck()).add(chkOneFeatureWithUrlLinkSelected);
    }

    @Override
    public EnableCheck createEnableCheck() {
        return UrlFeatureInfoPlugIn.createEnableCheck(WorkbenchContext.getInstance(), WorkbenchContext.getInstance());
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        UrlFeatureInfoPlugIn.openURL(context.getLayerViewPanel().getSelectionManager());
        return true;
    }

    public static void openURL(SelectionManager selMngr) throws Exception {
        boolean bolShowMaxUrlMessage = false;
        Collection<Layer> colLy = selMngr.getLayersWithSelectedItems();
        final ArrayList<String> colUrls2Call = new ArrayList<String>();
        block0: for (Layer ly : colLy) {
            LayerStyleCollection sCol;
            if (bolShowMaxUrlMessage) break;
            if (!ly.getClass().equals(Layer.class) || !(sCol = (LayerStyleCollection)ly.getStyleCollectionByScale(ly.getLayerManager().getScreenScale())).getBasicStyle().isUseUrl()) continue;
            Collection<SimpleFeature> colFeat = selMngr.getFeaturesWithSelectedItems(ly);
            FeatBshStringBuilder fbs = FeatBshStringBuilder.getInstance((String)sCol.getBasicStyle().getUrl());
            for (SimpleFeature feat : colFeat) {
                fbs.setFeature(feat);
                String strURL = ObjectUtils.toString((Object)fbs.getString()).trim();
                if (strURL.isEmpty()) continue;
                if (colUrls2Call.size() > 20) {
                    bolShowMaxUrlMessage = true;
                    continue block0;
                }
                colUrls2Call.add(strURL);
            }
        }
        if (bolShowMaxUrlMessage) {
            GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.getMessage("ui.plugin.attributes.UrlFeatureInfoPlugIn.more-than-max-features-selected", 20), (String)I18N.get("common.alert"));
        }
        if (!colUrls2Call.isEmpty()) {
            final WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)WorkbenchContext.getFrame(), (String)I18N.get("common.wait"));
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    try {
                        int counterBrowser = 0;
                        for (String strURL : colUrls2Call) {
                            if (strURL.toLowerCase().startsWith("http")) {
                                if (counterBrowser == 1) {
                                    Thread.sleep(2000L);
                                }
                                BrowserSupport.openBrowser((String)strURL);
                                ++counterBrowser;
                                continue;
                            }
                            if (strURL.startsWith("exec://")) {
                                Runtime.getRuntime().exec(strURL.substring(7));
                                continue;
                            }
                            OSFile.showFile((File)new File(strURL), (boolean)false);
                        }
                    }
                    catch (Exception e) {
                        dlgWait.setError(e);
                    }
                }
            };
            dlgWait.addWorkToDo(run);
            dlgWait.setVisible(true);
            if (dlgWait.getError() != null) {
                throw dlgWait.getError();
            }
        }
    }
}

