/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.attributes;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManager;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManagerProxy;
import de.riwagis.icons.IconLoader;
import de.riwagis.riwajump.feature.WhiteListFeatureIterator;
import de.riwagis.util.gui.components.WaitDialog;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.ImageIcon;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;

public class SetSelectionToGraphicsFilterPlugIn
extends AbstractPlugIn {
    public static final ImageIcon ICON = IconLoader.svgIcon((String)"filter_exchange_all.svg");

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)context.getWorkbenchFrame(), (String)I18N.get("ui.plugin.ViewAttributesPlugIn.please-wait"));
        Runnable run = () -> {
            try {
                SelectionManager selectionManager = ((SelectionManagerProxy)((Object)context.getActiveInternalFrame())).getSelectionManager();
                Collection<Layer> layers = selectionManager.getLayersWithSelectedItems();
                for (Layer layer : layers) {
                    ArrayList<String> lstKeys = new ArrayList<String>();
                    String whiteListAttribute = WhiteListFeatureIterator.getWhiteListAttribute(layer.getFMD());
                    FeatureIterator<SimpleFeature> fit = layer.getSelectedFeatures();
                    while (fit.hasNext()) {
                        lstKeys.add(WhiteListFeatureIterator.extractKey((SimpleFeature)fit.next(), whiteListAttribute));
                    }
                    if (lstKeys.isEmpty()) continue;
                    layer.setFidFilterWhiteList(lstKeys);
                    layer.fireAppearanceChanged();
                }
            }
            catch (Exception e) {
                dlgWait.setError(e);
            }
        };
        dlgWait.addWorkToDo(run);
        dlgWait.setVisible(true);
        if (dlgWait.getError() != null) {
            throw dlgWait.getError();
        }
        return true;
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(checkFactory.createWindowWithSelectionManagerMustBeActiveCheck()).add(checkFactory.createAtLeastNItemsMustBeSelectedCheck(1));
    }

    @Override
    public ImageIcon getIcon() {
        return ICON;
    }
}

