/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.attributes;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.model.AbstractLayerable;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.TaskFrameProxy;
import com.vividsolutions.jump.workbench.ui.cursortool.SpecifyFeaturesTool;
import com.vividsolutions.jump.workbench.ui.plugin.quickinfo.QuickInfoPlugIn;
import de.riwagis.gis.context.map.LayerContext;
import de.riwagis.guitools.Tasks;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.gui.components.SelfClosingMessageBox;
import java.awt.Point;
import java.awt.Window;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.simple.SimpleFeature;

public class SelectQuickInfoForPositionPlugIn
extends AbstractPlugIn {
    private final QuickInfoPlugIn quickInfoPlugIn;

    public SelectQuickInfoForPositionPlugIn(QuickInfoPlugIn quickInfoPlugIn) {
        this.quickInfoPlugIn = quickInfoPlugIn;
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.svgIcon((String)"common_eye_on.svg");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        TaskFrame taskFrame = ((TaskFrameProxy)((Object)context.getActiveInternalFrame())).getTaskFrame();
        Point lastClickedPoint = taskFrame.getLayerViewPanel().getLastClickedPoint();
        Coordinate coord = taskFrame.getLayerViewPanel().getViewport().toModelCoordinate(lastClickedPoint);
        return Tasks.submit(() -> this.trySelectingQuickInfo(context, coord));
    }

    @Override
    public boolean isAvailable() {
        return JUMPWorkbench.gisContextAvailable();
    }

    private void trySelectingQuickInfo(PlugInContext context, Coordinate coord) throws Exception {
        Envelope env = new Envelope(coord, coord);
        env.expandBy(2.0 / context.getLayerViewPanel().getViewport().getScale());
        Map<Layer, Collection<SimpleFeature>> layersWithSelections = SpecifyFeaturesTool.layerToSpecifiedFeaturesMap(this.candidateLayers(context), env);
        Set<LayerContext> quickInfoLayers = this.quickInfoPlugIn.getQuickInfoLayers();
        List quickInfoLayersWithSelections = layersWithSelections.keySet().stream().filter(layer -> quickInfoLayers.contains(layer.getLayerContext())).sorted(Comparator.comparingInt(AbstractLayerable::getRenderPrio).reversed()).collect(Collectors.toList());
        SwingUtilities.invokeLater(() -> {
            for (Layer layer : quickInfoLayersWithSelections) {
                SimpleFeature firstFeature;
                if (!this.quickInfoPlugIn.setCurrentRecordByFeature(context, layer, firstFeature = (SimpleFeature)((Collection)layersWithSelections.get(layer)).iterator().next())) continue;
                return;
            }
            SelfClosingMessageBox msgBox = new SelfClosingMessageBox((Window)JUMPWorkbench.getFrame(), I18N.get("com.vividsolutions.jump.workbench.ui.plugin.attributes.SelectQuickInfoForPositionPlugIn.info-no-quickinfos-in-selection"), 3000);
            msgBox.setVisible(true);
        });
    }

    private Collection<Layer> candidateLayers(PlugInContext context) {
        return context.getLayerNamePanel().getLayerManager().getLayers();
    }

    @Override
    public EnableCheck createEnableCheck() {
        return EnableCheckFactory.getInstance().createAtLeastNFeaturesMustBeSelectedCheck(1);
    }
}

