/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.attributes;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.TaskFrameProxy;
import com.vividsolutions.jump.workbench.ui.cursortool.SpecifyFeaturesTool;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.InfoPanel;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.WmsFeatureInfoPlugIn;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.gui.components.WaitDialog;
import java.awt.Window;
import java.util.Collection;
import java.util.Map;
import javax.swing.ImageIcon;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.simple.SimpleFeature;

public class PositionFeatureInfoPlugIn
extends AbstractPlugIn {
    public static final ImageIcon ICON = IconLoader.svgIcon((String)"layer_info.svg");

    @Override
    public ImageIcon getIcon() {
        return ICON;
    }

    protected Collection<Layer> candidateLayers(PlugInContext context) {
        return context.getLayerNamePanel().getLayerManager().getLayers();
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        TaskFrame tFrame = ((TaskFrameProxy)((Object)context.getActiveInternalFrame())).getTaskFrame();
        Coordinate coord = tFrame.getLayerViewPanel().getViewport().toModelCoordinate(tFrame.getLayerViewPanel().getLastClickedPoint());
        InfoPanel infoPanel = tFrame.getInfoPanel();
        WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)context.getWorkbenchFrame(), (String)I18N.get("ui.plugin.ViewAttributesPlugIn.please-wait"));
        Runnable run = () -> {
            try {
                Envelope env = new Envelope(coord, coord);
                env.expandBy(2.0 / context.getLayerViewPanel().getViewport().getScale());
                Map<Layer, Collection<SimpleFeature>> map = SpecifyFeaturesTool.layerToSpecifiedFeaturesMap(this.candidateLayers(context), env);
                infoPanel.getModel().clear();
                context.getLayerViewPanel().getSelectionManager().clear();
                for (Layer layer : map.keySet()) {
                    Collection<SimpleFeature> features = map.get(layer);
                    context.getLayerViewPanel().getSelectionManager().getFeatureSelection().selectItems(layer, features);
                    infoPanel.getModel().add(layer, features);
                }
                if (infoPanel.getModel().getLayers().isEmpty()) {
                    return;
                }
                context.getWorkbenchFrame().getDesktopPanel().removePane(infoPanel);
                context.getWorkbenchFrame().getDesktopPanel().addBottomPane(I18N.get("ui.InfoPanel.feature-info"), I18N.get("ui.InfoPanel.feature-info"), infoPanel, evt -> infoPanel.getModel().clear(), tFrame);
            }
            catch (Exception e) {
                dlgWait.setError(e);
            }
        };
        dlgWait.addWorkToDo(run);
        dlgWait.setVisible(true);
        if (dlgWait.getError() != null) {
            throw dlgWait.getError();
        }
        return JUMPWorkbench.getBuiltInPlugIn(WmsFeatureInfoPlugIn.class).execute(context);
    }
}

