/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.attributes;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.ExcelExport;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.AttributeTab;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.InfoModel;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.LayerTableModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneLayerAttributeTab
extends AttributeTab {
    public static final int FEATURE_LIMIT = 50000;
    private static final Logger LOG = LoggerFactory.getLogger(OneLayerAttributeTab.class);

    public OneLayerAttributeTab(WorkbenchContext context, TaskFrame taskFrame) {
        this(context, taskFrame, false);
    }

    public OneLayerAttributeTab(WorkbenchContext context, TaskFrame taskFrame, boolean isRedlineLayer) {
        super(new InfoModel(true), context, taskFrame, isRedlineLayer);
    }

    public OneLayerAttributeTab setLayer(Layer layer) {
        if (!this.getModel().getLayers().isEmpty()) {
            this.getModel().remove(this.getLayer());
        }
        ArrayList<SimpleFeature> lstFeatures = new ArrayList<SimpleFeature>();
        try {
            FeatureIterator<SimpleFeature> fi;
            if (!layer.getCacheAll() && layer.getFeatureCount(false) >= 50000) {
                SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this, I18N.getMessage("ui.AttributeTab.OneLayerAttributeTab.to-many-features", 50000), I18N.get("common.message"), -1));
            }
            try (FeatureIterator<SimpleFeature> featureIterator = fi = layer.getFeatureIterator((Filter)Filter.INCLUDE, 50000);){
                while (fi.hasNext()) {
                    lstFeatures.add((SimpleFeature)fi.next());
                }
            }
        }
        catch (Exception e) {
            LOG.warn(String.format("error accessing features on layer '%s': %s", layer.getName(), e.getMessage()));
        }
        this.getModel().add(layer, lstFeatures);
        return this;
    }

    public Layer getLayer() {
        return this.getLayerTableModel() != null ? this.getLayerTableModel().getLayer() : null;
    }

    public LayerTableModel getLayerTableModel() {
        return !this.getModel().getLayerTableModels().isEmpty() ? this.getModel().getLayerTableModels().iterator().next() : null;
    }

    @Override
    public Collection<JTable> getTables() {
        if (this.getLayer() == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.getPanel().getTablePanel(this.getLayer()).getTable());
    }

    @Override
    public Map<String, ExcelExport.TableAttributes> getTablesWithLayerName() {
        if (this.getLayer() == null) {
            return new HashMap<String, ExcelExport.TableAttributes>();
        }
        JTable table = this.getPanel().getTablePanel(this.getLayer()).getTable();
        ExcelExport.TableAttributes tableAttributes = new ExcelExport.TableAttributes(table, Set.of(Integer.valueOf(0)));
        return Collections.singletonMap(this.getLayer().getName(), tableAttributes);
    }
}

