/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.attributes;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.ToolTipWriter;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import de.riwagis.icons.IconLoader;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;

public class MapToolTipsPlugIn
extends AbstractPlugIn {
    private static final String SHOW_MAP_TOOLTIPS_KEY = MapToolTipsPlugIn.class.getName() + "_SHOW_TOOLTIPS";
    private static final ImageIcon TOOLTIP_ICON_ON = IconLoader.svgIcon((String)"common_tooltip.svg");
    private static final ImageIcon TOOLTIP_ICON_OFF = IconLoader.svgIcon((String)"common_tooltip_off.svg");

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        JUMPWorkbench.getFrame().addKeyboardShortcut(84, 128, this, this.createEnableCheck());
        ToolTipWriter.setEnabled(PersistentBlackboardPlugIn.get().get(SHOW_MAP_TOOLTIPS_KEY, true));
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(component -> {
            if (component instanceof JCheckBoxMenuItem) {
                ((JCheckBoxMenuItem)component).setSelected(ToolTipWriter.isEnabled());
            }
            if (component instanceof JButton) {
                if (ToolTipWriter.isEnabled()) {
                    ((JButton)component).setIcon(TOOLTIP_ICON_ON);
                } else {
                    ((JButton)component).setIcon(TOOLTIP_ICON_OFF);
                }
            }
            return null;
        }).add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck());
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.svgIcon((String)"common_tooltip.svg");
    }

    @Override
    public String getName() {
        return I18N.get("ui.plugin.MapToolTipsPlugIn.map-tooltips");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        ToolTipWriter.setEnabled(!ToolTipWriter.isEnabled());
        PersistentBlackboardPlugIn.get().put(SHOW_MAP_TOOLTIPS_KEY, ToolTipWriter.isEnabled());
        return true;
    }
}

