/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.attributes;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.FeatureEventType;
import com.vividsolutions.jump.workbench.model.LabelLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.components.ColumnBasedTableModel;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.riwajump.data.Filters;
import de.riwagis.riwajump.model.attribute.AttributeProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.event.TableModelEvent;
import lombok.Generated;
import org.geotools.feature.FeatureIterator;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayerTableModel
extends ColumnBasedTableModel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LayerTableModel.class);
    public static final String FID_COLUMN_HEADER = "FID";
    private Layer layer;
    private HashMap<String, SimpleFeature> fidsForFeatures = new HashMap();
    private ArrayList<String> rowIndex = new ArrayList();
    private SimpleFeatureType schema;
    private List<AttributeProperty> attributeProperties;
    private boolean loadDataFromDatabase = false;
    private boolean hasAddedOrDeletedFeatures = false;
    private TableRefreshListener tableRefreshListener = null;
    private ColumnBasedTableModel.Column fidColumn = new MyColumn(this, "FID", String.class){

        @Override
        protected Object getValue(SimpleFeature feature) {
            return feature.getID();
        }

        @Override
        protected void setValue(Object value, SimpleFeature feature) {
            Assert.shouldNeverReachHere();
        }
    };
    private ColumnBasedTableModel.Column buttonColumn = new MyColumn(this, " ", null){

        @Override
        protected Object getValue(SimpleFeature feature) {
            return null;
        }

        @Override
        protected void setValue(Object value, SimpleFeature feature) {
            Assert.shouldNeverReachHere();
        }
    };
    private final LayerListener layerListener = new LayerListener(){

        @Override
        public void categoryChanged(CategoryEvent e) {
        }

        @Override
        public void featuresChanged(FeatureEvent e) {
            if (e.getLayer() != LayerTableModel.this.getLayer()) {
                return;
            }
            if (e.getType() == FeatureEventType.DELETED) {
                LayerTableModel.this.removeAll(e.getFeatures());
            }
            if (e.getType() == FeatureEventType.ATTRIBUTES_MODIFIED || e.getType() == FeatureEventType.GEOMETRY_MODIFIED) {
                LayerTableModel.this.updateAll(e.getFeatures());
            }
        }

        @Override
        public void layerChanged(LayerEvent e) {
            if (e.getLayerable() != LayerTableModel.this.getLayer()) {
                return;
            }
            if (e.getType() == LayerEventType.METADATA_CHANGED && !FeatureUtil.isFeatureTypeEqual((SimpleFeatureType)LayerTableModel.this.schema, (SimpleFeatureType)LayerTableModel.this.layer.getFeatureType(), (boolean)true) || e.getType() == LayerEventType.APPEARANCE_CHANGED || !LayerTableModel.this.attributeProperties.equals(LayerTableModel.this.layer.getAttributeTable().getAttributeProperties())) {
                try {
                    for (Filter filter : LayerTableModel.this.createFidFilters()) {
                        FeatureIterator<SimpleFeature> featureIterator = LayerTableModel.this.layer.getFeatureIterator(filter);
                        try {
                            while (featureIterator.hasNext()) {
                                SimpleFeature feature = (SimpleFeature)featureIterator.next();
                                LayerTableModel.this.fidsForFeatures.replace(feature.getID(), feature);
                            }
                        }
                        finally {
                            if (featureIterator == null) continue;
                            featureIterator.close();
                        }
                    }
                    LayerTableModel.this.initColumns(LayerTableModel.this.layer);
                    LayerTableModel.this.fireTableChanged(new TableModelEvent(LayerTableModel.this, -1));
                }
                catch (Exception ex) {
                    log.error("Error in LayerTableModel", (Throwable)ex);
                }
            }
            if (e.getType() == LayerEventType.TABLE_DATA_CHANGED) {
                if (LayerTableModel.this.tableRefreshListener != null) {
                    LayerTableModel.this.tableRefreshListener.refreshTable();
                }
                LayerTableModel.this.updateAddedOrDeletedFeatureState();
            }
        }
    };

    public TableRefreshListener getTableRefreshListener() {
        return this.tableRefreshListener;
    }

    public void setTableRefreshListener(TableRefreshListener tableRefreshListener) {
        this.tableRefreshListener = tableRefreshListener;
    }

    public boolean isAddedFeature(SimpleFeature feature) {
        return this.layer.isAddedFeature(feature.getID());
    }

    public boolean isDeletedFeature(SimpleFeature feature) {
        return this.layer.isDeletedFeature(feature.getID());
    }

    public boolean isModifiedFeature(SimpleFeature feature) {
        return this.layer.isModifiedFeature(feature.getID());
    }

    private List<Filter> createFidFilters() {
        if (this.layer.isFMDEditable() && !this.layer.getFMD().getEditInOtherDatatype()) {
            List<String> persistedFids = this.fidsForFeatures.entrySet().stream().filter(f -> !this.isAddedFeature((SimpleFeature)f.getValue()) && !this.isDeletedFeature((SimpleFeature)f.getValue())).map(f -> (String)f.getKey()).map(FeatureUtil::getFeatureIDWithoutTable).toList();
            return Filters.createPartitionedFiltersForFIDs(persistedFids);
        }
        return Collections.singletonList(Filter.INCLUDE);
    }

    public LayerTableModel(Layer layer, boolean loadDataFromDatabase) {
        this.layer = layer;
        this.loadDataFromDatabase = loadDataFromDatabase;
        layer.getLayerManager().addLayerListener(this.layerListener);
        this.initColumns(layer);
    }

    private void initColumns(final Layer layer) {
        this.schema = layer.getFeatureType();
        this.attributeProperties = new ArrayList<AttributeProperty>(layer.getAttributeTable().getAttributeProperties());
        ArrayList<ColumnBasedTableModel.Column> columns = new ArrayList<ColumnBasedTableModel.Column>();
        columns.add(this.buttonColumn);
        columns.add(this.fidColumn);
        for (int i = 0; i < this.attributeProperties.size(); ++i) {
            AttributeProperty attributeProp = this.attributeProperties.get(i);
            if (!attributeProp.isVisible() || this.schema.getDescriptor(attributeProp.getName()) instanceof GeometryDescriptor) continue;
            String displayedName = attributeProp.getAlias().isEmpty() ? attributeProp.getName() : attributeProp.getAlias();
            final int j = this.schema.indexOf(attributeProp.getName());
            columns.add(new MyColumn(displayedName, this.schema.getDescriptor(attributeProp.getName()).getType().getBinding(), attributeProp.getName()){

                @Override
                protected Object getValue(SimpleFeature feature) {
                    Object value = null;
                    try {
                        value = feature.getAttribute(j);
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        log.error("Error in LayerTableModel", (Throwable)ex);
                    }
                    return value;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void setValue(Object value, SimpleFeature feature) {
                    if (this.isOldAndNewValueEqual(feature.getAttribute(j), value)) {
                        return;
                    }
                    try {
                        layer.getLayerManager().getUndoableEditReceiver().startReceiving();
                        final SimpleFeature oldFeature = FeatureUtil.cloneFeature((SimpleFeature)feature);
                        final SimpleFeature newFeature = FeatureUtil.cloneFeature((SimpleFeature)feature);
                        newFeature.setAttribute(j, value);
                        UndoableCommand command = new UndoableCommand(I18N.get("ui.plugin.LayerTableModel.edit") + " " + LayerTableModel.this.schema.getDescriptor(j).getLocalName()){

                            @Override
                            public void execute() {
                                layer.getLayerManager().setFiringEvents(false);
                                try {
                                    layer.editFeature(Arrays.asList(newFeature), 2);
                                }
                                finally {
                                    layer.getLayerManager().setFiringEvents(true);
                                    LayerTableModel.this.fireFeatureChangedEvent(newFeature, oldFeature);
                                }
                            }

                            @Override
                            public void unexecute() {
                                layer.getLayerManager().setFiringEvents(false);
                                try {
                                    layer.editFeature(Arrays.asList(oldFeature), 2);
                                }
                                finally {
                                    layer.getLayerManager().setFiringEvents(true);
                                    LayerTableModel.this.fireFeatureChangedEvent(oldFeature, newFeature);
                                }
                            }
                        };
                        command.execute();
                        layer.getLayerManager().getUndoableEditReceiver().receive(command.toUndoableEdit());
                    }
                    catch (Exception e) {
                        log.error("Could not change field in attribute table", (Throwable)e);
                        WorkbenchFrame.handleThrowable(e, WorkbenchContext.getFrame());
                    }
                    finally {
                        layer.getLayerManager().getUndoableEditReceiver().stopReceiving();
                    }
                }

                private boolean isOldAndNewValueEqual(Object oldvalue, Object newvalue) throws IndexOutOfBoundsException {
                    if (Objects.equals(oldvalue, newvalue)) {
                        return true;
                    }
                    return oldvalue != null && newvalue != null && oldvalue instanceof Number && newvalue instanceof Number && ((Number)oldvalue).doubleValue() == ((Number)newvalue).doubleValue();
                }
            });
        }
        this.setColumns(columns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batchCommitEditedFeatures(final List<SimpleFeature> updatedFeatures, final List<SimpleFeature> oldFeatures, String commandName) {
        try {
            this.layer.getLayerManager().getUndoableEditReceiver().startReceiving();
            UndoableCommand command = new UndoableCommand(commandName){

                @Override
                public void execute() {
                    this.updateFeatures(updatedFeatures, oldFeatures);
                }

                @Override
                public void unexecute() {
                    this.updateFeatures(oldFeatures, updatedFeatures);
                }

                protected void updateFeatures(List<SimpleFeature> updatedFeatures2, List<SimpleFeature> oldFeatures2) {
                    LayerTableModel.this.layer.getLayerManager().setFiringEvents(false);
                    try {
                        LayerTableModel.this.layer.editFeature(updatedFeatures2, 2);
                        LayerTableModel.this.layer.getLayerManager().setFiringEvents(true);
                        LayerTableModel.this.fireFeatureChangedEvent(updatedFeatures2, oldFeatures2);
                    }
                    catch (Exception e) {
                        LayerTableModel.this.layer.getLayerManager().setFiringEvents(true);
                        throw e;
                    }
                }
            };
            command.execute();
            this.layer.getLayerManager().getUndoableEditReceiver().receive(command.toUndoableEdit());
        }
        catch (Exception e) {
            log.error("Could not batch update data in attribute table", (Throwable)e);
            WorkbenchFrame.handleThrowable(e, WorkbenchContext.getFrame());
        }
        finally {
            this.layer.getLayerManager().getUndoableEditReceiver().stopReceiving();
        }
    }

    private void fireFeatureChangedEvent(SimpleFeature feat, SimpleFeature oldfeat) {
        this.fireFeatureChangedEvent(Arrays.asList(feat), Arrays.asList(oldfeat));
    }

    private void fireFeatureChangedEvent(List<SimpleFeature> updatedFeatures, List<SimpleFeature> oldFeatures) {
        this.layer.getLayerManager().fireFeaturesAttChanged(updatedFeatures, FeatureEventType.ATTRIBUTES_MODIFIED, this.layer, oldFeatures);
    }

    public Layer getLayer() {
        return this.layer;
    }

    public SimpleFeature getFeature(int row) {
        if (row >= this.rowIndex.size()) {
            return null;
        }
        String index = this.rowIndex.get(row);
        return this.fidsForFeatures.get(index);
    }

    public int getFeatureRow(SimpleFeature feature) {
        return this.rowIndex.indexOf(feature.getID());
    }

    public int getRow(String strID) {
        return this.rowIndex.indexOf(strID);
    }

    @Override
    public int getRowCount() {
        return this.rowIndex.size();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (!this.layer.isEditable() || this.layer.getFMD().getEditInOtherDatatype()) {
            return false;
        }
        if (this.layer instanceof LabelLayer && !((LabelLayer)this.layer).isLabelTextEditable()) {
            return false;
        }
        if (this.getColumn(columnIndex) == this.fidColumn) {
            return false;
        }
        return this.getColumn(columnIndex) != this.buttonColumn;
    }

    public void clear() {
        this.fidsForFeatures.clear();
        this.rowIndex.clear();
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void removeAll(Collection<SimpleFeature> featuresToRemove) {
        this.updateAddedOrDeletedFeatureState();
        featuresToRemove.forEach(feature -> {
            if (this.fidsForFeatures.remove(feature.getID()) == null) {
                log.error("Feature with ID {} not in list. Maybe concurrent editing.", (Object)feature.getID());
            }
        });
        this.rowIndex.removeAll(featuresToRemove.stream().map(s -> s.getID()).toList());
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void updateAll(Collection<SimpleFeature> newFeatures) {
        this.updateAddedOrDeletedFeatureState();
        newFeatures.forEach(feat -> this.fidsForFeatures.replace(feat.getID(), (SimpleFeature)feat));
        if (newFeatures.size() == 1) {
            String featureId = newFeatures.iterator().next().getID();
            int rowIndexNum = this.rowIndex.indexOf(featureId);
            if (rowIndexNum >= 0) {
                this.fireTableChanged(new TableModelEvent(this, rowIndexNum));
            } else {
                this.fireTableChanged(new TableModelEvent(this));
            }
        } else {
            this.fireTableChanged(new TableModelEvent(this));
        }
    }

    public void addAll(Collection<SimpleFeature> newFeatures) {
        this.updateAddedOrDeletedFeatureState();
        newFeatures.forEach(feat -> {
            if (this.fidsForFeatures.put(feat.getID(), (SimpleFeature)feat) == null) {
                this.rowIndex.add(feat.getID());
            }
        });
        this.fireTableChanged(new TableModelEvent(this));
    }

    private void updateAddedOrDeletedFeatureState() {
        this.hasAddedOrDeletedFeatures = this.layer.hasAddedFeatures() || this.layer.hasDeletedFeatures();
    }

    public void dispose() {
        if (this.layer != null && this.layer.getLayerManager() != null) {
            this.layer.getLayerManager().removeLayerListener(this.layerListener);
        }
        this.fidsForFeatures.clear();
        this.rowIndex.clear();
    }

    public List<SimpleFeature> getFeatures() {
        List<SimpleFeature> lstFeatures = this.getFeaturesAsList();
        return Collections.unmodifiableList(lstFeatures);
    }

    private List<SimpleFeature> getFeaturesAsList() {
        return new ArrayList<SimpleFeature>(this.fidsForFeatures.values());
    }

    public Map<String, SimpleFeature> getFeaturesInternal() {
        return Collections.unmodifiableMap(this.fidsForFeatures);
    }

    public String getType(int column) {
        return null;
    }

    public boolean isLoadDataFromDatabaseEnabled() {
        return this.loadDataFromDatabase;
    }

    public static interface TableRefreshListener {
        public void refreshTable();
    }

    private abstract class MyColumn
    extends ColumnBasedTableModel.Column {
        public MyColumn(String name, Class dataClass) {
            this(name, dataClass, name);
        }

        public MyColumn(String name, Class dataClass, String attributeName) {
            super(LayerTableModel.this, name, dataClass, attributeName);
        }

        @Override
        public Object getValueAt(int rowIndex) {
            SimpleFeature feature = LayerTableModel.this.getFeature(rowIndex);
            if (feature == null) {
                return null;
            }
            return this.getValue(feature);
        }

        @Override
        public void setValueAt(Object value, int rowIndex) {
            this.setValue(value, LayerTableModel.this.getFeature(rowIndex));
        }

        protected abstract Object getValue(SimpleFeature var1);

        protected abstract void setValue(Object var1, SimpleFeature var2);
    }
}

