/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.attributes;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.ExcelExport;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.AttributeTab;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.GeometryInfoTab;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.InfoModel;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManager;
import de.riwagis.icons.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

public class InfoPanel
extends JPanel {
    private BorderLayout borderLayout1 = new BorderLayout();
    private AttributeTab attributeTab;
    private InfoModel model = new InfoModel();
    private GeometryInfoTab geometryInfoTab;
    private JTabbedPane tabbedPane = new JTabbedPane();

    public InfoPanel(WorkbenchContext workbenchContext, TaskFrame taskFrame) {
        this.geometryInfoTab = new GeometryInfoTab(this.model, workbenchContext);
        this.attributeTab = new AttributeTab(this.model, workbenchContext, taskFrame){

            @Override
            public Collection<JTable> getTables() {
                return this.getModel().getLayers().stream().map(layer -> this.getPanel().getTablePanel((Layer)layer).getTable()).collect(Collectors.toList());
            }

            @Override
            public Map<String, ExcelExport.TableAttributes> getTablesWithLayerName() {
                HashMap<String, ExcelExport.TableAttributes> map = new HashMap<String, ExcelExport.TableAttributes>();
                this.getModel().getLayers().forEach(layer -> map.computeIfAbsent(layer.getName(), k -> new ExcelExport.TableAttributes(this.getPanel().getTablePanel((Layer)layer).getTable(), Set.of(Integer.valueOf(0)))));
                return map;
            }
        };
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        workbenchContext.getLayerManager().addLayerListener(new RemoveTableLayerListener());
        this.tabbedPane.addTab("", IconLoader.svgIcon((String)"table_show.svg"), this.attributeTab, I18N.get("ui.InfoPanel.table-view"));
        this.tabbedPane.addTab("", IconLoader.svgIcon((String)"common_view_html.svg"), this.geometryInfoTab, I18N.get("ui.InfoPanel.html-view"));
    }

    public JPanel getAttributeTab() {
        return this.attributeTab;
    }

    public JPanel getGeometryTab() {
        return this.geometryInfoTab;
    }

    public TaskFrame getTaskFrame() {
        return this.attributeTab.getTaskFrame();
    }

    public void setSelectedTab(JPanel tab) {
        this.tabbedPane.setSelectedComponent(tab);
    }

    public InfoModel getModel() {
        return this.model;
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.tabbedPane.setTabPlacement(2);
        this.add((Component)this.tabbedPane, "Center");
    }

    public SelectionManager getSelectionManager() {
        return this.attributeTab.getPanel().getSelectionManager();
    }

    public LayerViewPanel getLayerViewPanel() {
        return this.getTaskFrame().getLayerViewPanel();
    }

    public void finalize() {
        try {
            this.model.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class RemoveTableLayerListener
    implements LayerListener {
        private RemoveTableLayerListener() {
        }

        @Override
        public void featuresChanged(FeatureEvent e) {
        }

        @Override
        public void layerChanged(LayerEvent e) {
            if (e.getType() == LayerEventType.REMOVED && InfoPanel.this.model.getLayers().contains(e.getLayerable())) {
                SwingUtilities.invokeLater(() -> InfoPanel.this.model.remove((Layer)e.getLayerable()));
            }
        }

        @Override
        public void categoryChanged(CategoryEvent e) {
        }
    }
}

