/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.attributes;

import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.InfoModelListener;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.LayerTableModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.opengis.feature.simple.SimpleFeature;

public class InfoModel {
    private final Map<Layer, LayerTableModel> layerToTableModelMap = new LinkedHashMap<Layer, LayerTableModel>();
    private final Collection<InfoModelListener> listeners = new ArrayList<InfoModelListener>();
    private boolean loadDataFromDatabase = false;

    public void dispose() {
        for (Layer layer : Collections.unmodifiableCollection(this.getLayers())) {
            this.remove(layer);
        }
    }

    public InfoModel() {
    }

    public InfoModel(boolean loadDataFromDatabase) {
        this.loadDataFromDatabase = loadDataFromDatabase;
    }

    public Collection<LayerTableModel> getLayerTableModels() {
        return Collections.unmodifiableCollection(this.layerToTableModelMap.values());
    }

    public void add(Layer layer, Collection<SimpleFeature> features) {
        boolean layerNew = !this.layerToTableModelMap.containsKey(layer);
        LayerTableModel layerTableModel = this.getTableModel(layer);
        layerTableModel.addAll(features);
        if (layerNew) {
            for (InfoModelListener listener : this.listeners) {
                listener.layerAdded(layerTableModel);
            }
        }
    }

    public void remove(Layer layer) {
        if (this.layerToTableModelMap.containsKey(layer)) {
            LayerTableModel layerTableModel = this.getTableModel(layer);
            layerTableModel.dispose();
            this.layerToTableModelMap.remove(layer);
            for (InfoModelListener listener : this.listeners) {
                listener.layerRemoved(layerTableModel);
            }
        }
    }

    public void clear() {
        for (Layer layer : Collections.unmodifiableCollection(new HashSet<Layer>(this.layerToTableModelMap.keySet()))) {
            this.remove(layer);
        }
    }

    public LayerTableModel getTableModel(Layer layer) {
        if (!this.layerToTableModelMap.containsKey(layer)) {
            this.layerToTableModelMap.put(layer, new LayerTableModel(layer, this.loadDataFromDatabase));
        }
        return this.layerToTableModelMap.get(layer);
    }

    public List<Layer> getLayers() {
        return List.copyOf(this.layerToTableModelMap.keySet());
    }

    public void addListener(InfoModelListener listener) {
        this.listeners.add(listener);
    }

    public boolean isLoadDataFromDatabase() {
        return this.loadDataFromDatabase;
    }
}

