/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.attributes;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.AbstractCadLayer;
import com.vividsolutions.jump.workbench.model.DimLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerStyleCollection;
import com.vividsolutions.jump.workbench.model.RiwaJumpModelUtilities;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import de.riwagis.riwajump.model.style.BasicStyleModel;
import de.riwagis.riwajump.model.style.DimStyleModel;
import java.awt.Color;
import java.util.Collection;
import java.util.Map;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;

public class FeatureInfoWriter {
    public static Writer ATTRIBUTE_WRITER = new Writer(){

        @Override
        public String toHTML(SimpleFeature feature) {
            StringBuilder s = new StringBuilder();
            for (int i = 0; i < feature.getFeatureType().getAttributeCount(); ++i) {
                if (feature.getAttribute(i) instanceof Geometry) continue;
                s.append("<br><b>" + GUIUtil.escapeHTML(feature.getFeatureType().getDescriptor(i).getLocalName(), false, false) + ":</b> ");
                if (feature.getAttribute(i) == null) continue;
                s.append(GUIUtil.escapeHTML(feature.getAttribute(i).toString(), false, false));
            }
            return s.toString();
        }
    };
    public static Writer EMPTY_WRITER = new Writer(){

        @Override
        public String toHTML(SimpleFeature feature) {
            return "";
        }
    };
    private static final String BEIGE = "#E6E6E6";
    private static final String WHITE = "#FFFFFF";
    private static final String COLOR1 = "#E6E6E6";
    private static final String COLOR2 = "#FFFFFF";
    private boolean workingAroundJEditorPaneBug = true;
    private final int maxFeatures2Display;

    public FeatureInfoWriter() {
        this(Integer.MAX_VALUE);
    }

    public FeatureInfoWriter(int maxFeatures2Display) {
        this.maxFeatures2Display = maxFeatures2Display;
    }

    public Color sidebarColor(Layer layer) {
        LayerStyleCollection scol = layer.getValidLayerStyleCollection();
        if (scol == null) {
            scol = layer.getDefaultLayerStyleCollection();
        }
        Color basicColor = Color.WHITE;
        int alpha = 255;
        if (layer instanceof DimLayer) {
            basicColor = RiwaJumpModelUtilities.colorByColorModel(scol.getStyle(DimStyleModel.class).getColorDimLine());
            alpha = scol.getStyle(DimStyleModel.class).getIntAlpha();
        } else if (layer instanceof AbstractCadLayer) {
            basicColor = Color.WHITE;
            alpha = 255;
        } else {
            BasicStyleModel bStyle = scol.getBasicStyle();
            if (bStyle.isRenderingFill()) {
                basicColor = RiwaJumpModelUtilities.colorByColorModel(bStyle.getFillColor());
            } else if (bStyle.doesRenderLine()) {
                basicColor = RiwaJumpModelUtilities.colorByColorModel(bStyle.retrieveLeadingLineStyle().getLineColor());
            }
            alpha = scol.getBasicStyle().getIntAlpha();
        }
        return GUIUtil.toSimulatedTransparency(GUIUtil.alphaColor(basicColor, alpha));
    }

    public String writeFeatureInfo(Map layerToFeaturesMap, Writer featureWriter, Writer attributeWriter) {
        if (layerToFeaturesMap.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int featureCount = 0;
        int featureCountNotDisplayed = 0;
        for (Layer layer : layerToFeaturesMap.keySet()) {
            Collection features = (Collection)layerToFeaturesMap.get(layer);
            stringBuilder.append("<table width=100%>");
            stringBuilder.append("<tr>");
            stringBuilder.append("<td width=5 bgcolor=" + this.toHTML(this.sidebarColor(layer)) + ">");
            stringBuilder.append("</td>");
            stringBuilder.append("<td width=100%>");
            stringBuilder.append("<table width=100%>");
            stringBuilder.append("<tr>");
            stringBuilder.append("<td bgcolor=#FFFFCC>");
            stringBuilder.append("<B>" + layer.getName() + "</B>");
            stringBuilder.append("</td>");
            stringBuilder.append("</tr>");
            String bgcolor = "#E6E6E6";
            for (SimpleFeature feature : features) {
                bgcolor = !bgcolor.equals("#E6E6E6") ? "#E6E6E6" : "#FFFFFF";
                if (this.maxFeatures2Display >= ++featureCount) {
                    stringBuilder.append("<tr bgcolor='" + bgcolor + "'>");
                    stringBuilder.append("<td>");
                    stringBuilder.append("FID <font color='#3300cc'><b>" + feature.getID() + "</b></font>");
                    if (featureWriter != EMPTY_WRITER) {
                        this.append(feature, stringBuilder, featureWriter);
                    }
                    if (attributeWriter != EMPTY_WRITER) {
                        stringBuilder.append("            " + attributeWriter.toHTML(feature));
                    }
                    stringBuilder.append("</td>");
                    stringBuilder.append("</tr>");
                    continue;
                }
                ++featureCountNotDisplayed;
            }
            if (featureCountNotDisplayed > 0) {
                stringBuilder.append("<tr>");
                stringBuilder.append("<td><font color='red'><b>");
                stringBuilder.append(I18N.getMessage("ui.FeatureInfoWriter.features-not-displayed", this.maxFeatures2Display, featureCountNotDisplayed));
                stringBuilder.append("</b></font></td>");
                stringBuilder.append("</tr>");
            }
            stringBuilder.append("</table>");
            stringBuilder.append("</td>");
            stringBuilder.append("</tr>");
            stringBuilder.append("</table>");
        }
        return stringBuilder.toString();
    }

    private String pad(String s) {
        return s.length() == 1 ? "0" + s : s;
    }

    private String toHTML(Color color) {
        Object colorString = "#";
        colorString = (String)colorString + this.pad(Integer.toHexString(color.getRed()));
        colorString = (String)colorString + this.pad(Integer.toHexString(color.getGreen()));
        colorString = (String)colorString + this.pad(Integer.toHexString(color.getBlue()));
        return colorString;
    }

    private void append(SimpleFeature feature, StringBuilder stringBuilder, Writer featureWriter) {
        String text = featureWriter.toHTML(feature);
        if (this.workingAroundJEditorPaneBug && stringBuilder.length() + featureWriter.toHTML(feature).length() > 30768) {
            text = I18N.get("ui.FeatureInfoWriter.text-representation-of-geometry-is-too-large");
        }
        stringBuilder.append("<br>").append(text);
    }

    public static interface Writer {
        public String toHTML(SimpleFeature var1);
    }
}

