/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.attributes;

import com.google.common.collect.Lists;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.featureinfo.FeatureInfoAction;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.featureinfo.GisDialogFeatureInfoAction;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.featureinfo.InterfaceCallFeatureInfoAction;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.featureinfo.ObjectInfoFeatureInfoAction;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManager;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManagerProxy;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.gui.components.WaitDialog;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import lombok.Generated;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureInfoPlugIn
extends AbstractPlugIn {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FeatureInfoPlugIn.class);
    public static final ImageIcon ICON = IconLoader.svgIcon((String)"common_info.svg");
    private final List<FeatureInfoAction> featureActions;
    private final List<FeatureInfoAction> featureActionsWithoutInterface;

    public FeatureInfoPlugIn() {
        this(FeatureInfoPlugIn.createDefaultFeatureActions());
    }

    protected FeatureInfoPlugIn(List<FeatureInfoAction> featureActions) {
        this.featureActions = featureActions;
        this.featureActionsWithoutInterface = featureActions.stream().filter(a -> !(a instanceof InterfaceCallFeatureInfoAction)).collect(Collectors.toList());
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(checkFactory.createWindowWithSelectionManagerMustBeActiveCheck()).add(checkFactory.createWindowWithLayerManagerMustBeActiveCheck()).add(checkFactory.createWindowWithAssociatedTaskFrameMustBeActiveCheck()).add(checkFactory.createAtLeastNItemsMustBeSelectedCheck(1));
    }

    @Override
    public ImageIcon getIcon() {
        return ICON;
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        SelectionManager selectionManager = ((SelectionManagerProxy)((Object)context.getActiveInternalFrame())).getSelectionManager();
        return this.executeForCustomSelection(context, selectionManager::getLayersWithSelectedItems, selectionManager::getFeaturesWithSelectedItems, this.featureActions);
    }

    public boolean executeForCustomSelectionWithoutInterface(PlugInContext context, Supplier<Collection<Layer>> layerSupplier, Function<Layer, Collection<SimpleFeature>> featureSupplier) throws Exception {
        return this.executeForCustomSelection(context, layerSupplier, featureSupplier, this.featureActionsWithoutInterface);
    }

    private boolean executeForCustomSelection(PlugInContext context, Supplier<Collection<Layer>> layerSupplier, Function<Layer, Collection<SimpleFeature>> featureSupplier, List<FeatureInfoAction> actionsToTest) throws Exception {
        WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)context.getWorkbenchFrame(), (String)I18N.get("ui.plugin.ViewAttributesPlugIn.please-wait"));
        Runnable run = () -> {
            try {
                for (FeatureInfoAction action : actionsToTest) {
                    action.reset(context);
                }
                for (Layer layer : (Collection)layerSupplier.get()) {
                    boolean alreadyMatched = false;
                    for (FeatureInfoAction action : actionsToTest) {
                        alreadyMatched |= action.process(layer, featureSupplier, alreadyMatched, context);
                    }
                }
            }
            catch (Exception e) {
                dlgWait.setError(e);
            }
        };
        dlgWait.addWorkToDo(run);
        dlgWait.setVisible(true);
        if (dlgWait.getError() != null) {
            throw dlgWait.getError();
        }
        for (FeatureInfoAction action : Lists.reverse(actionsToTest)) {
            action.execute(context);
        }
        return true;
    }

    private static List<FeatureInfoAction> createDefaultFeatureActions() {
        ArrayList<FeatureInfoAction> defaultActions = new ArrayList<FeatureInfoAction>();
        if (JUMPWorkbench.gisContextAvailable()) {
            defaultActions.add(new GisDialogFeatureInfoAction());
            defaultActions.add(new InterfaceCallFeatureInfoAction());
        }
        defaultActions.add(new ObjectInfoFeatureInfoAction());
        return defaultActions;
    }
}

