/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.attributes;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerNamePanel;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.gui.components.WaitDialog;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;

public class ClearSelectedLayerGraphicsFilterPlugIn
extends AbstractPlugIn {
    public static final ImageIcon ICON = IconLoader.svgIcon((String)"filter_remove_all.svg");

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)context.getWorkbenchFrame(), (String)I18N.get("ui.plugin.ViewAttributesPlugIn.please-wait"));
        Runnable run = () -> {
            try {
                List<Layerable> selectedLayers = this.getSupportedLayers(context);
                for (Layerable layerable : selectedLayers) {
                    Layer layer = (Layer)layerable;
                    if (!layer.isDataFiltered()) continue;
                    layer.setFidFilterWhiteList(null);
                    layer.fireAppearanceChanged();
                }
            }
            catch (Exception e) {
                dlgWait.setError(e);
            }
        };
        dlgWait.addWorkToDo(run);
        dlgWait.setVisible(true);
        if (dlgWait.getError() != null) {
            throw dlgWait.getError();
        }
        return true;
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(checkFactory.createWindowWithSelectionManagerMustBeActiveCheck()).add(this.createSelectedLayersFidFilterCheck());
    }

    @Override
    public ImageIcon getIcon() {
        return ICON;
    }

    public EnableCheck createSelectedLayersFidFilterCheck() {
        return component -> {
            PlugInContext plugInContext = WorkbenchContext.getInstance().createPlugInContext();
            List<Layerable> selectedLayers = this.getSupportedLayers(plugInContext);
            for (Layerable layerable : selectedLayers) {
                Layer layer = (Layer)layerable;
                if (!layer.isDataFiltered()) continue;
                return null;
            }
            return I18N.get("com.vividsolutions.jump.workbench.ui.plugin.attributes.ClearSelectedLayerGraphicsFilterPlugIn.A-graphics-filter-must-be-active");
        };
    }

    private List<Layerable> getSupportedLayers(PlugInContext plugInContext) {
        LayerNamePanel lnp = plugInContext.getLayerNamePanel();
        if (lnp == null) {
            return Collections.emptyList();
        }
        ArrayList<Layerable> lstLy = new ArrayList<Layerable>();
        Collection<Category> colCat = lnp.getSelectedCategories();
        for (Category cat : colCat) {
            for (Layerable candidate : cat.getAllLayerables()) {
                if (!(candidate instanceof Layer) || lstLy.contains(candidate)) continue;
                lstLy.add(candidate);
            }
        }
        Collection<Layer> colLy = lnp.selectedNodes(Layer.class);
        for (Layerable layerable : colLy) {
            if (lstLy.contains(layerable)) continue;
            lstLy.add(layerable);
        }
        return lstLy;
    }
}

