/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.attributes;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.gui.components.WaitDialog;
import java.awt.Window;
import java.util.Collection;
import javax.swing.ImageIcon;

public class ClearAllGraphicsFilterPlugIn
extends AbstractPlugIn {
    public static final ImageIcon ICON = IconLoader.svgIcon((String)"filter_remove_all.svg");

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)context.getWorkbenchFrame(), (String)I18N.get("ui.plugin.ViewAttributesPlugIn.please-wait"));
        Runnable run = () -> {
            try {
                Collection<Layer> layers = this.getLayers(context.getLayerManager());
                for (Layer layer : layers) {
                    if (!layer.isDataFiltered()) continue;
                    layer.setFidFilterWhiteList(null);
                    layer.fireAppearanceChanged();
                    layer.fireLayerChanged(LayerEventType.TABLE_DATA_CHANGED);
                }
            }
            catch (Exception e) {
                dlgWait.setError(e);
            }
        };
        dlgWait.addWorkToDo(run);
        dlgWait.setVisible(true);
        if (dlgWait.getError() != null) {
            throw dlgWait.getError();
        }
        return true;
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(checkFactory.createTaskWindowMustBeActiveCheck());
    }

    @Override
    public ImageIcon getIcon() {
        return ICON;
    }

    protected Collection<Layer> getLayers(LayerManager layerManager) {
        return layerManager.getLayers();
    }
}

