/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.attributes;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.ExcelExport;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.AbstractExportPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import de.riwagis.guitools.Tasks;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.OSFile;
import java.awt.Component;
import java.io.File;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang3.StringUtils;

public class AttributesToExcelPlugIn
extends AbstractExportPlugIn {
    public static final String NAME = I18N.get("export-tables-to-excel");
    public static final String ICON_NAME = "export_excel.svg";
    public static final ImageIcon ICON_EXPORT_2_EXCEL = IconLoader.svgIcon((String)"export_excel.svg");
    public static final FileFilter FILE_FILTER = GUISupport.createFileFilter((String)I18N.get("excel"), (String[])new String[]{"xlsx"});
    private static final String KEY_LASTUSEDFILE = AttributesToExcelPlugIn.class.getName() + "_LASTUSEDFILE";
    private final Supplier<Map<String, ExcelExport.TableAttributes>> tablesSupplier;

    public AttributesToExcelPlugIn(Supplier<Map<String, ExcelExport.TableAttributes>> tablesSupplier) {
        this.tablesSupplier = tablesSupplier;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public ImageIcon getIcon() {
        return ICON_EXPORT_2_EXCEL;
    }

    @Override
    public EnableCheck createEnableCheck() {
        return new MultiEnableCheck().add(AttributesToExcelPlugIn.createExportAllowedCheck()).add(EnableCheckFactory.getInstance().createTaskWindowMustBeActiveCheck());
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        boolean bolYes;
        Map<String, ExcelExport.TableAttributes> tables = this.tablesSupplier.get();
        if (tables == null || tables.isEmpty()) {
            return false;
        }
        JFileChooser fileChooser = GUISupport.createJFileChooserOverwritePrompting();
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setFileFilter(FILE_FILTER);
        fileChooser.setSelectedFile(this.getLastUsedFile());
        int result = fileChooser.showSaveDialog(WorkbenchContext.getFrame());
        if (result == 1) {
            return false;
        }
        File outputFile = fileChooser.getSelectedFile();
        if (outputFile == null) {
            return false;
        }
        if (!StringUtils.endsWithIgnoreCase((CharSequence)outputFile.getName(), (CharSequence)".xlsx")) {
            outputFile = new File(outputFile.toString() + ".xlsx");
        }
        this.setLastUsedFile(outputFile);
        AtomicReference<Boolean> success = new AtomicReference<Boolean>(false);
        File excelFile = outputFile;
        Tasks.submit(() -> success.set(ExcelExport.writeFile(tables, excelFile)));
        if (success.get().booleanValue() && (bolYes = GUISupport.yesnobox((Component)WorkbenchContext.getFrame(), (String)I18N.get("do-you-want-to-display-exported-file"), (String)I18N.get("common.message")))) {
            OSFile.showFile((File)outputFile, (boolean)false);
        }
        return success.get();
    }

    private File getLastUsedFile() {
        String lastUsedFile = (String)PersistentBlackboardPlugIn.get().get(KEY_LASTUSEDFILE);
        if (lastUsedFile == null) {
            return null;
        }
        return new File(lastUsedFile);
    }

    private void setLastUsedFile(File file) {
        PersistentBlackboardPlugIn.get().put(KEY_LASTUSEDFILE, file.getAbsolutePath());
    }
}

