/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.attributes;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.plugin.AbstractExportPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import de.riwagis.icons.IconLoader;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import org.apache.commons.lang.StringUtils;

public class AttributesToClipboardPlugIn
extends AbstractExportPlugIn {
    public static final String NAME = I18N.get("ui.plugin.attributes.AttributesToClipboardPlugIn.name");
    public static final String ICON_NAME = "copy2clipboard.svg";
    public static final ImageIcon ICON_COPY_2_CLIPBOARD = IconLoader.svgIcon((String)"copy2clipboard.svg");
    private final Supplier<Collection<JTable>> tablesSupplier;
    private final NumberFormat numberFormat;
    private final DateFormat dateFormat;

    public AttributesToClipboardPlugIn(Supplier<Collection<JTable>> tablesSupplier) {
        this.tablesSupplier = tablesSupplier;
        this.numberFormat = NumberFormat.getInstance();
        this.numberFormat.setGroupingUsed(false);
        this.dateFormat = DateFormat.getDateInstance();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public ImageIcon getIcon() {
        return ICON_COPY_2_CLIPBOARD;
    }

    @Override
    public EnableCheck createEnableCheck() {
        return new MultiEnableCheck().add(AttributesToClipboardPlugIn.createExportAllowedCheck()).add(EnableCheckFactory.getInstance().createTaskWindowMustBeActiveCheck());
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Collection<JTable> tables = this.tablesSupplier.get();
        if (tables == null || tables.isEmpty()) {
            return false;
        }
        StringBuilder sb = new StringBuilder();
        for (JTable table : tables) {
            this.createContent(table, sb);
            sb.append("\n\n");
        }
        this.copyToClipboard(sb.toString());
        return true;
    }

    private void createContent(JTable table, StringBuilder sb) {
        int columnCount = table.getColumnCount();
        String header = this.getHeader(table, columnCount);
        sb.append(header).append(System.lineSeparator());
        String data = this.getRows(table, columnCount);
        sb.append(data);
    }

    private String getRows(JTable table, int columns) {
        return IntStream.range(0, table.getRowCount()).mapToObj(row -> this.getRow(table, columns, row)).collect(Collectors.joining(System.lineSeparator()));
    }

    private String getHeader(JTable table, int columns) {
        return IntStream.range(1, columns).mapToObj(table::getColumnName).collect(Collectors.joining("\t"));
    }

    private String getRow(JTable table, int columns, int row) {
        return IntStream.range(1, columns).mapToObj(column -> this.convertToString(table, row, column)).collect(Collectors.joining("\t"));
    }

    private String convertToString(JTable table, int row, int column) {
        Object value = table.getValueAt(row, column);
        if (value instanceof Number) {
            return this.numberFormat.format(value);
        }
        if (value instanceof Date) {
            return this.dateFormat.format(value);
        }
        return StringUtils.normalizeSpace((String)Objects.toString(value, ""));
    }

    private void copyToClipboard(String content) {
        StringSelection stringSelection = new StringSelection(content);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, (aClipboard, aContents) -> {});
    }
}

